/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.ServerType;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.TigerProxyApplication;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.tigerProxyStandalone.CfgStandaloneProxy;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.util.ArrayList;
import java.util.HashMap;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class TigerProxyServer
extends AbstractExternalTigerServer {
    private ConfigurableApplicationContext applicationContext;

    TigerProxyServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(TigerProxyServer.determineHostname(configuration, serverId), serverId, configuration, tigerTestEnvMgr);
    }

    @Override
    public void performStartup() {
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type(ServerType.TIGERPROXY).statusMessage("Ppre-start Tiger Proxy " + this.getServerId()).build());
        TigerProxyConfiguration reverseProxyCfg = this.getConfiguration().getTigerProxyCfg();
        CfgStandaloneProxy standaloneCfg = new CfgStandaloneProxy();
        standaloneCfg.setTigerProxy(reverseProxyCfg);
        if (reverseProxyCfg.getProxyRoutes() == null) {
            reverseProxyCfg.setProxyRoutes(new ArrayList());
        }
        if (reverseProxyCfg.getProxiedServer() != null) {
            this.getDestinationUrlFromProxiedServer(reverseProxyCfg);
        }
        reverseProxyCfg.getProxyRoutes().forEach(route -> {
            route.setFrom(this.getTigerTestEnvMgr().replaceSysPropsInString(route.getFrom()));
            route.setTo(this.getTigerTestEnvMgr().replaceSysPropsInString(route.getTo()));
        });
        this.statusMessage("Starting Tiger Proxy " + this.getServerId() + " at " + reverseProxyCfg.getAdminPort() + "...");
        this.applicationContext = new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).properties(new HashMap(TigerSerializationUtil.toMap((Object)standaloneCfg, (String[])new String[0]))).sources(new Class[]{TigerProxyApplication.class}).web(WebApplicationType.SERVLET).registerShutdownHook(false).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        this.waitForService(true);
        if (this.getStatus() == TigerServerStatus.STARTING) {
            this.waitForService(false);
        }
        this.statusMessage("Tiger Proxy " + this.getServerId() + " started");
    }

    @Override
    public void shutdown() {
        if (this.applicationContext != null && this.applicationContext.isRunning()) {
            this.applicationContext.close();
            this.setStatus(TigerServerStatus.STOPPED, "Stopped Tiger Proxy " + this.getServerId());
        } else {
            this.setStatus(TigerServerStatus.STOPPED, "Tiger Proxy " + this.getServerId() + " already stopped");
        }
    }

    private void getDestinationUrlFromProxiedServer(TigerProxyConfiguration cfg) {
        String destUrl = this.getTigerTestEnvMgr().getServers().keySet().stream().filter(srvid -> srvid.equals(cfg.getProxiedServer())).findAny().map(srvid -> this.getTigerTestEnvMgr().getServers().get(srvid)).map(srv -> srv.getDestinationUrl(cfg.getProxiedServerProtocol())).orElseThrow(() -> new TigerTestEnvException("Proxied server '" + cfg.getProxiedServer() + "' not found in list!"));
        TigerRoute tigerRoute = new TigerRoute();
        tigerRoute.setFrom("/");
        tigerRoute.setTo(destUrl);
        cfg.getProxyRoutes().add(tigerRoute);
    }

    @Override
    String getHealthcheckUrl() {
        return "http://127.0.0.1:" + this.getConfiguration().getTigerProxyCfg().getAdminPort();
    }

    @Override
    boolean isHealthCheckNone() {
        return false;
    }

    public TigerProxy getTigerProxy() {
        return (TigerProxy)this.applicationContext.getBean(TigerProxy.class);
    }
}

