/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.ServerType;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.CfgExternalJarOptions;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.servers.log.TigerStreamLogFeeder;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.event.Level;

public class ExternalJarServer
extends AbstractExternalTigerServer {
    private final AtomicReference<Process> processReference = new AtomicReference();
    private File jarFile;
    private LocalDateTime processStartTime;

    ExternalJarServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(ExternalJarServer.determineHostname(configuration, serverId), serverId, configuration, tigerTestEnvMgr);
    }

    @Override
    public void performStartup() {
        String workingDir = this.getConfiguration().getExternalJarOptions().getWorkingDir();
        this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().type(ServerType.EXTERNALJAR).statusMessage("Starting external jar instance " + this.getServerId() + " in folder '" + workingDir + "'...").build());
        CfgExternalJarOptions externalJarOptions = this.getConfiguration().getExternalJarOptions();
        String jarUrl = (String)this.getConfiguration().getSource().get(0);
        this.jarFile = this.getTigerTestEnvMgr().getDownloadManager().downloadJarAndReturnFile(this, jarUrl);
        ArrayList<String> options = new ArrayList<String>();
        String javaExe = this.findJavaExecutable();
        options.add(javaExe);
        options.addAll(externalJarOptions.getOptions().stream().map(this.getTigerTestEnvMgr()::replaceSysPropsInString).collect(Collectors.toList()));
        options.add("-jar");
        options.add(this.jarFile.getName());
        options.addAll(externalJarOptions.getArguments());
        this.statusMessage("Running '" + String.join((CharSequence)" ", options) + "' in folder '" + new File(workingDir).getAbsolutePath() + "'");
        AtomicReference exception = new AtomicReference();
        this.processStartTime = LocalDateTime.now();
        this.getTigerTestEnvMgr().getExecutor().submit(() -> {
            try {
                this.statusMessage("Starting Jar process for " + this.getServerId());
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command((String[])options.toArray(String[]::new)).directory(new File(workingDir)).inheritIO();
                processBuilder.environment().putAll(this.getEnvironmentProperties().stream().map(str -> str.split("=", 2)).filter(ar -> ((String[])ar).length == 2).collect(Collectors.toMap(ar -> ar[0].trim(), ar -> ar[1].trim())));
                this.processReference.set(processBuilder.start());
                new TigerStreamLogFeeder(this.log, this.processReference.get().getInputStream(), Level.INFO);
                new TigerStreamLogFeeder(this.log, this.processReference.get().getErrorStream(), Level.ERROR);
                this.statusMessage("Started JAR-File for " + this.getServerId() + " with PID '" + this.processReference.get().pid() + "'");
            }
            catch (Throwable t) {
                this.log.error("Failed to start process", t);
                exception.set(t);
            }
            this.log.debug("Proc set in atomic var {}", (Object)this.processReference.get());
        });
        if (this.isHealthCheckNone()) {
            this.log.warn("Healthcheck for {} is not configured, so unable to add route to local proxy!", (Object)this.getServerId());
        } else {
            this.addServerToLocalProxyRouteMap(this.buildHealthcheckUrl());
            this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().baseUrl(this.extractBaseUrl(this.buildHealthcheckUrl())).build());
        }
        if (exception.get() != null) {
            throw new TigerTestEnvException("Unable to start external jar '" + this.getServerId() + "'!", (Throwable)exception.get());
        }
        this.waitForService(true);
        if (exception.get() != null) {
            throw new TigerTestEnvException("Unable to start external jar '" + this.getServerId() + "'!", (Throwable)exception.get());
        }
        if (this.getStatus() == TigerServerStatus.STOPPED) {
            throw new TigerEnvironmentStartupException("Unable to start external jar '" + this.getServerId() + "'!");
        }
        if (this.getStatus() == TigerServerStatus.STARTING) {
            this.waitForService(false);
            if (exception.get() != null) {
                throw new TigerTestEnvException("Unable to start external jar '" + this.getServerId() + "'!", (Throwable)exception.get());
            }
            throw new TigerTestEnvException("Unable to start external jar '" + this.getServerId() + "'!");
        }
    }

    @Override
    public TigerServerStatus updateStatus(boolean quiet) {
        if (!this.processReference.get().isAlive()) {
            this.log.warn("Process {} for {} is stopped!", (Object)this.processReference.get().pid(), (Object)this.getServerId());
            this.setStatus(TigerServerStatus.STOPPED, "Jar process for " + this.getServerId() + " stopped unexpectedly");
            if (LocalDateTime.now().isBefore(this.processStartTime.plusSeconds(3L))) {
                this.log.warn("{}: Unusually short process run time ({})! Suspecting defunct jar! (Exitcode={})", new Object[]{this.getServerId(), Duration.between(LocalDateTime.now(), this.processStartTime), this.processReference.get().exitValue()});
                this.cleanupDefunctJar();
            }
            return this.getStatus();
        }
        return super.updateStatus(quiet);
    }

    private void cleanupDefunctJar() {
        if (!((String)this.getConfiguration().getSource().get(0)).startsWith("local:") && this.jarFile.exists() && !this.jarFile.delete()) {
            this.log.warn("Unable to delete jar file {}", (Object)this.jarFile.getAbsolutePath());
        }
    }

    @Override
    public void shutdown() {
        this.log.info("Stopping external jar {}...", (Object)this.getServerId());
        this.removeAllRoutes();
        this.stopExternalProcess();
    }

    private void stopExternalProcess() {
        if (this.processReference.get() != null) {
            this.log.info("Stopping external process (pid={})", (Object)this.processReference.get().pid());
            this.log.info("Interrupting threads...");
            this.processReference.get().destroy();
            this.log.info("Stopping threads...");
            this.processReference.get().destroyForcibly();
            this.setStatus(TigerServerStatus.STOPPED, "Jar process for " + this.getServerId() + " stopped");
        } else {
            this.setStatus(TigerServerStatus.STOPPED, "No Jar process for " + this.getServerId() + " found");
        }
    }

    private String findJavaExecutable() {
        String javaHomeDirectory = (String)TigerGlobalConfiguration.readStringOptional((String)"tiger.lib.javaHome").or(() -> TigerGlobalConfiguration.readStringOptional((String)"java.home")).orElseThrow(() -> new TigerEnvironmentStartupException("Could not determine java-home. Expected either 'tiger.lib.javaHome' oder 'java.home' to be set, but neither was!"));
        if (System.getProperty("os.name").startsWith("Win")) {
            return javaHomeDirectory + File.separator + "bin" + File.separator + "java.exe";
        }
        return javaHomeDirectory + File.separator + "bin" + File.separator + "java";
    }

    @Generated
    public static ExternalJarServerBuilder builder() {
        return new ExternalJarServerBuilder();
    }

    @Generated
    public static class ExternalJarServerBuilder {
        @Generated
        private String serverId;
        @Generated
        private CfgServer configuration;
        @Generated
        private TigerTestEnvMgr tigerTestEnvMgr;

        @Generated
        ExternalJarServerBuilder() {
        }

        @Generated
        public ExternalJarServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public ExternalJarServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public ExternalJarServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        @Generated
        public ExternalJarServer build() {
            return new ExternalJarServer(this.serverId, this.configuration, this.tigerTestEnvMgr);
        }

        @Generated
        public String toString() {
            return "ExternalJarServer.ExternalJarServerBuilder(serverId=" + this.serverId + ", configuration=" + this.configuration + ", tigerTestEnvMgr=" + this.tigerTestEnvMgr + ")";
        }
    }
}

