/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.env;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.command.ListContainersCmd;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.testenvmgr.servers.DockerComposeServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.Awaitility;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.DockerComposeContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.utility.Base58;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class DockerMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerMgr.class);
    private static final int MOD_ALL_EXEC = 511;
    private static final String CLZPATH = "classpath:";
    private final Map<String, GenericContainer<?>> containers = new HashMap();

    public void startContainer(DockerServer server) {
        String imageName = this.buildImageName(server);
        DockerImageName testContainersImageName = DockerImageName.parse((String)imageName);
        this.pullImage(imageName);
        GenericContainer container = new GenericContainer(testContainersImageName);
        try {
            Object ports;
            InspectImageResponse iiResponse = container.getDockerClient().inspectImageCmd(imageName).exec();
            ContainerConfig containerConfig = iiResponse.getConfig();
            if (containerConfig == null) {
                throw new TigerTestEnvException("Docker image '" + imageName + "' has no configuration info!");
            }
            if (server.getDockerOptions().isProxied()) {
                File tmpScriptFolder;
                String[] startCmd = containerConfig.getCmd();
                String[] entryPointCmd = containerConfig.getEntrypoint();
                if (StringUtils.isNotEmpty((CharSequence)server.getDockerOptions().getEntryPoint())) {
                    entryPointCmd = new String[]{server.getDockerOptions().getEntryPoint()};
                }
                if (entryPointCmd != null && entryPointCmd[0].equals("/bin/sh") && entryPointCmd[1].equals("-c")) {
                    entryPointCmd = new String[]{"su", containerConfig.getUser(), "-c", "'" + entryPointCmd[2] + "'"};
                }
                if (!(tmpScriptFolder = Path.of("target", "tiger-testenv-mgr").toFile()).exists() && !tmpScriptFolder.mkdirs()) {
                    throw new TigerTestEnvException("Unable to create temp folder for modified startup script for server " + server.getServerId());
                }
                String scriptName = this.createContainerStartupScript(server, iiResponse, startCmd, entryPointCmd);
                String containerScriptPath = containerConfig.getWorkingDir() + "/" + scriptName;
                container.withExtraHost("host.docker.internal", "host-gateway");
                container.withCopyFileToContainer(MountableFile.forHostPath((Path)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName), (Integer)511), containerScriptPath);
                container.withCreateContainerCmdModifier(cmd -> cmd.withUser("root").withEntrypoint(new String[]{containerScriptPath}));
            }
            container.setLogConsumers(List.of(new Slf4jLogConsumer(log)));
            log.info("Passing in environment for {}...", (Object)server.getServerId());
            this.addEnvVarsToContainer(container, server.getEnvironmentProperties());
            if (containerConfig.getExposedPorts() != null) {
                ports = Arrays.stream(containerConfig.getExposedPorts()).map(ExposedPort::getPort).collect(Collectors.toList());
                log.info("Exposing ports for {}: {}", (Object)server.getServerId(), ports);
                container.setExposedPorts(ports);
            }
            if (server.getDockerOptions().isOneShot()) {
                container.withStartupCheckStrategy((StartupCheckStrategy)new OneShotStartupCheckStrategy());
            }
            container.start();
            this.waitForHealthyStartup(server, container);
            container.getDockerClient().renameContainerCmd(container.getContainerId()).withName("tiger." + server.getServerId()).exec();
            this.containers.put(server.getServerId(), container);
            ports = new HashMap();
            container.getContainerInfo().getNetworkSettings().getPorts().getBindings().entrySet().stream().filter(entry -> entry.getValue() != null).forEach(arg_0 -> DockerMgr.lambda$startContainer$2((Map)ports, arg_0));
            server.getDockerOptions().setPorts((Map)ports);
        }
        catch (DockerException de) {
            throw new TigerTestEnvException("Failed to start container for server " + server.getServerId(), de);
        }
    }

    private String buildImageName(DockerServer server) {
        Object result = server.getDockerSource();
        if (server.getTigerTestEnvMgr() == null) {
            result = server.getTigerTestEnvMgr().replaceSysPropsInString(server.getDockerSource());
        }
        if (server.getConfiguration().getVersion() != null) {
            result = (String)result + ":" + server.getConfiguration().getVersion();
        }
        return result;
    }

    public void startComposition(DockerComposeServer server) {
        ArrayList<String> composeFileContents = new ArrayList<String>();
        File[] composeFiles = this.collectAndProcessComposeYamlFiles(server.getServerId(), server.getSource(), composeFileContents);
        String identity = "tiger_" + Base58.randomString((int)6).toLowerCase();
        DockerComposeContainer composition = new DockerComposeContainer(identity, composeFiles);
        composeFileContents.stream().filter(content -> !content.isEmpty()).map(content -> TigerSerializationUtil.yamlToJsonObject((String)content).getJSONObject("services")).map(JSONObject::toMap).flatMap(services -> services.entrySet().stream()).forEach(serviceEntry -> {
            Map map = (Map)serviceEntry.getValue();
            if (map.containsKey("ports")) {
                ((List)map.get("expose")).forEach(port -> {
                    log.info("Exposing service {} with port {}", serviceEntry.getKey(), port);
                    composition.withExposedService((String)serviceEntry.getKey(), port.intValue());
                });
            }
            composition.withLogConsumer((String)serviceEntry.getKey(), (Consumer)new Slf4jLogConsumer(log));
        });
        composition.withLocalCompose(true).withOptions(new String[]{"--compatibility"}).start();
        composeFileContents.stream().filter(content -> !content.isEmpty()).map(content -> TigerSerializationUtil.yamlToJsonObject((String)content).getJSONObject("services")).map(JSONObject::toMap).flatMap(services -> services.entrySet().stream()).forEach(serviceEntry -> {
            Map map = (Map)serviceEntry.getValue();
            if (map.containsKey("expose")) {
                ((List)map.get("expose")).forEach(port -> {
                    log.info("Service {} with port {} exposed via {}", new Object[]{serviceEntry.getKey(), port, composition.getServicePort((String)serviceEntry.getKey(), port)});
                    ListContainersCmd cmd = DockerClientFactory.instance().client().listContainersCmd();
                    log.debug("Inspecting docker container: {}", (Object)((List)cmd.exec()).toString());
                });
            }
            composition.withLogConsumer((String)serviceEntry.getKey(), (Consumer)new Slf4jLogConsumer(log));
        });
    }

    private File[] collectAndProcessComposeYamlFiles(String serverId, List<String> composeFilePaths, List<String> composeFileContents) {
        File folder = Paths.get("target", "tiger-testenv-mgr", serverId).toFile();
        return (File[])composeFilePaths.stream().map(filePath -> {
            String content = this.readAndProcessComposeFile((String)filePath, composeFileContents);
            return this.saveComposeContentToTempFile(folder, (String)filePath, content);
        }).toArray(File[]::new);
    }

    private String readAndProcessComposeFile(String filePath, List<String> composeFileContents) {
        try {
            String content;
            block12: {
                if (filePath.startsWith(CLZPATH)) {
                    try (InputStream is = this.getClass().getResourceAsStream(filePath);){
                        if (is == null) {
                            throw new TigerTestEnvException("Missing docker compose file in classpath " + filePath);
                        }
                        content = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
                        break block12;
                    }
                    catch (IOException ioe) {
                        throw new TigerTestEnvException("Unable to create temp docker compose file (" + filePath + ")", ioe);
                    }
                }
                content = FileUtils.readFileToString((File)new File(filePath), (Charset)StandardCharsets.UTF_8);
            }
            content = TigerGlobalConfiguration.resolvePlaceholders((String)content);
            composeFileContents.add(content);
            return content;
        }
        catch (IOException e) {
            throw new TigerTestEnvException("Unable to process compose file " + filePath, e);
        }
    }

    private File saveComposeContentToTempFile(File folder, String filePath, String content) {
        try {
            File tmpFile;
            if (filePath.startsWith(CLZPATH)) {
                filePath = filePath.substring(CLZPATH.length());
            }
            if (!(tmpFile = Paths.get(folder.getAbsolutePath(), filePath).toFile()).getParentFile().exists() && !tmpFile.getParentFile().mkdirs()) {
                throw new TigerTestEnvException("Unable to create temp folder " + tmpFile.getParentFile().getAbsolutePath());
            }
            FileUtils.writeStringToFile((File)tmpFile, (String)content, (Charset)StandardCharsets.UTF_8);
            return tmpFile;
        }
        catch (IOException e) {
            throw new TigerTestEnvException("Unable to process compose file " + filePath, e);
        }
    }

    private void addEnvVarsToContainer(GenericContainer<?> container, List<String> envVars) {
        envVars.stream().filter(i -> i.contains("=")).map(i -> i.split("=", 2)).peek(envvar -> log.info("  * {}={}", (Object)envvar[0], (Object)envvar[1])).forEach(envvar -> container.addEnv(TigerGlobalConfiguration.resolvePlaceholders((String)envvar[0]), TigerGlobalConfiguration.resolvePlaceholders((String)envvar[1])));
    }

    public void pullImage(String imageName) {
        log.info("Pulling docker image {}...", (Object)imageName);
        final AtomicBoolean pullComplete = new AtomicBoolean();
        pullComplete.set(false);
        final AtomicReference cbException = new AtomicReference();
        DockerClientFactory.instance().client().pullImageCmd(imageName).exec((ResultCallback)new ResultCallback.Adapter<PullResponseItem>(){

            public void onNext(PullResponseItem item) {
                if (log.isDebugEnabled()) {
                    log.debug("{} {}", (Object)item.getStatus(), (Object)Optional.ofNullable(item.getProgressDetail()).map(ResponseItem.ProgressDetail::getCurrent).map(Object::toString).orElse(""));
                }
            }

            public void onError(Throwable throwable) {
                cbException.set(throwable);
            }

            public void onComplete() {
                pullComplete.set(true);
            }
        });
        Awaitility.await().pollInterval(Duration.ofMillis(1000L)).atMost(5L, TimeUnit.MINUTES).until(() -> {
            if (cbException.get() != null) {
                throw new TigerTestEnvException("Unable to pull image " + imageName + "!", (Throwable)cbException.get());
            }
            return pullComplete.get();
        });
        log.info("Docker image {} is available locally!", (Object)imageName);
    }

    private String createContainerStartupScript(TigerServer server, InspectImageResponse iiResponse, String[] startCmd, String[] entryPointCmd) {
        ContainerConfig containerConfig = iiResponse.getConfig();
        if (containerConfig == null) {
            throw new TigerTestEnvException("Docker image of server '" + server.getServerId() + "' has no configuration info!");
        }
        startCmd = startCmd == null ? new String[]{} : startCmd;
        entryPointCmd = entryPointCmd == null ? new String[]{} : entryPointCmd;
        try {
            String proxycert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/CertificateAuthorityCertificate.pem")), (Charset)StandardCharsets.UTF_8);
            String lecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/letsencrypt.crt")), (Charset)StandardCharsets.UTF_8);
            String risecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/idp-rise-tu.crt")), (Charset)StandardCharsets.UTF_8);
            File tmpScriptFolder = Path.of("target", "tiger-testenv-mgr").toFile();
            if (!tmpScriptFolder.exists() && !tmpScriptFolder.mkdirs()) {
                throw new TigerTestEnvException("Unable to create script folder " + tmpScriptFolder.getAbsolutePath());
            }
            String scriptName = "__tigerStart_" + server.getServerId() + ".sh";
            String content = "#!/bin/sh -x\nenv\necho \"" + proxycert + "\" >> /etc/ssl/certs/ca-certificates.crt\necho \"" + lecert + "\" >> /etc/ssl/certs/ca-certificates.crt\necho \"" + risecert + "\" >> /etc/ssl/certs/ca-certificates.crt\n";
            content = content + this.getContainerWorkingDirectory(containerConfig) + String.join((CharSequence)" ", entryPointCmd).replace("\t", " ") + " " + String.join((CharSequence)" ", startCmd).replace("\t", " ") + "\n";
            FileUtils.writeStringToFile((File)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName).toFile(), (String)content, (Charset)StandardCharsets.UTF_8);
            return scriptName;
        }
        catch (IOException ioe) {
            throw new TigerTestEnvException("Failed to configure start script on container for server " + server.getServerId(), ioe);
        }
    }

    private String getContainerWorkingDirectory(ContainerConfig containerConfig) {
        if (containerConfig.getWorkingDir() == null || containerConfig.getWorkingDir().isBlank()) {
            return "";
        }
        return "cd " + containerConfig.getWorkingDir() + "\n";
    }

    private void waitForHealthyStartup(TigerServer server, GenericContainer<?> container) {
        long startms = System.currentTimeMillis();
        long endhalfms = server.getStartupTimeoutSec().map(seconds -> (long)seconds.intValue() * 500L).orElse(5000L);
        try {
            Thread.sleep(endhalfms);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for startup of server " + server.getServerId(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            while (!container.isHealthy()) {
                Thread.sleep(500L);
                if (startms + endhalfms * 2L >= System.currentTimeMillis()) continue;
                throw new TigerTestEnvException("Startup of server %s timed out after %d seconds!", server.getServerId(), (System.currentTimeMillis() - startms) / 1000L);
            }
            log.info("HealthCheck OK ({}) for {}", (Object)(container.isHealthy() ? 1 : 0), (Object)server.getServerId());
        }
        catch (InterruptedException ie) {
            log.warn("Interruption signaled while waiting for server " + server.getServerId() + " to start up", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TigerTestEnvException ttee) {
            throw ttee;
        }
        catch (RuntimeException rte) {
            int timeout = server.getStartupTimeoutSec().orElse(20);
            log.warn("probably no health check configured - defaulting to {}s startup time", (Object)timeout);
            try {
                Thread.sleep((long)timeout * 1000L);
            }
            catch (InterruptedException interruptedException) {
                log.warn("Interruption signaled");
                Thread.currentThread().interrupt();
            }
            log.warn("HealthCheck UNCLEAR for {} as no healthcheck is configured, we assume it works and continue setup!", (Object)server.getServerId());
        }
    }

    public void stopContainer(TigerServer server) {
        GenericContainer<?> container = this.containers.get(server.getServerId());
        if (container != null && container.getDockerClient() != null) {
            try {
                container.getDockerClient().stopContainerCmd(container.getContainerId()).exec();
            }
            catch (NotModifiedException nmex) {
                log.warn("Failed to issue stop container cmd from docker client, trying test container's stop...");
            }
            container.stop();
        }
    }

    public void pauseContainer(DockerServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getServerId());
        container.getDockerClient().pauseContainerCmd(container.getContainerId()).exec();
    }

    public void unpauseContainer(DockerServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getServerId());
        container.getDockerClient().unpauseContainerCmd(container.getContainerId()).exec();
    }

    @Generated
    public Map<String, GenericContainer<?>> getContainers() {
        return this.containers;
    }

    private static /* synthetic */ void lambda$startContainer$2(Map ports, Map.Entry entry) {
        ports.put(((ExposedPort)entry.getKey()).getPort(), Integer.valueOf(((Ports.Binding[])entry.getValue())[0].getHostPortSpec()));
    }
}

