/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.pki.TigerConfigurationPkiIdentity;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.TigerProxyApplication;
import de.gematik.test.tiger.testenvmgr.ITigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import de.gematik.test.tiger.testenvmgr.env.DockerMgr;
import de.gematik.test.tiger.testenvmgr.env.DownloadManager;
import de.gematik.test.tiger.testenvmgr.env.TigerEnvUpdateSender;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerUpdateListener;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerLogListener;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.context.ServletWebServerApplicationContext;
import org.springframework.context.ApplicationContextInitializer;

public class TigerTestEnvMgr
implements ITigerTestEnvMgr,
TigerEnvUpdateSender,
TigerUpdateListener,
DisposableBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestEnvMgr.class);
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    public static final String CFG_PROP_NAME_LOCAL_PROXY_ADMIN_PORT = "tiger.tigerProxy.adminPort";
    public static final String CFG_PROP_NAME_LOCAL_PROXY_PROXY_PORT = "tiger.tigerProxy.proxyPort";
    private final Configuration configuration;
    private final DockerMgr dockerManager;
    private final Map<String, Object> environmentVariables;
    private final TigerProxy localTigerProxy;
    private final List<TigerRoute> routesList = new ArrayList<TigerRoute>();
    private final Map<String, TigerServer> servers = new HashMap<String, TigerServer>();
    private final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private final List<TigerUpdateListener> listeners = new ArrayList<TigerUpdateListener>();
    private final DownloadManager downloadManager = new DownloadManager();
    private ServletWebServerApplicationContext localTigerProxyApplicationContext;
    private boolean userAcknowledgedShutdown = false;
    private boolean userAcknowledgedContinueTestRun = false;
    private boolean workflowUiSentFetch = false;

    public TigerTestEnvMgr() {
        Configuration configuration = TigerTestEnvMgr.readConfiguration();
        this.dockerManager = new DockerMgr();
        this.localTigerProxy = this.startLocalTigerProxy(configuration);
        if (configuration.isLocalProxyActive()) {
            log.info(Ansi.colorize((String)"Local Tiger Proxy URL http://localhost:{}", (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD), (Object)this.localTigerProxy.getProxyPort());
            log.info(Ansi.colorize((String)"Local Tiger Proxy UI http://localhost:{}/webui", (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD), (Object)this.localTigerProxyApplicationContext.getWebServer().getPort());
            this.environmentVariables = new HashMap<String, Integer>(Map.of("PROXYHOST", "host.docker.internal", "PROXYPORT", this.localTigerProxy.getProxyPort()));
        } else {
            log.info("Local Tiger Proxy deactivated");
            this.environmentVariables = new HashMap<String, Object>();
        }
        this.configuration = configuration;
        this.createServerObjects();
        log.info("Tiger Testenv mgr created OK");
    }

    private TigerProxy startLocalTigerProxy(Configuration configuration) {
        log.info("\n" + Banner.toBannerStr((String)"STARTING LOCAL PROXY...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
        if (configuration.getTigerProxy() == null) {
            configuration.setTigerProxy(TigerProxyConfiguration.builder().build());
        }
        TigerProxyConfiguration proxyConfig = configuration.getTigerProxy();
        proxyConfig.setSkipTrafficEndpointsSubscription(true);
        if (proxyConfig.getProxyRoutes() == null) {
            proxyConfig.setProxyRoutes(List.of());
        }
        if (proxyConfig.getTls().getServerRootCa() == null) {
            proxyConfig.getTls().setServerRootCa(new TigerConfigurationPkiIdentity("CertificateAuthorityCertificate.pem;PKCS8CertificateAuthorityPrivateKey.pem;PKCS8"));
        }
        HashMap<String, String> properties = new HashMap<String, String>(TigerSerializationUtil.toMap((Object)proxyConfig, (String[])new String[]{"tigerProxy"}));
        if (configuration.getTigerProxy().getAdminPort() == 0) {
            int port = (Integer)TigerGlobalConfiguration.readIntegerOptional((String)"tiger.internal.localproxy.admin.port").orElseThrow(() -> new TigerEnvironmentStartupException("No free port reserved for local Tiger Proxy admin"));
            properties.put("server.port", Integer.toString(port));
        } else {
            properties.put("server.port", Integer.toString(configuration.getTigerProxy().getAdminPort()));
            TigerGlobalConfiguration.putValue((String)"tiger.internal.localproxy.port", (String)Integer.toString(configuration.getTigerProxy().getAdminPort()));
        }
        this.localTigerProxyApplicationContext = (ServletWebServerApplicationContext)new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).properties(properties).sources(new Class[]{TigerProxyApplication.class}).web(WebApplicationType.SERVLET).registerShutdownHook(false).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        TigerProxy localTigerProxy = (TigerProxy)this.localTigerProxyApplicationContext.getBean(TigerProxy.class);
        TigerGlobalConfiguration.putValue((String)CFG_PROP_NAME_LOCAL_PROXY_PROXY_PORT, (int)localTigerProxy.getProxyPort());
        TigerGlobalConfiguration.putValue((String)CFG_PROP_NAME_LOCAL_PROXY_ADMIN_PORT, (String)String.valueOf(this.localTigerProxyApplicationContext.getWebServer().getPort()));
        return localTigerProxy;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void waitForConsoleInput(String textToEnter) {
        Console c = System.console();
        String message = "\n" + Banner.toBannerStr((String)("Press " + (String)(textToEnter.isEmpty() ? "" : "'" + textToEnter + "' and ") + "ENTER."), (String)RbelAnsiColors.RED_BOLD.toString());
        if (c != null) {
            String cmd = null;
            while (cmd == null || !cmd.equals(textToEnter)) {
                log.info(message);
                if (cmd != null) {
                    log.warn("Received: '{}'", (Object)cmd);
                }
                cmd = c.readLine();
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TigerTestEnvException("Interrupt received while waiting for console input", e);
                }
            }
            return;
        }
        log.warn("No Console interface found, trying System in stream...");
        try {
            BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
            String cmd = null;
            while (cmd == null || !cmd.equals(textToEnter)) {
                log.info(message);
                if (cmd != null) {
                    log.warn("Received: '{}'", (Object)cmd);
                }
                cmd = rdr.readLine();
                try {
                    TimeUnit.MILLISECONDS.sleep(100L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new TigerTestEnvException("Interrupt received while waiting for console input", e);
                    return;
                }
            }
        }
        catch (IOException e) {
            log.warn("Unable to open input stream from console! Continuing with test run...", (Throwable)e);
        }
    }

    private static void readTemplates() {
        try {
            URL templatesUrl = TigerTestEnvMgr.class.getResource("templates.yaml");
            String templatesYaml = IOUtils.toString((URI)Objects.requireNonNull(templatesUrl).toURI(), (Charset)StandardCharsets.UTF_8);
            TigerGlobalConfiguration.readTemplates((String)templatesYaml, (String[])new String[]{"tiger", "servers"});
        }
        catch (IOException | URISyntaxException e) {
            throw new TigerConfigurationException("Unable to read templates YAML!", (Throwable)e);
        }
    }

    private static Configuration readConfiguration() {
        TigerGlobalConfiguration.initialize();
        TigerTestEnvMgr.readTemplates();
        Configuration configuration = TigerGlobalConfiguration.instantiateConfigurationBean(Configuration.class, (String[])new String[]{"tiger"}).orElseGet(Configuration::new);
        for (CfgServer cfgServer : configuration.getServers().values()) {
            if (!StringUtils.isNotEmpty((CharSequence)cfgServer.getTemplate())) continue;
            throw new TigerConfigurationException("Could not resolve template '" + cfgServer.getTemplate() + "'");
        }
        return configuration;
    }

    private void assertNoCyclesInGraph() {
        this.servers.values().forEach(server -> this.cycleChecker((TigerServer)server, (Set<TigerServer>)new HashSet<TigerServer>()));
    }

    private void cycleChecker(TigerServer currentPosition, Set<TigerServer> visitedServer) {
        if (visitedServer.contains(currentPosition)) {
            throw new TigerEnvironmentStartupException("Cyclic graph detected in startup sequence: " + visitedServer.stream().map(TigerServer::getServerId).collect(Collectors.toList()));
        }
        if (currentPosition.getDependUponList().isEmpty()) {
            System.out.println(visitedServer);
            return;
        }
        for (TigerServer server : currentPosition.getDependUponList()) {
            HashSet<TigerServer> newSet = new HashSet<TigerServer>(visitedServer);
            newSet.add(currentPosition);
            this.cycleChecker(server, newSet);
        }
    }

    private void createServerObjects() {
        for (Map.Entry<String, CfgServer> serverEntry : this.configuration.getServers().entrySet()) {
            if (!serverEntry.getValue().isActive()) continue;
            TigerServer server = TigerServer.create(serverEntry.getKey(), serverEntry.getValue(), this);
            this.servers.put(serverEntry.getKey(), server);
            server.registerNewListener(this);
        }
    }

    @Override
    public void setUpEnvironment() {
        this.assertNoCyclesInGraph();
        this.assertNoUnknownServersInDependencies();
        List initialServersToBoot = this.servers.values().parallelStream().filter(server -> server.getDependUponList().isEmpty()).collect(Collectors.toList());
        log.info("Booting following server(s): {}", initialServersToBoot.stream().map(TigerServer::getHostname).collect(Collectors.toList()));
        initialServersToBoot.parallelStream().forEach(this::startServer);
        this.localTigerProxy.subscribeToTrafficEndpoints(this.configuration.getTigerProxy());
        log.info(Ansi.colorize((String)"Finished set up test environment OK", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
    }

    private void assertNoUnknownServersInDependencies() {
        this.getServers().values().forEach(TigerServer::getDependUponList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer(TigerServer server) {
        TigerServer tigerServer = server;
        synchronized (tigerServer) {
            if (server.getStatus() != TigerServerStatus.NEW) {
                return;
            }
            server.start(this);
        }
        this.servers.values().parallelStream().peek(toBeStartedServer -> log.debug("Considering to start server {} with status {}...", (Object)toBeStartedServer.getServerId(), (Object)toBeStartedServer.getStatus())).filter(candidate -> candidate.getStatus() == TigerServerStatus.NEW).filter(candidate -> candidate.getDependUponList().stream().filter(depending -> depending.getStatus() != TigerServerStatus.RUNNING).findAny().isEmpty()).peek(toBeStartedServer -> log.info("Starting server {} with status {}", (Object)toBeStartedServer.getServerId(), (Object)toBeStartedServer.getStatus())).forEach(this::startServer);
    }

    public String replaceSysPropsInString(String str) {
        return str;
    }

    @Override
    public void shutDown() {
        log.info(Ansi.colorize((String)"Shutting down all servers...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        this.servers.values().forEach(TigerServer::shutdown);
        log.info(Ansi.colorize((String)"Shutting down local tiger proxy...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        this.localTigerProxy.shutdown();
        this.localTigerProxyApplicationContext.close();
        log.info(Ansi.colorize((String)"Finished shutdown test environment OK", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
    }

    @Override
    public void receiveTestEnvUpdate(TigerStatusUpdate statusUpdate) {
        this.listeners.forEach(listener -> listener.receiveTestEnvUpdate(statusUpdate));
    }

    public List<TigerRoute> getRoutes() {
        return this.servers.values().stream().map(TigerServer::getRoutes).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
    }

    public Optional<TigerServer> findServer(String serverName) {
        return Optional.ofNullable(this.servers.get(serverName));
    }

    public boolean isLocalTigerProxyActive() {
        if (this.configuration == null) {
            return true;
        }
        return this.configuration.isLocalProxyActive();
    }

    @Override
    public void registerNewListener(TigerUpdateListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public void registerLogListener(TigerServerLogListener listener) {
    }

    public static void openWorkflowUiInBrowser(String adminPort) {
        try {
            String url = "http://localhost:" + adminPort;
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop desktop = Desktop.getDesktop();
                log.info("Starting Workflow UI via Java Desktop API");
                desktop.browse(new URI(url));
                log.info(Ansi.colorize((String)"Workflow UI {}", (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD), (Object)url);
            } else {
                String command;
                String operatingSystemName = System.getProperty("os.name").toLowerCase();
                if (operatingSystemName.contains("nix") || operatingSystemName.contains("nux")) {
                    command = "xdg-open " + url;
                } else if (operatingSystemName.contains("win")) {
                    command = "rundll32 url.dll,FileProtocolHandler " + url;
                } else if (operatingSystemName.contains("mac")) {
                    command = "open " + url;
                } else {
                    log.error("Unknown operation system '{}'", (Object)operatingSystemName);
                    return;
                }
                log.info("Starting Workflow UI via '{}'", (Object)command);
                Runtime.getRuntime().exec(command);
                log.info(Ansi.colorize((String)("Workflow UI " + url), (RbelAnsiColors)RbelAnsiColors.BLUE_BOLD));
            }
        }
        catch (HeadlessException hex) {
            log.error("Unable to start Workflow UI on a headless server!", (Throwable)hex);
        }
        catch (IOException | RuntimeException | URISyntaxException e) {
            log.error("Exception while trying to start browser for Workflow UI, still continuing with test run", (Throwable)e);
        }
    }

    public void receivedUserAcknowledgementForShutdown() {
        this.userAcknowledgedShutdown = true;
    }

    public void receivedResumeTestRunExecution() {
        this.userAcknowledgedContinueTestRun = true;
    }

    public void resetUserAcknowledgedContinueTestRun() {
        this.userAcknowledgedContinueTestRun = false;
    }

    public void destroy() throws Exception {
        this.shutDown();
    }

    @Override
    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public DockerMgr getDockerManager() {
        return this.dockerManager;
    }

    @Generated
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Generated
    public TigerProxy getLocalTigerProxy() {
        return this.localTigerProxy;
    }

    @Generated
    public List<TigerRoute> getRoutesList() {
        return this.routesList;
    }

    @Generated
    public Map<String, TigerServer> getServers() {
        return this.servers;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public List<TigerUpdateListener> getListeners() {
        return this.listeners;
    }

    @Generated
    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }

    @Generated
    public ServletWebServerApplicationContext getLocalTigerProxyApplicationContext() {
        return this.localTigerProxyApplicationContext;
    }

    @Generated
    public boolean isUserAcknowledgedShutdown() {
        return this.userAcknowledgedShutdown;
    }

    @Generated
    public boolean isUserAcknowledgedContinueTestRun() {
        return this.userAcknowledgedContinueTestRun;
    }

    @Generated
    public void setWorkflowUiSentFetch(boolean workflowUiSentFetch) {
        this.workflowUiSentFetch = workflowUiSentFetch;
    }

    @Generated
    public boolean isWorkflowUiSentFetch() {
        return this.workflowUiSentFetch;
    }
}

