/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.junit;

import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgrApplication;
import de.gematik.test.tiger.testenvmgr.junit.TigerTest;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kong.unirest.Unirest;
import kong.unirest.UnirestInstance;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.junit.jupiter.api.extension.AfterTestExecutionCallback;
import org.junit.jupiter.api.extension.BeforeTestExecutionCallback;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class TigerExtension
implements BeforeTestExecutionCallback,
ParameterResolver,
AfterTestExecutionCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerExtension.class);
    private TigerTestEnvMgr tigerTestEnvMgr;
    private ConfigurableApplicationContext envMgrApplicationContext;

    public void beforeTestExecution(ExtensionContext context) {
        this.assertInitialized(context);
    }

    public void afterTestExecution(ExtensionContext context) {
        if (this.tigerTestEnvMgr != null) {
            log.info("After test execution - tearing down context");
            if (!TigerGlobalConfiguration.readBoolean((String)"tiger.skipEnvironmentSetup", (boolean)false)) {
                log.info("Stopping Test-Env");
                this.tigerTestEnvMgr.shutDown();
            }
            this.envMgrApplicationContext.close();
            TigerGlobalConfiguration.reset();
            this.tigerTestEnvMgr = null;
        }
    }

    private TigerTest findTigerAnnotation(ExtensionContext context) {
        return ((Method)context.getTestMethod().get()).getAnnotation(TigerTest.class);
    }

    public boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return parameterContext.getParameter().getType().isAssignableFrom(TigerTestEnvMgr.class) || parameterContext.getParameter().getType().isAssignableFrom(UnirestInstance.class);
    }

    public Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        this.assertInitialized(extensionContext);
        if (parameterContext.getParameter().getType().isAssignableFrom(TigerTestEnvMgr.class)) {
            return this.tigerTestEnvMgr;
        }
        if (parameterContext.getParameter().getType().isAssignableFrom(UnirestInstance.class)) {
            UnirestInstance unirestInstance = Unirest.spawnInstance();
            unirestInstance.config().proxy("127.0.0.1", this.tigerTestEnvMgr.getLocalTigerProxy().getProxyPort());
            return unirestInstance;
        }
        throw new RuntimeException("Could not instantiate parameter, unsupported typ " + parameterContext.getParameter().getType());
    }

    private void assertInitialized(ExtensionContext extensionContext) {
        if (this.tigerTestEnvMgr == null) {
            this.buildNewTigerTestEnvMgr(extensionContext);
        }
    }

    private void buildNewTigerTestEnvMgr(ExtensionContext extensionContext) {
        log.info("TigerTest entering setup");
        TigerGlobalConfiguration.reset();
        TigerTest tigerAnnotation = this.findTigerAnnotation(extensionContext);
        HashMap<String, String> additionalProperties = new HashMap<String, String>();
        if (StringUtils.isEmpty((CharSequence)tigerAnnotation.cfgFilePath())) {
            TigerGlobalConfiguration.setRequireTigerYaml((boolean)false);
        } else {
            additionalProperties.put("TIGER_TESTENV_CFGFILE", tigerAnnotation.cfgFilePath());
        }
        if (StringUtils.isNotEmpty((CharSequence)tigerAnnotation.tigerYaml())) {
            additionalProperties.put("TIGER_YAML", tigerAnnotation.tigerYaml());
            TigerGlobalConfiguration.setRequireTigerYaml((boolean)false);
        }
        additionalProperties.put("tiger.skipEnvironmentSetup", Boolean.toString(tigerAnnotation.skipEnvironmentSetup()));
        if (tigerAnnotation.additionalProperties() != null) {
            Arrays.stream(tigerAnnotation.additionalProperties()).map(str -> str.split("=")).forEach(split -> additionalProperties.put(split[0].trim(), split[1].trim()));
        }
        log.debug("Initializing configuration with {}", additionalProperties);
        TigerGlobalConfiguration.initializeWithCliProperties(additionalProperties);
        this.envMgrApplicationContext = new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).properties(Map.of("server.port", TigerGlobalConfiguration.readIntegerOptional((String)"free.port.255").orElse(0))).sources(new Class[]{TigerTestEnvMgrApplication.class}).web(WebApplicationType.SERVLET).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        this.tigerTestEnvMgr = (TigerTestEnvMgr)this.envMgrApplicationContext.getBean(TigerTestEnvMgr.class);
        if (!TigerGlobalConfiguration.readBoolean((String)"tiger.skipEnvironmentSetup", (boolean)false)) {
            log.info("Starting Test-Env setup");
            this.tigerTestEnvMgr.setUpEnvironment();
        }
        log.info("TigerTest initialized, commencing actual test");
    }
}

