/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.controller;

import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.proxy.data.MessageMetaDataDto;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.data.TigerEnvStatusDto;
import de.gematik.test.tiger.testenvmgr.data.TigerServerStatusDto;
import de.gematik.test.tiger.testenvmgr.env.FeatureUpdate;
import de.gematik.test.tiger.testenvmgr.env.ScenarioUpdate;
import de.gematik.test.tiger.testenvmgr.env.StepUpdate;
import de.gematik.test.tiger.testenvmgr.env.TestResult;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerUpdateListener;
import java.util.ArrayList;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/status"})
public class EnvStatusController
implements TigerUpdateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EnvStatusController.class);
    private final TigerEnvStatusDto tigerEnvStatus = new TigerEnvStatusDto();
    TigerTestEnvMgr tigerTestEnvMgr;

    public EnvStatusController(TigerTestEnvMgr tigerTestEnvMgr) {
        this.tigerTestEnvMgr = tigerTestEnvMgr;
        this.tigerTestEnvMgr.registerNewListener(this);
    }

    @Override
    public synchronized void receiveTestEnvUpdate(TigerStatusUpdate update) {
        log.trace("receiving update {}", (Object)update.getIndex());
        try {
            this.receiveTestSuiteUpdate(update.getFeatureMap());
            update.getServerUpdate().forEach(this::receiveServerStatusUpdate);
            if (update.getBannerMessage() != null) {
                this.tigerEnvStatus.setBannerMessage(update.getBannerMessage());
                this.tigerEnvStatus.setBannerColor(update.getBannerColor());
                this.tigerEnvStatus.setBannerType(update.getBannerType());
            }
            if (update.getIndex() > this.tigerEnvStatus.getCurrentIndex()) {
                this.tigerEnvStatus.setCurrentIndex(update.getIndex());
            }
        }
        catch (Exception e) {
            log.error("Unable to parse update", (Throwable)e);
        }
    }

    private void receiveTestSuiteUpdate(Map<String, FeatureUpdate> update) {
        update.forEach((key, value) -> {
            try {
                if (this.tigerEnvStatus.getFeatureMap().containsKey(key)) {
                    FeatureUpdate feature = this.tigerEnvStatus.getFeatureMap().get(key);
                    if (value.getStatus() != TestResult.UNUSED) {
                        feature.setStatus(value.getStatus());
                    }
                    feature.setDescription(value.getDescription());
                    value.getScenarios().forEach((skey, svalue) -> {
                        if (feature.getScenarios().containsKey(skey)) {
                            ScenarioUpdate scenario = feature.getScenarios().get(skey);
                            if (svalue.getStatus() != TestResult.UNUSED) {
                                scenario.setStatus(svalue.getStatus());
                            }
                            scenario.setDescription(svalue.getDescription());
                            scenario.setExampleKeys(svalue.getExampleKeys());
                            scenario.setExampleList(svalue.getExampleList());
                            scenario.setVariantIndex(svalue.getVariantIndex());
                            svalue.getSteps().forEach((stkey, stvalue) -> {
                                if (scenario.getSteps().containsKey(stkey)) {
                                    StepUpdate step = scenario.getSteps().get(stkey);
                                    if (stvalue.getStatus() != TestResult.UNUSED) {
                                        step.setStatus(stvalue.getStatus());
                                    }
                                    step.setDescription(stvalue.getDescription());
                                    step.setStepIndex(stvalue.getStepIndex());
                                    if (stvalue.getRbelMetaData() != null) {
                                        if (step.getRbelMetaData() == null) {
                                            step.setRbelMetaData(new ArrayList<MessageMetaDataDto>());
                                        }
                                        step.getRbelMetaData().addAll(stvalue.getRbelMetaData());
                                    }
                                } else {
                                    scenario.getSteps().put((String)stkey, (StepUpdate)stvalue);
                                }
                            });
                        } else {
                            feature.getScenarios().put((String)skey, (ScenarioUpdate)svalue);
                        }
                    });
                } else {
                    this.tigerEnvStatus.getFeatureMap().put((String)key, (FeatureUpdate)value);
                }
            }
            catch (Exception e) {
                log.error("Unable to parse update", (Throwable)e);
            }
        });
    }

    private synchronized void receiveServerStatusUpdate(String serverName, TigerServerStatusUpdate statusUpdate) {
        log.trace("Status update for server {}", (Object)serverName);
        TigerServerStatusDto serverStatus = this.tigerEnvStatus.getServers().getOrDefault(serverName, new TigerServerStatusDto());
        serverStatus.setName(serverName);
        if (statusUpdate.getStatus() != null) {
            serverStatus.setStatus(statusUpdate.getStatus());
        }
        if (statusUpdate.getType() != null) {
            serverStatus.setType(statusUpdate.getType());
        }
        if (statusUpdate.getBaseUrl() != null) {
            serverStatus.setBaseUrl(statusUpdate.getBaseUrl());
        }
        if (statusUpdate.getStatusMessage() != null) {
            serverStatus.setStatusMessage(statusUpdate.getStatusMessage());
            serverStatus.getStatusUpdates().add(statusUpdate.getStatusMessage());
        }
        this.tigerEnvStatus.getServers().put(serverName, serverStatus);
    }

    @GetMapping(produces={"application/json"})
    public TigerEnvStatusDto getStatus() {
        log.trace("Fetch request to getStatus() received");
        if (StringUtils.isEmpty((CharSequence)this.tigerEnvStatus.getLocalProxyWebUiUrl())) {
            this.tigerEnvStatus.setLocalProxyWebUiUrl("http://localhost:" + TigerGlobalConfiguration.readString((String)"tiger.tigerProxy.adminPort") + "/webui");
        }
        return this.tigerEnvStatus;
    }

    @GetMapping(path={"/quit"})
    public void getConfirmQuit() {
        log.trace("Fetch request to getQuit() received");
        this.tigerTestEnvMgr.receivedUserAcknowledgementForShutdown();
    }

    @GetMapping(path={"/continueExecution"})
    public void getConfirmContinueExecution() {
        log.trace("Fetch request to continueExecution() received");
        this.tigerTestEnvMgr.receivedResumeTestRunExecution();
    }
}

