/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.config.ServerType;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.CfgExternalJarOptions;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.env.TigerServerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalJarServer
extends AbstractExternalTigerServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalJarServer.class);
    private final AtomicReference<Process> processReference = new AtomicReference();
    private File jarFile;
    private LocalDateTime processStartTime;

    ExternalJarServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(ExternalJarServer.determineHostname(configuration, serverId), serverId, configuration, tigerTestEnvMgr);
    }

    @Override
    public void performStartup() {
        CfgExternalJarOptions externalJarOptions = this.getConfiguration().getExternalJarOptions();
        String workingDir = this.getConfiguration().getExternalJarOptions().getWorkingDir();
        log.info(Ansi.colorize((String)"starting external jar instance {} in folder {}...", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD), (Object)this.getHostname(), (Object)workingDir);
        log.info("preparing check for external jar location...");
        String jarUrl = (String)this.getConfiguration().getSource().get(0);
        this.jarFile = this.getTigerTestEnvMgr().getDownloadManager().downloadJarAndReturnFile(this, jarUrl);
        log.info("creating cmd line...");
        ArrayList<String> options = new ArrayList<String>();
        String javaExe = this.findJavaExecutable();
        options.add(javaExe);
        options.addAll(externalJarOptions.getOptions().stream().map(this.getTigerTestEnvMgr()::replaceSysPropsInString).collect(Collectors.toList()));
        options.add("-jar");
        options.add(this.jarFile.getName());
        options.addAll(externalJarOptions.getArguments());
        this.statusMessage("About to run '" + String.join((CharSequence)" ", options) + "' in folder '" + new File(workingDir).getAbsolutePath() + "'");
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopExternalProcess));
        AtomicReference exception = new AtomicReference();
        this.processStartTime = LocalDateTime.now();
        this.getTigerTestEnvMgr().getExecutor().submit(() -> {
            try {
                this.statusMessage("Starting local JAR-File");
                ProcessBuilder processBuilder = new ProcessBuilder(new String[0]).command((String[])options.toArray(String[]::new)).directory(new File(workingDir)).inheritIO();
                processBuilder.environment().putAll(this.getEnvironmentProperties().stream().map(str -> str.split("=", 2)).filter(ar -> ((String[])ar).length == 2).collect(Collectors.toMap(ar -> ar[0].trim(), ar -> ar[1].trim())));
                this.processReference.set(processBuilder.start());
                this.statusMessage("Started JAR-File with PID '" + this.processReference.get().pid() + "'");
            }
            catch (Throwable t) {
                log.error("Failed to start process", t);
                exception.set(t);
            }
            log.debug("Proc set in atomic var {}", (Object)this.processReference.get());
        });
        if (this.isHealthCheckNone()) {
            log.warn("Healthcheck is not configured, so unable to add route to local proxy!");
        } else {
            this.addServerToLocalProxyRouteMap(this.buildHealthcheckUrl());
            this.publishNewStatusUpdate(TigerServerStatusUpdate.builder().baseUrl(this.extractBaseUrl(this.buildHealthcheckUrl())).type(ServerType.EXTERNALJAR).build());
        }
        if (exception.get() != null) {
            throw new TigerTestEnvException("Unable to start external jar '" + this.getHostname() + "'!", (Throwable)exception.get());
        }
        this.waitForService(true);
        if (exception.get() != null) {
            throw new TigerTestEnvException("Unable to start external jar '" + this.getHostname() + "'!", (Throwable)exception.get());
        }
        if (this.getStatus() == TigerServerStatus.STOPPED) {
            throw new TigerEnvironmentStartupException("Unable to start external jar '" + this.getHostname() + "'!");
        }
        if (this.getStatus() == TigerServerStatus.STARTING) {
            this.waitForService(false);
            if (exception.get() != null) {
                throw new TigerTestEnvException("Unable to start external jar '" + this.getHostname() + "'!", (Throwable)exception.get());
            }
            throw new TigerTestEnvException("Unable to start external jar '" + this.getHostname() + "'!");
        }
    }

    @Override
    public TigerServerStatus updateStatus(boolean quiet) {
        if (!this.processReference.get().isAlive()) {
            log.warn("Process {} is stopped!", (Object)this.processReference.get().pid());
            this.setStatus(TigerServerStatus.STOPPED);
            if (LocalDateTime.now().isBefore(this.processStartTime.plusSeconds(3L))) {
                log.warn("{}: Unusually short process run time ({})! Suspecting defunct jar! (Exitcode={})", new Object[]{this.getHostname(), Duration.between(LocalDateTime.now(), this.processStartTime), this.processReference.get().exitValue()});
                this.cleanupDefunctJar();
            }
            return this.getStatus();
        }
        return super.updateStatus(quiet);
    }

    private void cleanupDefunctJar() {
        if (!((String)this.getConfiguration().getSource().get(0)).startsWith("local:") && this.jarFile.exists() && !this.jarFile.delete()) {
            log.warn("Unable to delete jar file {}", (Object)this.jarFile.getAbsolutePath());
        }
    }

    @Override
    public void shutdown() {
        log.info("Stopping external jar {}...", (Object)this.getHostname());
        this.removeAllRoutes();
        this.stopExternalProcess();
    }

    private void stopExternalProcess() {
        if (this.processReference.get() != null) {
            log.info("Stopping external process (pid={})", (Object)this.processReference.get().pid());
            log.info("interrupting threads...");
            this.processReference.get().destroy();
            log.info("stopping threads...");
            this.processReference.get().destroyForcibly();
        } else {
            log.warn("Process for server {} not found... No need to shutdown", (Object)this.getHostname());
        }
    }

    private String findJavaExecutable() {
        String javaHomeDirectory = (String)TigerGlobalConfiguration.readStringOptional((String)"tiger.lib.javaHome").or(() -> TigerGlobalConfiguration.readStringOptional((String)"java.home")).orElseThrow(() -> new TigerEnvironmentStartupException("Could not determine java-home. Expected either 'tiger.lib.javaHome' oder 'java.home' to be set, but neither was!"));
        if (System.getProperty("os.name").startsWith("Win")) {
            return javaHomeDirectory + File.separator + "bin" + File.separator + "java.exe";
        }
        return javaHomeDirectory + File.separator + "bin" + File.separator + "java";
    }

    @Generated
    public static ExternalJarServerBuilder builder() {
        return new ExternalJarServerBuilder();
    }

    @Generated
    public static class ExternalJarServerBuilder {
        @Generated
        private String serverId;
        @Generated
        private CfgServer configuration;
        @Generated
        private TigerTestEnvMgr tigerTestEnvMgr;

        @Generated
        ExternalJarServerBuilder() {
        }

        @Generated
        public ExternalJarServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public ExternalJarServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public ExternalJarServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        @Generated
        public ExternalJarServer build() {
            return new ExternalJarServer(this.serverId, this.configuration, this.tigerTestEnvMgr);
        }

        @Generated
        public String toString() {
            return "ExternalJarServer.ExternalJarServerBuilder(serverId=" + this.serverId + ", configuration=" + this.configuration + ", tigerTestEnvMgr=" + this.tigerTestEnvMgr + ")";
        }
    }
}

