/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.data.config.CfgDockerOptions;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerServer
extends TigerServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerServer.class);

    DockerServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(DockerServer.determineHostname(configuration, serverId), serverId, tigerTestEnvMgr, configuration);
    }

    @Override
    public void performStartup() {
        log.info(Ansi.colorize((String)"Starting docker container for {} :{}", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD), (Object)this.getHostname(), (Object)this.getDockerSource());
        this.statusMessage("Starting docker container");
        this.getTigerTestEnvMgr().getDockerManager().startContainer(this);
        if (this.getConfiguration().getDockerOptions().getPorts() != null && !this.getConfiguration().getDockerOptions().getPorts().isEmpty()) {
            this.addRoute(TigerRoute.builder().from("http://" + this.getHostname()).to("http://localhost:" + this.getConfiguration().getDockerOptions().getPorts().values().iterator().next()).build());
        }
        log.info(Ansi.colorize((String)"Docker container Startup for {} : {} OK", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD), (Object)this.getHostname(), (Object)this.getDockerSource());
        this.statusMessage("Docker container started");
    }

    public String getDockerSource() {
        return (String)this.getConfiguration().getSource().get(0);
    }

    public CfgDockerOptions getDockerOptions() {
        return this.getConfiguration().getDockerOptions();
    }

    @Override
    public void shutdown() {
        log.info("Stopping docker container {}...", (Object)this.getHostname());
        this.removeAllRoutes();
        this.getTigerTestEnvMgr().getDockerManager().stopContainer(this);
    }

    @Override
    public String getDestinationUrl(String fallbackProtocol) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.guessAServerUrl()).setPath("");
            if (StringUtils.isNotEmpty((CharSequence)fallbackProtocol)) {
                uriBuilder.setScheme(fallbackProtocol);
            }
            return uriBuilder.build().toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new TigerEnvironmentStartupException("Unable to build destination URL", e);
        }
    }

    private String guessAServerUrl() {
        if (StringUtils.isNotEmpty((CharSequence)this.getConfiguration().getHealthcheckUrl())) {
            return this.getConfiguration().getHealthcheckUrl();
        }
        if (this.getStatus() != TigerServerStatus.RUNNING) {
            throw new TigerTestEnvException("If reverse proxy is to be used with docker container '" + this.getHostname() + "' make sure to start it first or have a valid healthcheck setting!");
        }
        return "http://127.0.0.1:" + this.getConfiguration().getDockerOptions().getPorts().values().iterator().next();
    }

    @Generated
    public static DockerServerBuilder builder() {
        return new DockerServerBuilder();
    }

    @Generated
    public static class DockerServerBuilder {
        @Generated
        private String serverId;
        @Generated
        private CfgServer configuration;
        @Generated
        private TigerTestEnvMgr tigerTestEnvMgr;

        @Generated
        DockerServerBuilder() {
        }

        @Generated
        public DockerServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public DockerServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public DockerServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        @Generated
        public DockerServer build() {
            return new DockerServer(this.serverId, this.configuration, this.tigerTestEnvMgr);
        }

        @Generated
        public String toString() {
            return "DockerServer.DockerServerBuilder(serverId=" + this.serverId + ", configuration=" + this.configuration + ", tigerTestEnvMgr=" + this.tigerTestEnvMgr + ")";
        }
    }
}

