/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.data.config.CfgDockerOptions;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DockerComposeServer
extends TigerServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerComposeServer.class);

    DockerComposeServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(DockerComposeServer.determineHostname(configuration, serverId), serverId, tigerTestEnvMgr, configuration);
    }

    @Override
    public void performStartup() {
        log.info(Ansi.colorize((String)"Starting docker compose for {} :{}", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD), (Object)this.getHostname(), (Object)this.getDockerSource());
        this.statusMessage("Starting docker compose");
        this.getTigerTestEnvMgr().getDockerManager().startComposition(this);
        if (this.getConfiguration().getDockerOptions().getPorts() != null && !this.getConfiguration().getDockerOptions().getPorts().isEmpty()) {
            this.addRoute(TigerRoute.builder().from("http://" + this.getHostname()).to("http://localhost:" + this.getConfiguration().getDockerOptions().getPorts().values().iterator().next()).build());
        }
        log.info(Ansi.colorize((String)"Docker compose Startup for {} : {} OK", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD), (Object)this.getHostname(), (Object)this.getDockerSource());
        this.statusMessage("Docker compose started");
    }

    public String getDockerSource() {
        return (String)this.getConfiguration().getSource().get(0);
    }

    public CfgDockerOptions getDockerOptions() {
        return this.getConfiguration().getDockerOptions();
    }

    public List<String> getSource() {
        if (this.getConfiguration().getSource() == null) {
            return List.of();
        }
        return Collections.unmodifiableList(this.getConfiguration().getSource());
    }

    @Override
    public void shutdown() {
        log.info("Stopping docker compose {}...", (Object)this.getHostname());
        this.removeAllRoutes();
    }

    @Generated
    public static DockerComposeServerBuilder builder() {
        return new DockerComposeServerBuilder();
    }

    @Generated
    public static class DockerComposeServerBuilder {
        @Generated
        private String serverId;
        @Generated
        private CfgServer configuration;
        @Generated
        private TigerTestEnvMgr tigerTestEnvMgr;

        @Generated
        DockerComposeServerBuilder() {
        }

        @Generated
        public DockerComposeServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public DockerComposeServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public DockerComposeServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        @Generated
        public DockerComposeServer build() {
            return new DockerComposeServer(this.serverId, this.configuration, this.tigerTestEnvMgr);
        }

        @Generated
        public String toString() {
            return "DockerComposeServer.DockerComposeServerBuilder(serverId=" + this.serverId + ", configuration=" + this.configuration + ", tigerTestEnvMgr=" + this.tigerTestEnvMgr + ")";
        }
    }
}

