/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.env;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.PullResponseItem;
import com.github.dockerjava.api.model.ResponseItem;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.testenvmgr.servers.DockerComposeServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class DockerMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerMgr.class);
    private static final int MOD_ALL_EXEC = 511;
    private static final String CLZPATH = "classpath:";
    private final Map<String, GenericContainer<?>> containers = new HashMap();

    public void startContainer(DockerServer server) {
        String imageName = this.buildImageName(server);
        DockerImageName testContainersImageName = DockerImageName.parse((String)imageName);
        this.pullImage(imageName);
        GenericContainer container = new GenericContainer(testContainersImageName);
        try {
            InspectImageResponse iiResponse = container.getDockerClient().inspectImageCmd(imageName).exec();
            ContainerConfig containerConfig = iiResponse.getConfig();
            if (containerConfig == null) {
                throw new TigerTestEnvException("Docker image '" + imageName + "' has no configuration info!");
            }
            if (server.getDockerOptions().isProxied()) {
                File tmpScriptFolder;
                String[] startCmd = containerConfig.getCmd();
                String[] entryPointCmd = containerConfig.getEntrypoint();
                if (StringUtils.isNotEmpty((CharSequence)server.getDockerOptions().getEntryPoint())) {
                    entryPointCmd = new String[]{server.getDockerOptions().getEntryPoint()};
                }
                if (entryPointCmd != null && entryPointCmd[0].equals("/bin/sh") && entryPointCmd[1].equals("-c")) {
                    entryPointCmd = new String[]{"su", containerConfig.getUser(), "-c", "'" + entryPointCmd[2] + "'"};
                }
                if (!(tmpScriptFolder = Path.of("target", "tiger-testenv-mgr").toFile()).exists() && !tmpScriptFolder.mkdirs()) {
                    throw new TigerTestEnvException("Unable to create temp folder for modified startup script for server " + server.getHostname());
                }
                String scriptName = this.createContainerStartupScript(server, iiResponse, startCmd, entryPointCmd);
                String containerScriptPath = containerConfig.getWorkingDir() + "/" + scriptName;
                container.withExtraHost("host.docker.internal", "host-gateway");
                container.withCopyFileToContainer(MountableFile.forHostPath((Path)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName), (Integer)511), containerScriptPath);
                container.withCreateContainerCmdModifier(cmd -> cmd.withUser("root").withEntrypoint(new String[]{containerScriptPath}));
            }
            container.setLogConsumers(List.of(new Slf4jLogConsumer(log)));
            log.info("Passing in environment:");
            this.addEnvVarsToContainer(container, server.getEnvironmentProperties());
            if (server.getDockerOptions().isOneShot()) {
                container.withStartupCheckStrategy((StartupCheckStrategy)new OneShotStartupCheckStrategy());
            }
            container.start();
            this.waitForHealthyStartup(server, container);
            container.getDockerClient().renameContainerCmd(container.getContainerId()).withName("tiger." + server.getHostname()).exec();
            this.containers.put(server.getHostname(), container);
            HashMap ports = new HashMap();
            container.getContainerInfo().getNetworkSettings().getPorts().getBindings().entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> ports.put(((ExposedPort)entry.getKey()).getPort(), Integer.valueOf(((Ports.Binding[])entry.getValue())[0].getHostPortSpec())));
            server.getDockerOptions().setPorts(ports);
        }
        catch (DockerException de) {
            throw new TigerTestEnvException("Failed to start container for server " + server.getHostname(), de);
        }
    }

    private String buildImageName(DockerServer server) {
        Object result = server.getDockerSource();
        if (server.getTigerTestEnvMgr() == null) {
            result = server.getTigerTestEnvMgr().replaceSysPropsInString(server.getDockerSource());
        }
        if (server.getConfiguration().getVersion() != null) {
            result = (String)result + ":" + server.getConfiguration().getVersion();
        }
        return result;
    }

    /*
     * Exception decompiling
     */
    public void startComposition(DockerComposeServer server) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addEnvVarsToContainer(GenericContainer<?> container, List<String> envVars) {
        envVars.stream().filter(i -> i.contains("=")).map(i -> i.split("=", 2)).peek(envvar -> log.info("  * " + envvar[0] + "=" + envvar[1])).forEach(envvar -> container.addEnv(TigerGlobalConfiguration.resolvePlaceholders((String)envvar[0]), TigerGlobalConfiguration.resolvePlaceholders((String)envvar[1])));
    }

    public void pullImage(String imageName) {
        log.info("Pulling docker image " + imageName + "...");
        final AtomicBoolean pullComplete = new AtomicBoolean();
        pullComplete.set(false);
        final AtomicReference cbException = new AtomicReference();
        DockerClientFactory.instance().client().pullImageCmd(imageName).exec((ResultCallback)new ResultCallback.Adapter<PullResponseItem>(){

            public void onNext(PullResponseItem item) {
                if (log.isDebugEnabled()) {
                    log.debug("{} {}", (Object)item.getStatus(), (Object)Optional.ofNullable(item.getProgressDetail()).map(ResponseItem.ProgressDetail::getCurrent).map(Object::toString).orElse(""));
                }
            }

            public void onError(Throwable throwable) {
                cbException.set(throwable);
            }

            public void onComplete() {
                pullComplete.set(true);
            }
        });
        while (!pullComplete.get()) {
            if (cbException.get() != null) {
                throw new TigerTestEnvException("Unable to pull image " + imageName + "!", (Throwable)cbException.get());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.warn("Interruption signaled", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        log.info("Docker image " + imageName + " is available locally!");
    }

    private String createContainerStartupScript(TigerServer server, InspectImageResponse iiResponse, String[] startCmd, String[] entryPointCmd) {
        ContainerConfig containerConfig = iiResponse.getConfig();
        if (containerConfig == null) {
            throw new TigerTestEnvException("Docker image of server '" + server.getHostname() + "' has no configuration info!");
        }
        startCmd = startCmd == null ? new String[]{} : startCmd;
        entryPointCmd = entryPointCmd == null ? new String[]{} : entryPointCmd;
        try {
            String proxycert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/CertificateAuthorityCertificate.pem")), (Charset)StandardCharsets.UTF_8);
            String lecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/letsencrypt.crt")), (Charset)StandardCharsets.UTF_8);
            String risecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/idp-rise-tu.crt")), (Charset)StandardCharsets.UTF_8);
            File tmpScriptFolder = Path.of("target", "tiger-testenv-mgr").toFile();
            if (!tmpScriptFolder.exists() && !tmpScriptFolder.mkdirs()) {
                throw new TigerTestEnvException("Unable to create script folder " + tmpScriptFolder.getAbsolutePath());
            }
            String scriptName = "__tigerStart_" + server.getHostname() + ".sh";
            String content = "#!/bin/sh -x\nenv\necho \"" + proxycert + "\" >> /etc/ssl/certs/ca-certificates.crt\necho \"" + lecert + "\" >> /etc/ssl/certs/ca-certificates.crt\necho \"" + risecert + "\" >> /etc/ssl/certs/ca-certificates.crt\n";
            content = content + this.getContainerWorkingDirectory(containerConfig) + String.join((CharSequence)" ", entryPointCmd).replace("\t", " ") + " " + String.join((CharSequence)" ", startCmd).replace("\t", " ") + "\n";
            FileUtils.writeStringToFile((File)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName).toFile(), (String)content, (Charset)StandardCharsets.UTF_8);
            return scriptName;
        }
        catch (IOException ioe) {
            throw new TigerTestEnvException("Failed to configure start script on container for server " + server.getHostname(), ioe);
        }
    }

    private String getContainerWorkingDirectory(ContainerConfig containerConfig) {
        if (containerConfig.getWorkingDir() == null || containerConfig.getWorkingDir().isBlank()) {
            return "";
        }
        return "cd " + containerConfig.getWorkingDir() + "\n";
    }

    private void waitForHealthyStartup(TigerServer server, GenericContainer<?> container) {
        long startms = System.currentTimeMillis();
        long endhalfms = server.getStartupTimeoutSec().map(seconds -> (long)seconds.intValue() * 500L).orElse(5000L);
        try {
            Thread.sleep(endhalfms);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for startup of server " + server.getHostname(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            while (!container.isHealthy()) {
                Thread.sleep(500L);
                if (startms + endhalfms * 2L >= System.currentTimeMillis()) continue;
                throw new TigerTestEnvException("Startup of server %s timed out after %d seconds!", server.getHostname(), (System.currentTimeMillis() - startms) / 1000L);
            }
            log.info("HealthCheck OK (" + (container.isHealthy() ? 1 : 0) + ") for " + server.getHostname());
        }
        catch (InterruptedException ie) {
            log.warn("Interruption signaled while waiting for server " + server.getHostname() + " to start up", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TigerTestEnvException ttee) {
            throw ttee;
        }
        catch (RuntimeException rte) {
            int timeout = server.getStartupTimeoutSec().orElse(20);
            log.warn("probably no health check configured - defaulting to " + timeout + "s startup time");
            try {
                Thread.sleep((long)timeout * 1000L);
            }
            catch (InterruptedException interruptedException) {
                log.warn("Interruption signaled");
                Thread.currentThread().interrupt();
            }
            log.warn("HealthCheck UNCLEAR for " + server.getHostname() + " as no healthcheck is configured, we assume it works and continue setup!");
        }
    }

    public void stopContainer(TigerServer server) {
        GenericContainer<?> container = this.containers.get(server.getHostname());
        if (container != null && container.getDockerClient() != null) {
            try {
                container.getDockerClient().stopContainerCmd(container.getContainerId()).exec();
            }
            catch (NotModifiedException nmex) {
                log.warn("Failed to issue stop container cmd from docker client, trying test container's stop...");
            }
            container.stop();
        }
    }

    public void pauseContainer(DockerServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getHostname());
        container.getDockerClient().pauseContainerCmd(container.getContainerId()).exec();
    }

    public void unpauseContainer(DockerServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getHostname());
        container.getDockerClient().unpauseContainerCmd(container.getContainerId()).exec();
    }

    @Generated
    public Map<String, GenericContainer<?>> getContainers() {
        return this.containers;
    }

    private static /* synthetic */ File[] lambda$startComposition$4(int x$0) {
        return new File[x$0];
    }

    private /* synthetic */ File lambda$startComposition$3(File folder, String f) {
        if (f.startsWith(CLZPATH)) {
            File tmpFile = Paths.get(folder.getAbsolutePath(), f.substring(CLZPATH.length())).toFile();
            InputStream is = this.getClass().getResourceAsStream(f.substring(CLZPATH.length()));
            if (is == null) {
                throw new TigerTestEnvException("Missing docker compose file in classpath " + f);
            }
            if (!tmpFile.getParentFile().exists() && !tmpFile.getParentFile().mkdirs()) {
                throw new TigerTestEnvException("Unable to create temp folder " + tmpFile.getParentFile().getAbsolutePath());
            }
            try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                IOUtils.copy((InputStream)is, (OutputStream)fos);
                f = tmpFile.getAbsolutePath();
            }
            catch (IOException ioe) {
                throw new TigerTestEnvException("Unable to create temp docker compose files (" + f + ")", ioe);
            }
        }
        return new File(f);
    }
}

