/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.pki.TigerConfigurationPkiIdentity;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.testenvmgr.ITigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import de.gematik.test.tiger.testenvmgr.env.DockerMgr;
import de.gematik.test.tiger.testenvmgr.env.DownloadManager;
import de.gematik.test.tiger.testenvmgr.env.TigerEnvUpdateSender;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.env.TigerUpdateListener;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import java.awt.Desktop;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.Console;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerTestEnvMgr
implements ITigerTestEnvMgr,
TigerEnvUpdateSender,
TigerUpdateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestEnvMgr.class);
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    private final Configuration configuration;
    private final DockerMgr dockerManager;
    private final Map<String, Object> environmentVariables;
    private final TigerProxy localTigerProxy;
    private final List<TigerRoute> routesList = new ArrayList<TigerRoute>();
    private final Map<String, TigerServer> servers = new HashMap<String, TigerServer>();
    private final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);
    private List<TigerUpdateListener> listeners = new ArrayList<TigerUpdateListener>();
    private DownloadManager downloadManager = new DownloadManager();

    public TigerTestEnvMgr() {
        Configuration configuration = TigerTestEnvMgr.readConfiguration();
        this.dockerManager = new DockerMgr();
        this.localTigerProxy = this.startLocalTigerProxy(configuration);
        if (configuration.isLocalProxyActive()) {
            log.info("Started local tiger proxy on port " + this.localTigerProxy.getProxyPort() + "...");
            this.environmentVariables = new HashMap<String, Integer>(Map.of("PROXYHOST", "host.docker.internal", "PROXYPORT", this.localTigerProxy.getProxyPort()));
        } else {
            log.info("Local docker tiger proxy deactivated");
            this.environmentVariables = new HashMap<String, Object>();
        }
        this.configuration = configuration;
        this.createServerObjects();
        log.info("Tiger Testenv mgr created OK");
    }

    private TigerProxy startLocalTigerProxy(Configuration configuration) {
        if (configuration.getTigerProxy() == null) {
            configuration.setTigerProxy(TigerProxyConfiguration.builder().build());
        }
        TigerProxyConfiguration proxyConfig = configuration.getTigerProxy();
        proxyConfig.setSkipTrafficEndpointsSubscription(true);
        if (proxyConfig.getProxyRoutes() == null) {
            proxyConfig.setProxyRoutes(List.of());
        }
        if (proxyConfig.getTls().getServerRootCa() == null) {
            proxyConfig.getTls().setServerRootCa(new TigerConfigurationPkiIdentity("CertificateAuthorityCertificate.pem;PKCS8CertificateAuthorityPrivateKey.pem;PKCS8"));
        }
        TigerProxy localTigerProxy = new TigerProxy(configuration.getTigerProxy());
        return localTigerProxy;
    }

    public static void waitForQuit(String appName) {
        Console c = System.console();
        if (c != null) {
            c.format("\n\n\nPress 'quit' and ENTER to stop " + appName + ".\n\n\n\n\n", new Object[0]);
            String cmd = "";
            while (!cmd.equals("quit")) {
                cmd = c.readLine();
            }
            log.info("Stopping " + appName + "...");
        } else {
            log.warn("No Console interface found, trying System in stream...");
            log.info("\n\n\nPress 'quit' and ENTER to stop " + appName + ".\n\n\n\n\n");
            try {
                BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
                String cmd = "";
                while (!cmd.equals("quit")) {
                    cmd = rdr.readLine();
                }
            }
            catch (IOException e) {
                log.warn("Unable to open input stream from console! Running " + appName + " for max. 24 hours.You will have to use Ctrl+C and eventually clean up the processes manually!");
                Awaitility.await().atMost(24L, TimeUnit.HOURS).pollDelay(1L, TimeUnit.SECONDS).until(() -> false);
            }
        }
    }

    private static void readTemplates() {
        try {
            URL templatesUrl = TigerTestEnvMgr.class.getResource("templates.yaml");
            String templatesYaml = IOUtils.toString((URI)Objects.requireNonNull(templatesUrl).toURI(), (Charset)StandardCharsets.UTF_8);
            TigerGlobalConfiguration.readTemplates((String)templatesYaml, (String[])new String[]{"tiger", "servers"});
        }
        catch (IOException | URISyntaxException e) {
            throw new TigerConfigurationException("Unable to read templates YAML!", (Throwable)e);
        }
    }

    private static Configuration readConfiguration() {
        TigerGlobalConfiguration.initialize();
        TigerTestEnvMgr.readTemplates();
        Configuration configuration = TigerGlobalConfiguration.instantiateConfigurationBean(Configuration.class, (String[])new String[]{"tiger"}).orElseGet(Configuration::new);
        for (CfgServer cfgServer : configuration.getServers().values()) {
            if (!StringUtils.isNotEmpty((CharSequence)cfgServer.getTemplate())) continue;
            throw new TigerConfigurationException("Could not resolve template '" + cfgServer.getTemplate() + "'");
        }
        return configuration;
    }

    private void assertNoCyclesInGraph() {
        this.servers.values().forEach(server -> this.cycleChecker((TigerServer)server, (Set<TigerServer>)new HashSet<TigerServer>()));
    }

    private void cycleChecker(TigerServer currentPosition, Set<TigerServer> visitedServer) {
        if (visitedServer.contains(currentPosition)) {
            throw new TigerEnvironmentStartupException("Cyclic graph detected in startup sequence: " + visitedServer.stream().map(TigerServer::getServerId).collect(Collectors.toList()));
        }
        if (currentPosition.getDependUponList().isEmpty()) {
            System.out.println(visitedServer);
            return;
        }
        for (TigerServer server : currentPosition.getDependUponList()) {
            HashSet<TigerServer> newSet = new HashSet<TigerServer>(visitedServer);
            newSet.add(currentPosition);
            this.cycleChecker(server, newSet);
        }
    }

    private void createServerObjects() {
        for (Map.Entry<String, CfgServer> serverEntry : this.configuration.getServers().entrySet()) {
            if (!serverEntry.getValue().isActive()) continue;
            TigerServer server = TigerServer.create(serverEntry.getKey(), serverEntry.getValue(), this);
            this.servers.put(serverEntry.getKey(), server);
            server.registerNewListener(this);
        }
    }

    @Override
    public void setUpEnvironment() {
        this.assertNoCyclesInGraph();
        this.assertNoUnknownServersInDependencies();
        log.info("starting set up of test environment...");
        List initialServersToBoot = this.servers.values().parallelStream().filter(server -> server.getDependUponList().isEmpty()).collect(Collectors.toList());
        log.info("Starting setup by triggering boot of following server: {}", initialServersToBoot.stream().map(TigerServer::getHostname).collect(Collectors.toList()));
        initialServersToBoot.parallelStream().forEach(this::startServer);
        this.localTigerProxy.subscribeToTrafficEndpoints(this.configuration.getTigerProxy());
        log.info(Ansi.colorize((String)"finished set up test environment OK", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
    }

    private void assertNoUnknownServersInDependencies() {
        this.getServers().values().stream().forEach(TigerServer::getDependUponList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer(TigerServer server) {
        TigerServer tigerServer = server;
        synchronized (tigerServer) {
            if (server.getStatus() != TigerServerStatus.NEW) {
                return;
            }
            server.start(this);
        }
        this.servers.values().parallelStream().peek(toBeStartedServer -> log.debug("Considering starting server {} with status {}...", (Object)toBeStartedServer.getHostname(), (Object)toBeStartedServer.getStatus())).filter(candidate -> candidate.getStatus() == TigerServerStatus.NEW).filter(candidate -> candidate.getDependUponList().stream().filter(depending -> depending.getStatus() != TigerServerStatus.RUNNING).findAny().isEmpty()).peek(toBeStartedServer -> log.info("About to start server {} with status {}", (Object)toBeStartedServer.getHostname(), (Object)toBeStartedServer.getStatus())).forEach(this::startServer);
    }

    public String replaceSysPropsInString(String str) {
        return str;
    }

    @Override
    public void shutDown() {
        log.info("Shutting down local tiger proxy...");
        this.localTigerProxy.shutdown();
        log.info("Shutting down server all servers...");
        this.servers.values().stream().forEach(TigerServer::shutdown);
    }

    @Override
    public void receiveTestEnvUpdate(TigerStatusUpdate statusUpdate) {
        this.listeners.forEach(listener -> listener.receiveTestEnvUpdate(statusUpdate));
    }

    public List<TigerRoute> getRoutes() {
        return this.servers.values().stream().map(TigerServer::getRoutes).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
    }

    public Optional<TigerServer> findServer(String serverName) {
        return Optional.ofNullable(this.servers.get(serverName));
    }

    public boolean isLocalTigerProxyActive() {
        if (this.configuration == null) {
            return true;
        }
        return this.configuration.isLocalProxyActive();
    }

    @Override
    public void registerNewListener(TigerUpdateListener listener) {
        this.listeners.add(listener);
    }

    public static void openWorkflowUiInBrowser(String adminPort) {
        try {
            String url = "http://localhost:" + adminPort;
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop desktop = Desktop.getDesktop();
                try {
                    desktop.browse(new URI(url));
                }
                catch (Exception e) {
                    log.error("Exception thrown during opening browser for Workflow UI via Desktop API", (Throwable)e);
                }
            } else {
                String command;
                Runtime runtime = Runtime.getRuntime();
                String operatingSystemName = System.getProperty("os.name").toLowerCase();
                if (operatingSystemName.contains("nix") || operatingSystemName.contains("nux")) {
                    command = "xdg-open " + url;
                } else if (operatingSystemName.contains("win")) {
                    command = "rundll32 url.dll,FileProtocolHandler " + url;
                } else if (operatingSystemName.contains("mac")) {
                    command = "open " + url;
                } else {
                    log.error("Unknown operation system '{}'", (Object)operatingSystemName);
                    return;
                }
                try {
                    log.info("Starting Workflow UI via '{}'", (Object)command);
                    runtime.exec(command);
                }
                catch (IOException e) {
                    log.error("IOException thrown during opening browser", (Throwable)e);
                }
            }
        }
        catch (HeadlessException hex) {
            log.error("Unable to start Workflow UI on a headless server!", (Throwable)hex);
        }
        catch (Exception e) {
            log.error("Exception while trying to start browser for Workflow UI", (Throwable)e);
        }
    }

    @Override
    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public DockerMgr getDockerManager() {
        return this.dockerManager;
    }

    @Generated
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Generated
    public TigerProxy getLocalTigerProxy() {
        return this.localTigerProxy;
    }

    @Generated
    public List<TigerRoute> getRoutesList() {
        return this.routesList;
    }

    @Generated
    public Map<String, TigerServer> getServers() {
        return this.servers;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }

    @Generated
    public List<TigerUpdateListener> getListeners() {
        return this.listeners;
    }

    @Generated
    public DownloadManager getDownloadManager() {
        return this.downloadManager;
    }
}

