/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.config.ServerType;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.CfgTigerProxyOptions;
import de.gematik.test.tiger.common.data.config.PkiType;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.pki.KeyMgr;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.testenvmgr.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerComposeServer;
import de.gematik.test.tiger.testenvmgr.servers.DockerServer;
import de.gematik.test.tiger.testenvmgr.servers.ExternalJarServer;
import de.gematik.test.tiger.testenvmgr.servers.ExternalUrlServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerProxyServer;
import java.io.File;
import java.lang.reflect.Method;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.security.Key;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.junit.platform.commons.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.SocketUtils;

public abstract class TigerServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerServer.class);
    public static final int DEFAULT_STARTUP_TIMEOUT_IN_SECONDS = 20;
    private final String hostname;
    private final String serverId;
    private final List<String> environmentProperties = new ArrayList<String>();
    private final List<TigerRoute> routes = new ArrayList<TigerRoute>();
    private final TigerTestEnvMgr tigerTestEnvMgr;
    private CfgServer configuration;
    private TigerServerStatus status = TigerServerStatus.NEW;

    public TigerServer(String hostname, String serverId, TigerTestEnvMgr tigerTestEnvMgr, CfgServer configuration) {
        this.hostname = hostname;
        this.serverId = serverId;
        this.tigerTestEnvMgr = tigerTestEnvMgr;
        this.configuration = configuration;
    }

    public static TigerServer create(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        if (configuration.getType() == null) {
            throw new TigerTestEnvException("No server type configured for server '" + serverId + "'");
        }
        switch (configuration.getType()) {
            case DOCKER: {
                return DockerServer.builder().configuration(configuration).tigerTestEnvMgr(tigerTestEnvMgr).serverId(serverId).build();
            }
            case DOCKER_COMPOSE: {
                return DockerComposeServer.builder().configuration(configuration).tigerTestEnvMgr(tigerTestEnvMgr).serverId(serverId).build();
            }
            case EXTERNALURL: {
                return ExternalUrlServer.builder().configuration(configuration).serverId(serverId).tigerTestEnvMgr(tigerTestEnvMgr).build();
            }
            case EXTERNALJAR: {
                return ExternalJarServer.builder().configuration(configuration).serverId(serverId).tigerTestEnvMgr(tigerTestEnvMgr).build();
            }
            case TIGERPROXY: {
                return new TigerProxyServer(serverId, configuration, tigerTestEnvMgr);
            }
        }
        throw new TigerTestEnvException(String.format("Unsupported server type %s found in server %s", configuration.getType(), serverId));
    }

    static String determineHostname(CfgServer configuration, String serverId) {
        if (StringUtils.isNotBlank((String)configuration.getHostname())) {
            return configuration.getHostname();
        }
        return serverId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(TigerTestEnvMgr testEnvMgr) {
        TigerServer tigerServer = this;
        synchronized (tigerServer) {
            if (this.status != TigerServerStatus.NEW) {
                throw new TigerEnvironmentStartupException("Server " + this.getServerId() + " was already started!");
            }
            this.status = TigerServerStatus.STARTING;
        }
        this.reloadConfiguration();
        this.assertThatConfigurationIsCorrect();
        ServerType type = this.configuration.getType();
        this.configuration.getEnvironment().stream().map(testEnvMgr::replaceSysPropsInString).forEach(this.environmentProperties::add);
        if (this.configuration.getUrlMappings() != null) {
            this.configuration.getUrlMappings().forEach(mapping -> {
                if (StringUtils.isBlank((String)mapping) || !mapping.contains("-->") || mapping.split(" --> ", 2).length != 2) {
                    throw new TigerConfigurationException("The urlMappings configuration '" + mapping + "' is not correct. Please check your .yaml-file.");
                }
                String[] routeParts = mapping.split(" --> ", 2);
                testEnvMgr.getLocalTigerProxy().addRoute(TigerRoute.builder().from(routeParts[0]).to(routeParts[1]).build());
            });
        }
        this.loadPkiForProxy();
        try {
            this.performStartup();
        }
        catch (RuntimeException e) {
            log.warn("Error during startup of server {}. Used configuration was {}", (Object)this.getHostname(), (Object)TigerSerializationUtil.toJson((Object)((Object)this.getConfiguration())));
            throw e;
        }
        this.configuration.getExports().forEach(exp -> {
            String[] kvp = exp.split("=", 2);
            if (type == ServerType.DOCKER && this.configuration.getDockerOptions().getPorts() != null) {
                this.configuration.getDockerOptions().getPorts().forEach((localPort, externPort) -> {
                    kvp[1] = kvp[1].replace("${PORT:" + localPort + "}", String.valueOf(externPort));
                });
            }
            kvp[1] = kvp[1].replace("${NAME}", this.getHostname());
            log.info("  setting global property " + kvp[0] + "=" + kvp[1]);
            TigerGlobalConfiguration.putValue((String)kvp[0], (String)kvp[1], (SourceType)SourceType.RUNTIME_EXPORT);
        });
        TigerServer tigerServer2 = this;
        synchronized (tigerServer2) {
            this.status = TigerServerStatus.RUNNING;
        }
    }

    private void reloadConfiguration() {
        try {
            this.configuration = (CfgServer)((Object)TigerGlobalConfiguration.instantiateConfigurationBean(CfgServer.class, (String[])new String[]{"tiger", "servers", this.getServerId()}));
            this.tigerTestEnvMgr.getConfiguration().getServers().put(this.getServerId(), this.configuration);
        }
        catch (TigerConfigurationException e) {
            log.warn("Could not reload configuration for server {}", (Object)this.getServerId(), (Object)e);
        }
    }

    private void loadPkiForProxy() {
        log.info("  loading PKI resources for instance {}...", (Object)this.getHostname());
        this.getConfiguration().getPkiKeys().stream().filter(key -> key.getType() == PkiType.Certificate).forEach(key -> {
            if (StringUtils.isBlank((String)key.getPem())) {
                throw new TigerConfigurationException("Your certificate is empty, please check your .yaml-file for " + key.getId());
            }
            log.info("Adding certificate " + key.getId());
            this.getTigerTestEnvMgr().getLocalTigerProxy().addKey(key.getId(), (Key)KeyMgr.readCertificateFromPem((String)("-----BEGIN CERTIFICATE-----\n" + key.getPem().replace(" ", "\n") + "\n-----END CERTIFICATE-----")).getPublicKey());
        });
        this.getConfiguration().getPkiKeys().stream().filter(key -> key.getType() == PkiType.Key).forEach(key -> {
            if (StringUtils.isBlank((String)key.getPem())) {
                throw new TigerConfigurationException("Your Key is empty, please check your .yaml-file for " + key.getId());
            }
            log.info("Adding key " + key.getId());
            this.getTigerTestEnvMgr().getLocalTigerProxy().addKey(key.getId(), KeyMgr.readKeyFromPem((String)("-----BEGIN PRIVATE KEY-----\n" + key.getPem().replace(" ", "\n") + "\n-----END PRIVATE KEY-----")));
        });
    }

    public abstract void performStartup();

    public void assertThatConfigurationIsCorrect() {
        ServerType type = this.getConfiguration().getType();
        ((AbstractStringAssert)Assertions.assertThat((String)this.serverId).withFailMessage("Server Id must not be blank!", new Object[0])).isNotBlank();
        if (this instanceof DockerComposeServer && StringUtils.isNotBlank((String)this.getHostname())) {
            throw new TigerConfigurationException("Docker compose does not support a hostname for the node!");
        }
        this.assertCfgPropertySet((Object)this.getConfiguration(), "type");
        if (type == ServerType.DOCKER) {
            this.assertCfgPropertySet((Object)this.getConfiguration(), "version");
        }
        if (type == ServerType.TIGERPROXY) {
            if (this.getConfiguration().getTigerProxyCfg() == null) {
                this.getConfiguration().setTigerProxyCfg(new CfgTigerProxyOptions());
            }
            if (this.getConfiguration().getTigerProxyCfg().getServerPort() <= 0) {
                this.getConfiguration().getTigerProxyCfg().setServerPort(SocketUtils.findAvailableTcpPort());
            }
            if (this.getConfiguration().getTigerProxyCfg().getProxyCfg() == null || this.getConfiguration().getTigerProxyCfg().getProxyCfg().getPort() == null || this.getConfiguration().getTigerProxyCfg().getProxyCfg().getPort() <= 0) {
                throw new TigerTestEnvException("Missing proxy-port configuration for server '" + this.getHostname() + "'");
            }
        }
        if (this.getConfiguration().getStartupTimeoutSec() == null) {
            log.info("Defaulting startup timeout sec to 20sec for server " + this.serverId);
            this.getConfiguration().setStartupTimeoutSec(20);
        }
        if (type == ServerType.EXTERNALJAR) {
            File f;
            String folder = this.getConfiguration().getExternalJarOptions().getWorkingDir();
            if (folder == null) {
                folder = Path.of(System.getProperty("java.io.tmpdir"), "tiger_downloads").toFile().getAbsolutePath();
                log.info("Defaulting to temp folder '" + folder + "' as work dir for server " + this.serverId);
                this.getConfiguration().getExternalJarOptions().setWorkingDir(folder);
            }
            if (!(f = new File(folder)).exists() && !f.mkdirs()) {
                throw new TigerTestEnvException("Unable to create working dir folder " + f.getAbsolutePath());
            }
        }
        if (type != ServerType.TIGERPROXY) {
            this.assertCfgPropertySet((Object)this.getConfiguration(), "source");
        }
        if (type == ServerType.EXTERNALJAR) {
            this.assertCfgPropertySet((Object)this.getConfiguration(), "externalJarOptions", "healthcheck");
        }
        if (type == ServerType.TIGERPROXY && this.getConfiguration().getTigerProxyCfg().getServerPort() < 1) {
            throw new TigerTestEnvException("Server port for Tiger Proxy must be explicitly set!");
        }
    }

    private void assertCfgPropertySet(Object target, String ... propertyNames) {
        for (int i = 0; i < propertyNames.length; ++i) {
            String propertyName = propertyNames[i];
            Method mthd = target.getClass().getMethod("get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1), new Class[0]);
            if ((target = mthd.invoke(target, new Object[0])) == null) {
                throw new TigerTestEnvException("Server " + propertyName + " must be set and must not be NULL!");
            }
            if (target instanceof List) {
                List l = (List)target;
                if (l.isEmpty() || l.get(0) == null) {
                    throw new TigerTestEnvException("Server " + propertyName + " list must be set and must contain at least one not empty entry!");
                }
                if (!(l.get(0) instanceof String) || !((String)l.get(0)).isBlank()) continue;
                throw new TigerTestEnvException("Server " + propertyName + " list must be set and must contain at least one not empty entry!");
            }
            if (!(target instanceof String) || !((String)target).isBlank()) continue;
            throw new TigerTestEnvException("Server " + propertyName + " must be set and must not be empty!");
        }
    }

    public Optional<Integer> getStartupTimeoutSec() {
        return Optional.ofNullable(this.configuration.getStartupTimeoutSec());
    }

    void addServerToLocalProxyRouteMap(URL url) {
        try {
            int port = url.getPort();
            if (port == -1) {
                port = url.getDefaultPort();
            }
            this.addRoute(TigerRoute.builder().from("http://" + this.getHostname()).to(url.toURI().getScheme() + "://" + url.getHost() + ":" + port).build());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error while convert to URI: '" + url + "'", e);
        }
    }

    void addRoute(TigerRoute newRoute) {
        this.getTigerTestEnvMgr().getLocalTigerProxy().addRoute(newRoute);
        this.routes.add(newRoute);
    }

    void removeAllRoutes() {
        log.info("Removing routes for {}...", (Object)this.getHostname());
        this.routes.stream().map(TigerRoute::getId).forEach(arg_0 -> ((TigerProxy)this.getTigerTestEnvMgr().getLocalTigerProxy()).removeRoute(arg_0));
    }

    public abstract void shutdown();

    public List<TigerServer> getDependUponList() {
        if (StringUtils.isBlank((String)this.getConfiguration().getDependsUpon())) {
            return List.of();
        }
        return Stream.of(this.getConfiguration().getDependsUpon().split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(serverName -> this.tigerTestEnvMgr.findServer((String)serverName).orElseThrow(() -> new TigerEnvironmentStartupException("Unknown server: '" + serverName + "' in dependUponList of server '" + this.getServerId() + "'"))).collect(Collectors.toUnmodifiableList());
    }

    public String getDestinationUrl(String fallbackProtocol) {
        throw new TigerTestEnvException("Sophisticated reverse proxy for '" + this.getClass().getSimpleName() + "' is not supported!");
    }

    public void setStatus(TigerServerStatus newStatus) {
        this.status = newStatus;
    }

    @Generated
    public String getHostname() {
        return this.hostname;
    }

    @Generated
    public String getServerId() {
        return this.serverId;
    }

    @Generated
    public List<String> getEnvironmentProperties() {
        return this.environmentProperties;
    }

    @Generated
    public List<TigerRoute> getRoutes() {
        return this.routes;
    }

    @Generated
    public TigerTestEnvMgr getTigerTestEnvMgr() {
        return this.tigerTestEnvMgr;
    }

    @Generated
    public CfgServer getConfiguration() {
        return this.configuration;
    }

    @Generated
    public TigerServerStatus getStatus() {
        return this.status;
    }

    public static enum TigerServerStatus {
        NEW,
        STARTING,
        RUNNING,
        STOPPED;

    }
}

