/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.test.tiger.common.data.config.CfgTigerProxyOptions;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.util.TigerSerializationUtil;
import de.gematik.test.tiger.proxy.TigerProxyApplication;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.tigerProxyStandalone.CfgStandaloneProxy;
import de.gematik.test.tiger.testenvmgr.config.tigerProxyStandalone.CfgStandaloneServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import java.util.ArrayList;
import java.util.HashMap;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class TigerProxyServer
extends AbstractExternalTigerServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxyServer.class);
    private ConfigurableApplicationContext applicationContext;

    TigerProxyServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(TigerProxyServer.determineHostname(configuration, serverId), serverId, configuration, tigerTestEnvMgr);
    }

    @Override
    public void performStartup() {
        CfgTigerProxyOptions reverseProxyCfg = this.getConfiguration().getTigerProxyCfg();
        CfgStandaloneProxy standaloneCfg = new CfgStandaloneProxy();
        standaloneCfg.setServer(new CfgStandaloneServer());
        standaloneCfg.getServer().setPort(reverseProxyCfg.getServerPort());
        standaloneCfg.setTigerProxy(reverseProxyCfg.getProxyCfg());
        if (reverseProxyCfg.getProxyCfg().getProxyRoutes() == null) {
            reverseProxyCfg.getProxyCfg().setProxyRoutes(new ArrayList());
        }
        if (reverseProxyCfg.getProxiedServer() != null) {
            this.getDestinationUrlFromProxiedServer(reverseProxyCfg);
        }
        reverseProxyCfg.getProxyCfg().getProxyRoutes().forEach(route -> {
            route.setFrom(this.getTigerTestEnvMgr().replaceSysPropsInString(route.getFrom()));
            route.setTo(this.getTigerTestEnvMgr().replaceSysPropsInString(route.getTo()));
        });
        HashMap<String, Integer> properties = new HashMap<String, Integer>();
        properties.put("server.port", reverseProxyCfg.getServerPort());
        properties.putAll(TigerSerializationUtil.toMap((Object)standaloneCfg, (String[])new String[0]));
        this.applicationContext = new SpringApplicationBuilder(new Class[0]).properties(properties).sources(new Class[]{TigerProxyApplication.class}).web(WebApplicationType.SERVLET).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        this.waitForService(true);
        if (this.getStatus() == TigerServer.TigerServerStatus.STARTING) {
            this.waitForService(false);
        }
    }

    @Override
    public void shutdown() {
        if (this.applicationContext != null && this.applicationContext.isRunning()) {
            this.applicationContext.stop();
        }
    }

    private void getDestinationUrlFromProxiedServer(CfgTigerProxyOptions cfg) {
        String destUrl = this.getTigerTestEnvMgr().getServers().keySet().stream().filter(srvid -> srvid.equals(cfg.getProxiedServer())).findAny().map(srvid -> this.getTigerTestEnvMgr().getServers().get(srvid)).map(srv -> srv.getDestinationUrl(cfg.getProxiedServerProtocol())).orElseThrow(() -> new TigerTestEnvException("Proxied server '" + cfg.getProxiedServer() + "' not found in list!"));
        TigerRoute tigerRoute = new TigerRoute();
        tigerRoute.setFrom("/");
        tigerRoute.setTo(destUrl);
        cfg.getProxyCfg().getProxyRoutes().add(tigerRoute);
    }

    @Override
    String getHealthcheckUrl() {
        return "http://127.0.0.1:" + this.getConfiguration().getTigerProxyCfg().getServerPort();
    }

    @Override
    boolean isHealthCheckNone() {
        return false;
    }
}

