/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import java.net.MalformedURLException;
import java.net.URL;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalUrlServer
extends AbstractExternalTigerServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalUrlServer.class);

    ExternalUrlServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(ExternalUrlServer.determineHostname(configuration, serverId), serverId, configuration, tigerTestEnvMgr);
    }

    @Override
    public void performStartup() {
        log.info(Ansi.colorize((String)"starting external URL instance {}...", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD), (Object)this.getHostname());
        URL url = this.buildUrl();
        this.addServerToLocalProxyRouteMap(url);
        log.info("  Waiting 50% of start up time for external URL instance  {} to come up ...", (Object)this.getHostname());
        this.waitForService(true);
        if (this.getStatus() == TigerServer.TigerServerStatus.STARTING) {
            this.waitForService(false);
        }
    }

    @Override
    public void shutdown() {
        this.removeAllRoutes();
    }

    @Override
    String getHealthcheckUrl() {
        if (this.getConfiguration().getExternalJarOptions() == null || StringUtils.isEmpty((CharSequence)this.getConfiguration().getExternalJarOptions().getHealthcheck())) {
            return (String)this.getConfiguration().getSource().get(0);
        }
        return this.getConfiguration().getExternalJarOptions().getHealthcheck();
    }

    private URL buildUrl() {
        try {
            return new URL(this.getTigerTestEnvMgr().replaceSysPropsInString((String)this.getConfiguration().getSource().get(0)));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not parse source URL '" + (String)this.getConfiguration().getSource().get(0) + "'!", e);
        }
    }

    @Generated
    public static ExternalUrlServerBuilder builder() {
        return new ExternalUrlServerBuilder();
    }

    @Generated
    public static class ExternalUrlServerBuilder {
        @Generated
        private String serverId;
        @Generated
        private CfgServer configuration;
        @Generated
        private TigerTestEnvMgr tigerTestEnvMgr;

        @Generated
        ExternalUrlServerBuilder() {
        }

        @Generated
        public ExternalUrlServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public ExternalUrlServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public ExternalUrlServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        @Generated
        public ExternalUrlServer build() {
            return new ExternalUrlServer(this.serverId, this.configuration, this.tigerTestEnvMgr);
        }

        @Generated
        public String toString() {
            return "ExternalUrlServer.ExternalUrlServerBuilder(serverId=" + this.serverId + ", configuration=" + this.configuration + ", tigerTestEnvMgr=" + this.tigerTestEnvMgr + ")";
        }
    }
}

