/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.data.config.CfgExternalJarOptions;
import de.gematik.test.tiger.testenvmgr.DownloadManager;
import de.gematik.test.tiger.testenvmgr.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.AbstractExternalTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalJarServer
extends AbstractExternalTigerServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExternalJarServer.class);
    private final AtomicReference<Process> processReference = new AtomicReference();
    private File jarFile;
    private LocalDateTime processStartTime;

    ExternalJarServer(String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(ExternalJarServer.determineHostname(configuration, serverId), serverId, configuration, tigerTestEnvMgr);
    }

    @Override
    public void performStartup() {
        CfgExternalJarOptions externalJarOptions = this.getConfiguration().getExternalJarOptions();
        String workingDir = externalJarOptions.getWorkingDir();
        log.info(Ansi.colorize((String)"starting external jar instance {} in folder {}...", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD), (Object)this.getHostname(), (Object)workingDir);
        log.info("preparing check for external jar location...");
        String jarUrl = (String)this.getConfiguration().getSource().get(0);
        if (jarUrl.startsWith("local:")) {
            String jarName = jarUrl.substring(jarUrl.lastIndexOf("/") + 1);
            this.jarFile = Paths.get(externalJarOptions.getWorkingDir(), jarName).toFile();
            if (!this.jarFile.exists()) {
                throw new TigerTestEnvException("Local jar " + this.jarFile.getAbsolutePath() + " not found!");
            }
        } else {
            this.jarFile = DownloadManager.downloadJarAndReturnFile(externalJarOptions, jarUrl, this.getHostname());
        }
        log.info("creating cmd line...");
        List options = externalJarOptions.getOptions().stream().map(this.getTigerTestEnvMgr()::replaceSysPropsInString).collect(Collectors.toList());
        String javaExe = this.findJavaExecutable();
        options.add(0, javaExe);
        options.add("-jar");
        options.add(this.jarFile.getName());
        options.addAll(externalJarOptions.getArguments());
        log.info("executing '" + String.join((CharSequence)" ", options));
        log.info("in working dir: " + new File(externalJarOptions.getWorkingDir()).getAbsolutePath());
        Runtime.getRuntime().addShutdownHook(new Thread(this::stopExternalProcess));
        AtomicReference exception = new AtomicReference();
        this.processStartTime = LocalDateTime.now();
        this.getTigerTestEnvMgr().getExecutor().submit(() -> {
            try {
                this.processReference.set(new ProcessBuilder(new String[0]).command((String[])options.toArray(String[]::new)).directory(new File(externalJarOptions.getWorkingDir())).inheritIO().start());
                log.info("New process started (pid={})", (Object)this.processReference.get().pid());
            }
            catch (Throwable t) {
                log.error("Failed to start process", t);
                exception.set(t);
            }
            log.debug("Proc set in atomic var {}", (Object)this.processReference.get());
        });
        if (this.isHealthCheckNone()) {
            log.warn("Healthcheck is not configured, so unable to add route to local proxy!");
        } else {
            this.addServerToLocalProxyRouteMap(this.buildHealthcheckUrl());
        }
        if (exception.get() != null) {
            throw new TigerTestEnvException("Unable to start external jar '" + this.getHostname() + "'!", (Throwable)exception.get());
        }
        this.waitForService(true);
        if (exception.get() != null) {
            throw new TigerTestEnvException("Unable to start external jar '" + this.getHostname() + "'!", (Throwable)exception.get());
        }
        if (this.getStatus() == TigerServer.TigerServerStatus.STOPPED) {
            throw new TigerEnvironmentStartupException("Unable to start external jar '" + this.getHostname() + "'!");
        }
        if (this.getStatus() == TigerServer.TigerServerStatus.STARTING) {
            this.waitForService(false);
            if (exception.get() != null) {
                throw new TigerTestEnvException("Unable to start external jar '" + this.getHostname() + "'!", (Throwable)exception.get());
            }
            throw new TigerTestEnvException("Unable to start external jar '" + this.getHostname() + "'!");
        }
    }

    @Override
    public TigerServer.TigerServerStatus updateStatus(boolean quiet) {
        if (!this.processReference.get().isAlive()) {
            log.warn("Process {} is stopped!", (Object)this.processReference.get().pid());
            this.setStatus(TigerServer.TigerServerStatus.STOPPED);
            if (LocalDateTime.now().isBefore(this.processStartTime.plusSeconds(3L))) {
                log.warn("{}: Unusually short process run time ({})! Suspecting defunct jar! (Exitcode={})", new Object[]{this.getHostname(), Duration.between(LocalDateTime.now(), this.processStartTime), this.processReference.get().exitValue()});
                this.cleanupDefunctJar();
            }
            return this.getStatus();
        }
        return super.updateStatus(quiet);
    }

    private void cleanupDefunctJar() {
        if (!((String)this.getConfiguration().getSource().get(0)).startsWith("local:") && this.jarFile.exists() && !this.jarFile.delete()) {
            log.warn("Unable to delete jar file {}", (Object)this.jarFile.getAbsolutePath());
        }
    }

    @Override
    public void shutdown() {
        log.info("Stopping external jar {}...", (Object)this.getHostname());
        this.removeAllRoutes();
        this.stopExternalProcess();
    }

    private void stopExternalProcess() {
        if (this.processReference.get() != null) {
            log.info("Stopping external process (pid={})", (Object)this.processReference.get().pid());
            log.info("interrupting threads...");
            this.processReference.get().destroy();
            log.info("stopping threads...");
            this.processReference.get().destroyForcibly();
        } else {
            log.warn("Process for server {} not found... No need to shutdown", (Object)this.getHostname());
        }
    }

    private String findJavaExecutable() {
        String[] paths = System.getenv("PATH").split(SystemUtils.IS_OS_WINDOWS ? ";" : ":");
        String javaProg = "java" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        return Arrays.stream(paths).map(path -> Path.of(path, javaProg).toFile()).filter(file -> file.exists() && file.canExecute()).map(File::getAbsolutePath).findAny().orElseThrow(() -> new TigerTestEnvException("Unable to find executable java program in PATH"));
    }

    @Generated
    public static ExternalJarServerBuilder builder() {
        return new ExternalJarServerBuilder();
    }

    @Generated
    public static class ExternalJarServerBuilder {
        @Generated
        private String serverId;
        @Generated
        private CfgServer configuration;
        @Generated
        private TigerTestEnvMgr tigerTestEnvMgr;

        @Generated
        ExternalJarServerBuilder() {
        }

        @Generated
        public ExternalJarServerBuilder serverId(String serverId) {
            this.serverId = serverId;
            return this;
        }

        @Generated
        public ExternalJarServerBuilder configuration(CfgServer configuration) {
            this.configuration = configuration;
            return this;
        }

        @Generated
        public ExternalJarServerBuilder tigerTestEnvMgr(TigerTestEnvMgr tigerTestEnvMgr) {
            this.tigerTestEnvMgr = tigerTestEnvMgr;
            return this;
        }

        @Generated
        public ExternalJarServer build() {
            return new ExternalJarServer(this.serverId, this.configuration, this.tigerTestEnvMgr);
        }

        @Generated
        public String toString() {
            return "ExternalJarServer.ExternalJarServerBuilder(serverId=" + this.serverId + ", configuration=" + this.configuration + ", tigerTestEnvMgr=" + this.tigerTestEnvMgr + ")";
        }
    }
}

