/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr.servers;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.testenvmgr.InsecureTrustAllManager;
import de.gematik.test.tiger.testenvmgr.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URIBuilder;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExternalTigerServer
extends TigerServer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractExternalTigerServer.class);

    AbstractExternalTigerServer(String hostname, String serverId, CfgServer configuration, TigerTestEnvMgr tigerTestEnvMgr) {
        super(hostname, serverId, tigerTestEnvMgr, configuration);
    }

    void waitForService(boolean quiet) {
        block5: {
            long timeOutInMs = (long)this.getStartupTimeoutSec().orElse(20).intValue() * 1000L;
            if (this.isHealthCheckNone()) {
                this.waitForConfiguredTimeAndSetRunning(timeOutInMs);
            } else {
                if (!quiet) {
                    log.info("  Checking {} instance '{}' is available ...", (Object)this.getClass().getSimpleName(), (Object)this.getHostname());
                }
                try {
                    Awaitility.await().atMost(Math.max(timeOutInMs, 1000L), TimeUnit.MILLISECONDS).pollInterval(750L, TimeUnit.MILLISECONDS).until(() -> this.updateStatus(quiet) != TigerServer.TigerServerStatus.STARTING);
                }
                catch (ConditionTimeoutException cte) {
                    if (quiet) break block5;
                    throw new TigerTestEnvException("Timeout waiting for external server to respond at '" + this.getConfiguration().getExternalJarOptions().getHealthcheck() + "'!");
                }
            }
        }
    }

    public TigerServer.TigerServerStatus updateStatus(boolean quiet) {
        block10: {
            URL url = this.buildHealthcheckUrl();
            try {
                URLConnection con = url.openConnection();
                InsecureTrustAllManager.allowAllSsl(con);
                con.setConnectTimeout(1000);
                con.connect();
                this.printServerUpMessage();
                this.setStatus(TigerServer.TigerServerStatus.RUNNING);
            }
            catch (ConnectException | SocketTimeoutException cex) {
                if (!quiet) {
                    log.info("No connection to " + url + " of " + this.getHostname() + "...");
                }
            }
            catch (SSLHandshakeException sslhe) {
                log.warn(Ansi.colorize((String)("SSL handshake but server at least seems to be up!" + sslhe.getMessage()), (RbelAnsiColors)RbelAnsiColors.YELLOW_BOLD));
                this.setStatus(TigerServer.TigerServerStatus.RUNNING);
            }
            catch (SSLException sslex) {
                if (sslex.getMessage().equals("Unsupported or unrecognized SSL message")) {
                    if (!quiet) {
                        log.error("Unsupported or unrecognized SSL message - MAYBE you mismatched http/httpS?");
                    }
                } else if (!quiet) {
                    log.error("SSL Error - " + sslex.getMessage(), (Throwable)sslex);
                }
            }
            catch (Exception e) {
                if (quiet) break block10;
                log.error("Failed to connect - " + e.getMessage(), (Throwable)e);
            }
        }
        return this.getStatus();
    }

    void printServerUpMessage() {
        String message = "External server Startup OK for '" + this.getHostname();
        if (this.getConfiguration().getSource() != null && !this.getConfiguration().getSource().isEmpty()) {
            message = message + "downloaded from" + (String)this.getConfiguration().getSource().get(0);
        }
        log.info(Ansi.colorize((String)message, (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
    }

    private void waitForConfiguredTimeAndSetRunning(long timeOutInMs) {
        log.warn("No health check URL configured! Resorting to simple wait with timeout {}s", (Object)(timeOutInMs / 1000L));
        log.info("Waiting {}s for external server {}...", (Object)(timeOutInMs / 1000L), (Object)this.getHostname());
        try {
            Thread.sleep(timeOutInMs);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        this.setStatus(TigerServer.TigerServerStatus.RUNNING);
    }

    URL buildHealthcheckUrl() {
        try {
            return new URL(this.getHealthcheckUrl());
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Could not build healthcheck URL from '" + this.getConfiguration().getExternalJarOptions().getHealthcheck() + "'!", e);
        }
    }

    String getHealthcheckUrl() {
        return this.getConfiguration().getExternalJarOptions().getHealthcheck();
    }

    @Override
    public String getDestinationUrl(String fallbackProtocol) {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.getHealthcheckUrl()).setPath("");
            if (StringUtils.isNotEmpty((CharSequence)fallbackProtocol)) {
                uriBuilder.setScheme(fallbackProtocol);
            }
            return uriBuilder.build().toURL().toString();
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new TigerEnvironmentStartupException("Unable to build destination URL", e);
        }
    }

    boolean isHealthCheckNone() {
        return this.getConfiguration().getExternalJarOptions() == null || this.getConfiguration().getExternalJarOptions().getHealthcheck() == null || this.getConfiguration().getExternalJarOptions().getHealthcheck().isEmpty() || this.getConfiguration().getExternalJarOptions().getHealthcheck().equals("NONE");
    }
}

