/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.pki.TigerConfigurationPkiIdentity;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.testenvmgr.DockerMgr;
import de.gematik.test.tiger.testenvmgr.ITigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import de.gematik.test.tiger.testenvmgr.servers.TigerServer;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerTestEnvMgr
implements ITigerTestEnvMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestEnvMgr.class);
    public static final String HTTP = "http://";
    public static final String HTTPS = "https://";
    private static final String TIGER_TESTENV_YAML_FILENAME = "tiger-testenv.yaml";
    private final Configuration configuration;
    private final DockerMgr dockerManager;
    private final Map<String, Object> environmentVariables;
    private final TigerProxy localTigerProxy;
    private final List<TigerRoute> routesList = new ArrayList<TigerRoute>();
    private final Map<String, TigerServer> servers = new HashMap<String, TigerServer>();
    private final ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors() * 2);

    public TigerTestEnvMgr() {
        TigerProxyConfiguration proxyConfig;
        Configuration configuration = TigerTestEnvMgr.readConfiguration();
        this.dockerManager = new DockerMgr();
        if (configuration.getTigerProxy() == null) {
            configuration.setTigerProxy(TigerProxyConfiguration.builder().build());
        }
        if ((proxyConfig = configuration.getTigerProxy()).getProxyRoutes() == null) {
            proxyConfig.setProxyRoutes(List.of());
        }
        if (proxyConfig.getTls().getServerRootCa() == null) {
            proxyConfig.getTls().setServerRootCa(new TigerConfigurationPkiIdentity("CertificateAuthorityCertificate.pem;PKCS8CertificateAuthorityPrivateKey.pem;PKCS8"));
        }
        this.localTigerProxy = new TigerProxy(configuration.getTigerProxy());
        if (configuration.isLocalProxyActive()) {
            log.info("Started local docker tiger proxy on port " + this.localTigerProxy.getPort() + "...");
            this.environmentVariables = new HashMap<String, Integer>(Map.of("PROXYHOST", "host.docker.internal", "PROXYPORT", this.localTigerProxy.getPort()));
        } else {
            log.info("Local docker tiger proxy deactivated");
            this.environmentVariables = new HashMap<String, Object>();
        }
        this.configuration = configuration;
        this.createServerObjects();
        log.info("Tiger Testenv mgr created OK");
    }

    public static void main(String[] args) {
        TigerTestEnvMgr envMgr = new TigerTestEnvMgr();
        try {
            envMgr.setUpEnvironment();
        }
        catch (Exception e) {
            log.error("Error while starting up stand alone tiger testenv mgr! ABORTING...", (Throwable)e);
            System.exit(1);
        }
        log.info(Ansi.colorize((String)"Tiger standalone test environment UP!", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
        TigerTestEnvMgr.waitForQuit("TIGER standalone test environment");
        envMgr.shutDown();
        System.exit(0);
    }

    public static void waitForQuit(String appName) {
        Console c = System.console();
        if (c != null) {
            c.format("\n\n\nPress 'quit' and ENTER to stop " + appName + ".\n\n\n\n\n", new Object[0]);
            String cmd = "";
            while (!cmd.equals("quit")) {
                cmd = c.readLine();
            }
            log.info("Stopping " + appName + "...");
        } else {
            log.warn("No Console interface found, trying System in stream...");
            log.info("\n\n\nPress 'quit' and ENTER to stop " + appName + ".\n\n\n\n\n");
            try {
                BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
                String cmd = "";
                while (!cmd.equals("quit")) {
                    cmd = rdr.readLine();
                }
            }
            catch (IOException e) {
                log.warn("Unable to open input stream from console! Running " + appName + " for max. 24 hours.You will have to use Ctrl+C and eventually clean up the processes manually!");
                Awaitility.await().atMost(24L, TimeUnit.HOURS).pollDelay(1L, TimeUnit.SECONDS).until(() -> false);
            }
        }
    }

    private static void readTemplates() {
        try {
            URL templatesUrl = TigerTestEnvMgr.class.getResource("templates.yaml");
            String templatesYaml = IOUtils.toString((URI)Objects.requireNonNull(templatesUrl).toURI(), (Charset)StandardCharsets.UTF_8);
            TigerGlobalConfiguration.readTemplates((String)templatesYaml, (String[])new String[]{"tiger", "servers"});
        }
        catch (IOException | URISyntaxException e) {
            throw new TigerConfigurationException("Unable to read templates YAML!", (Throwable)e);
        }
    }

    private static String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress().getHostName();
        }
    }

    private static Configuration readConfiguration() {
        TigerGlobalConfiguration.initialize();
        TigerTestEnvMgr.readTemplates();
        TigerTestEnvMgr.readTestenvYaml();
        Configuration configuration = (Configuration)TigerGlobalConfiguration.instantiateConfigurationBean(Configuration.class, (String[])new String[]{"tiger"});
        for (CfgServer cfgServer : configuration.getServers().values()) {
            if (!StringUtils.isNotEmpty((CharSequence)cfgServer.getTemplate())) continue;
            throw new TigerConfigurationException("Could not resolve template '" + cfgServer.getTemplate() + "'");
        }
        return configuration;
    }

    private static void readTestenvYaml() {
        String configFileLocation = TigerGlobalConfiguration.readString((String)"TIGER_TESTENV_CFGFILE", (String)("tiger-testenv-" + TigerTestEnvMgr.getComputerName() + ".yaml"));
        File cfgFile = new File(configFileLocation);
        if (!cfgFile.exists()) {
            log.warn("Unable to read configuration from {}", (Object)cfgFile.getAbsolutePath());
            cfgFile = new File(TIGER_TESTENV_YAML_FILENAME);
            if (!cfgFile.exists() && TigerGlobalConfiguration.listSources().stream().noneMatch(src -> src.getSourceType() == SourceType.YAML)) {
                throw new TigerEnvironmentStartupException("Could not find configuration-file '" + configFileLocation + "' or 'tiger-testenv.yaml' fallback");
            }
        }
        if (cfgFile.exists()) {
            log.info("Reading configuration from {}...", (Object)cfgFile.getAbsolutePath());
            try {
                TigerGlobalConfiguration.readFromYaml((String)FileUtils.readFileToString((File)cfgFile, (Charset)StandardCharsets.UTF_8), (String[])new String[]{"tiger"});
            }
            catch (Exception e) {
                throw new TigerEnvironmentStartupException("Error while reading configuration from file '" + cfgFile.getAbsolutePath() + "'", e);
            }
        }
    }

    private void assertNoCyclesInGraph() {
        this.servers.values().forEach(server -> this.cycleChecker((TigerServer)server, (Set<TigerServer>)new HashSet<TigerServer>()));
    }

    private void cycleChecker(TigerServer currentPosition, Set<TigerServer> visitedServer) {
        if (visitedServer.contains(currentPosition)) {
            throw new TigerEnvironmentStartupException("Cyclic graph detected in startup sequence: " + visitedServer.stream().map(TigerServer::getServerId).collect(Collectors.toList()));
        }
        if (currentPosition.getDependUponList().isEmpty()) {
            System.out.println(visitedServer);
            return;
        }
        for (TigerServer server : currentPosition.getDependUponList()) {
            HashSet<TigerServer> newSet = new HashSet<TigerServer>(visitedServer);
            newSet.add(currentPosition);
            this.cycleChecker(server, newSet);
        }
    }

    private void createServerObjects() {
        for (Map.Entry<String, CfgServer> serverEntry : this.configuration.getServers().entrySet()) {
            if (!serverEntry.getValue().isActive()) continue;
            this.servers.put(serverEntry.getKey(), TigerServer.create(serverEntry.getKey(), serverEntry.getValue(), this));
        }
    }

    @Override
    public void setUpEnvironment() {
        this.assertNoCyclesInGraph();
        this.assertNoUnknownServersInDependencies();
        log.info("starting set up of test environment...");
        List initialServersToBoot = this.servers.values().parallelStream().filter(server -> server.getDependUponList().isEmpty()).collect(Collectors.toList());
        log.info("Starting setup by triggering boot of following server: {}", initialServersToBoot.stream().map(TigerServer::getHostname).collect(Collectors.toList()));
        initialServersToBoot.parallelStream().forEach(this::startServer);
        log.info(Ansi.colorize((String)"finished set up test environment OK", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
    }

    private void assertNoUnknownServersInDependencies() {
        this.getServers().values().stream().forEach(TigerServer::getDependUponList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startServer(TigerServer server) {
        TigerServer tigerServer = server;
        synchronized (tigerServer) {
            if (server.getStatus() != TigerServer.TigerServerStatus.NEW) {
                return;
            }
            server.start(this);
        }
        this.servers.values().parallelStream().peek(toBeStartedServer -> log.debug("Considering starting server {} with status {}...", (Object)toBeStartedServer.getHostname(), (Object)toBeStartedServer.getStatus())).filter(candidate -> candidate.getStatus() == TigerServer.TigerServerStatus.NEW).filter(candidate -> candidate.getDependUponList().stream().filter(depending -> depending.getStatus() != TigerServer.TigerServerStatus.RUNNING).findAny().isEmpty()).peek(toBeStartedServer -> log.info("About to start server {} with status {}", (Object)toBeStartedServer.getHostname(), (Object)toBeStartedServer.getStatus())).forEach(this::startServer);
    }

    public String replaceSysPropsInString(String str) {
        return str;
    }

    @Override
    public void shutDown() {
        log.info("Shutting down server all servers...");
        this.servers.values().stream().forEach(TigerServer::shutdown);
    }

    public List<TigerRoute> getRoutes() {
        return this.servers.values().stream().map(TigerServer::getRoutes).flatMap(Collection::stream).collect(Collectors.toUnmodifiableList());
    }

    public Optional<TigerServer> findServer(String serverName) {
        return Optional.ofNullable(this.servers.get(serverName));
    }

    public boolean isLocalTigerProxyActive() {
        if (this.configuration == null) {
            return true;
        }
        return this.configuration.isLocalProxyActive();
    }

    @Override
    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public DockerMgr getDockerManager() {
        return this.dockerManager;
    }

    @Generated
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Generated
    public TigerProxy getLocalTigerProxy() {
        return this.localTigerProxy;
    }

    @Generated
    public List<TigerRoute> getRoutesList() {
        return this.routesList;
    }

    @Generated
    public Map<String, TigerServer> getServers() {
        return this.servers;
    }

    @Generated
    public ExecutorService getExecutor() {
        return this.executor;
    }
}

