/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.OsEnvironment;
import de.gematik.test.tiger.common.TokenSubstituteHelper;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.CfgExternalJarOptions;
import de.gematik.test.tiger.common.config.CfgTigerProxyOptions;
import de.gematik.test.tiger.common.config.ServerType;
import de.gematik.test.tiger.common.config.TigerConfigurationHelper;
import de.gematik.test.tiger.common.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.pki.KeyMgr;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.testenvmgr.DockerMgr;
import de.gematik.test.tiger.testenvmgr.ITigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvException;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import de.gematik.test.tiger.testenvmgr.config.tigerProxyStandalone.CfgStandaloneProxy;
import de.gematik.test.tiger.testenvmgr.config.tigerProxyStandalone.CfgStandaloneServer;
import java.io.BufferedReader;
import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.json.JSONArray;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerTestEnvMgr
implements ITigerTestEnvMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerTestEnvMgr.class);
    private static final String HTTP = "http://";
    private static final String HTTPS = "https://";
    private static boolean SHUTDOWN_HOOK_ACTIVE = false;
    private final Configuration configuration;
    private final DockerMgr dockerManager;
    private final Map<String, Object> environmentVariables;
    private final TigerProxy localTigerProxy;
    private final List<TigerRoute> routesList = new ArrayList<TigerRoute>();
    private final Map<String, Process> externalProcesses = new HashMap<String, Process>();

    public static void main(String[] args) {
        TigerTestEnvMgr envMgr = new TigerTestEnvMgr();
        try {
            envMgr.setUpEnvironment();
        }
        catch (Exception e) {
            log.error("Error while starting up stand alone tiger testenv mgr! ABORTING...", (Throwable)e);
            System.exit(1);
        }
        log.info("\n" + Banner.toBannerStr((String)"Tiger standalone test environment UP!", (String)"\u001b[1m\u001b[32m"));
        TigerTestEnvMgr.waitForQuit(null, new Object[0]);
        log.info("interrupting " + envMgr.externalProcesses.size() + " threads...");
        envMgr.externalProcesses.values().forEach(Process::destroy);
        log.info("stopping threads...");
        envMgr.externalProcesses.values().forEach(Process::destroyForcibly);
        envMgr.externalProcesses.clear();
        System.exit(0);
    }

    public static void waitForQuit(String message, Object ... args) {
        Console c = System.console();
        if (c != null) {
            if (message != null) {
                c.format(message, args);
            }
            c.format("\n\n\nPress 'quit' and ENTER to stop TIGER standalone test environment.\n\n\n\n\n", new Object[0]);
            String cmd = "";
            while (!cmd.equals("quit")) {
                cmd = c.readLine();
            }
            log.info("Stopping TIGER standalone test environment...");
        } else {
            log.warn("No Console interface found, trying System in stream...");
            log.info("\n\n\nPress 'quit' and ENTER to stop TIGER standalone test environment.\n\n\n\n\n");
            try {
                BufferedReader rdr = new BufferedReader(new InputStreamReader(System.in));
                String cmd = "";
                while (!cmd.equals("quit")) {
                    cmd = rdr.readLine();
                }
            }
            catch (IOException e) {
                log.warn("Unable to open input stream from console! You will have to use Ctrl+C and clean up the processes manually!");
                try {
                    while (true) {
                        Thread.sleep(1000L);
                    }
                }
                catch (InterruptedException ie) {
                    return;
                }
            }
        }
    }

    public TigerTestEnvMgr() {
        TigerProxyConfiguration proxyConfig;
        File cfgFile = new File(OsEnvironment.getAsString((String)"TIGER_TESTENV_CFGFILE", (String)("tiger-testenv-" + this.getComputerName() + ".yaml")));
        if (!cfgFile.exists()) {
            log.warn("Unable to read configuration from " + cfgFile.getAbsolutePath());
            cfgFile = new File("tiger-testenv.yaml");
        }
        log.info("Reading configuration from " + cfgFile.getAbsolutePath() + "...");
        JSONObject jsonCfg = TigerConfigurationHelper.yamlToJson((String)cfgFile.getAbsolutePath());
        JSONObject jsonTemplate = TigerConfigurationHelper.yamlStringToJson((String)IOUtils.toString((URI)Objects.requireNonNull(this.getClass().getResource("templates.yaml")).toURI(), (Charset)StandardCharsets.UTF_8));
        TigerConfigurationHelper.applyTemplate((JSONArray)jsonCfg.getJSONArray("servers"), (String)"template", (JSONArray)jsonTemplate.getJSONArray("templates"), (String)"name");
        TigerConfigurationHelper.overwriteWithSysPropsAndEnvVars((String)"TIGER_TESTENV", (String)"tiger.testenv", (JSONObject)jsonCfg);
        this.configuration = (Configuration)new TigerConfigurationHelper().jsonStringToConfig(jsonCfg.toString(), Configuration.class);
        this.dockerManager = new DockerMgr();
        if (this.configuration.getTigerProxy() == null) {
            this.configuration.setTigerProxy(TigerProxyConfiguration.builder().build());
        }
        if ((proxyConfig = this.configuration.getTigerProxy()).getProxyRoutes() == null) {
            proxyConfig.setProxyRoutes(List.of());
        }
        if (proxyConfig.getServerRootCa() == null) {
            proxyConfig.setServerRootCa(new TigerPkiIdentity("CertificateAuthorityCertificate.pem;PKCS8CertificateAuthorityPrivateKey.pem;PKCS8"));
        }
        log.info("Starting local docker tiger proxy...");
        this.localTigerProxy = new TigerProxy(this.configuration.getTigerProxy());
        this.environmentVariables = this.configuration.isLocalProxyActive() ? new HashMap<String, Integer>(Map.of("PROXYHOST", "host.docker.internal", "PROXYPORT", this.localTigerProxy.getPort())) : new HashMap<String, Object>();
        log.info("Tiger Testenv mgr created OK");
    }

    @Override
    public void setUpEnvironment() {
        log.info("starting set up of test environment...");
        this.configuration.getServers().forEach(server -> this.start((CfgServer)((Object)server), this.configuration));
        log.info(Ansi.colorize((String)"finished set up test environment OK", (String)"\u001b[1m\u001b[32m"));
    }

    @Override
    public List<CfgServer> getTestEnvironment() {
        return this.configuration.getServers();
    }

    @Override
    public void start(CfgServer server, Configuration configuration) throws RuntimeException {
        if (!server.isActive()) {
            log.warn("skipping inactive server " + server.getName());
            return;
        }
        this.checkCfgProperties(server);
        ServerType type = server.getType();
        if (configuration.isLocalProxyActive()) {
            this.environmentVariables.put("PROXYPORT", this.localTigerProxy.getPort());
            this.environmentVariables.put("PROXYHOST", type == ServerType.DOCKER ? "host.docker.internel" : "127.0.0.1");
        }
        if (server.getEnvironment() != null) {
            server.setEnvironment(server.getEnvironment().stream().map(this::replaceSysPropsInString).collect(Collectors.toList()));
        }
        if (server.getUrlMappings() != null) {
            server.getUrlMappings().forEach(mapping -> {
                String[] kvp = mapping.split(" --> ", 2);
                this.localTigerProxy.addRoute(TigerRoute.builder().from(kvp[0]).to(kvp[1]).build());
            });
        }
        try {
            switch (type) {
                case DOCKER: 
                case DOCKER_COMPOSE: {
                    this.startDocker(server, configuration);
                    break;
                }
                case EXTERNALURL: {
                    this.initializeExternalUrl(server);
                    break;
                }
                case TIGERPROXY: {
                    this.initializeTigerProxy(server, configuration);
                    break;
                }
                case EXTERNALJAR: {
                    this.initializeExternalJar(server);
                    break;
                }
                default: {
                    throw new TigerTestEnvException(String.format("Unsupported server type %s found in server %s", type, server.getName()));
                }
            }
        }
        catch (IOException | InterruptedException | URISyntaxException use) {
            throw new TigerTestEnvException("Failed to start server " + server.getName(), use);
        }
        server.setStarted(true);
        this.loadPKIForProxy(server);
        server.getExports().forEach(exp -> {
            String[] kvp = exp.split("=", 2);
            if (type == ServerType.DOCKER && server.getDockerOptions().getPorts() != null) {
                server.getDockerOptions().getPorts().forEach((localPort, externPort) -> {
                    kvp[1] = kvp[1].replace("${PORT:" + localPort + "}", String.valueOf(externPort));
                });
            }
            kvp[1] = kvp[1].replace("${NAME}", server.getName());
            log.info("  setting system property " + kvp[0] + "=" + kvp[1]);
            System.setProperty(kvp[0], kvp[1]);
            this.environmentVariables.put(kvp[0], kvp[1]);
        });
    }

    public void checkCfgProperties(CfgServer server) {
        ServerType type = server.getType();
        this.assertCfgPropertySet((Object)server, "name");
        this.assertCfgPropertySet((Object)server, "type");
        if (type != ServerType.EXTERNALJAR && type != ServerType.EXTERNALURL && type != ServerType.DOCKER_COMPOSE) {
            this.assertCfgPropertySet((Object)server, "version");
        }
        if (server.getType() == ServerType.TIGERPROXY && (server.getSource() == null || server.getSource().isEmpty())) {
            log.info("Defaulting tiger proxy source to gematik nexus for " + server.getName());
            server.setSource(new ArrayList<String>(List.of("nexus")));
        }
        if (server.getType() == ServerType.TIGERPROXY && server.getExternalJarOptions() == null) {
            server.setExternalJarOptions(new CfgExternalJarOptions());
        }
        if (server.getType() == ServerType.TIGERPROXY && server.getExternalJarOptions().getHealthcheck() == null) {
            server.getExternalJarOptions().setHealthcheck("http://127.0.0.1:" + server.getTigerProxyCfg().getServerPort());
        }
        if (server.getStartupTimeoutSec() == null) {
            log.info("Defaulting startup timeout sec to 20sec for server " + server.getName());
            server.setStartupTimeoutSec(20);
        }
        if (type == ServerType.EXTERNALJAR || type == ServerType.TIGERPROXY) {
            File f;
            String folder = server.getExternalJarOptions().getWorkingDir();
            if (folder == null) {
                folder = Path.of(System.getProperty("java.io.tmpdir"), "tiger_downloads").toFile().getAbsolutePath();
                log.info("Defaulting to temp folder '" + folder + "' as work dir for server " + server.getName());
                server.getExternalJarOptions().setWorkingDir(folder);
            }
            if (!(f = new File(folder)).exists() && !f.mkdirs()) {
                throw new TigerTestEnvException("Unable to create working dir folder " + f.getAbsolutePath());
            }
        }
        if (type != ServerType.TIGERPROXY) {
            this.assertCfgPropertySet((Object)server, "source");
        }
        if (type == ServerType.EXTERNALJAR) {
            this.assertCfgPropertySet(server.getExternalJarOptions(), "healthcheck");
        }
        if (type == ServerType.TIGERPROXY && server.getTigerProxyCfg().getServerPort() < 1) {
            throw new TigerTestEnvException("Server port for Tiger Proxy must be explicitly set!");
        }
    }

    private void assertCfgPropertySet(Object srv, String propName) {
        Method mthd = srv.getClass().getMethod("get" + Character.toUpperCase(propName.charAt(0)) + propName.substring(1), new Class[0]);
        Object value = mthd.invoke(srv, new Object[0]);
        if (value == null) {
            throw new TigerTestEnvException("Server " + propName + " must be set and must not be NULL!");
        }
        if (value instanceof List) {
            List l = (List)value;
            if (l.isEmpty() || l.get(0) == null) {
                throw new TigerTestEnvException("Server " + propName + " list must be set and must contain at least one not empty entry!");
            }
            if (l.get(0) instanceof String && ((String)l.get(0)).isBlank()) {
                throw new TigerTestEnvException("Server " + propName + " list must be set and must contain at least one not empty entry!");
            }
        } else if (value instanceof String && ((String)value).isBlank()) {
            throw new TigerTestEnvException("Server " + propName + " must be set and must not be empty!");
        }
    }

    private String getComputerName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return InetAddress.getLoopbackAddress().getHostName();
        }
    }

    private void startDocker(CfgServer server, Configuration configuration) {
        log.info(Ansi.colorize((String)("Starting docker container for " + server.getName() + ":" + (String)server.getSource().get(0)), (String)"\u001b[1m\u001b[32m"));
        if (server.getType() == ServerType.DOCKER) {
            this.dockerManager.startContainer(server, configuration, this);
        } else {
            this.dockerManager.startComposition(server);
        }
        if (server.getDockerOptions().getPorts() != null && !server.getDockerOptions().getPorts().isEmpty()) {
            this.routesList.add(TigerRoute.builder().from(HTTP + server.getName()).to("http://localhost:" + server.getDockerOptions().getPorts().values().iterator().next()).build());
            this.localTigerProxy.addRoute(TigerRoute.builder().from(HTTP + server.getName()).to("http://localhost:" + server.getDockerOptions().getPorts().values().iterator().next()).build());
        }
        log.info(Ansi.colorize((String)("Docker container Startup for " + server.getName() + " : " + (String)server.getSource().get(0) + " OK"), (String)"\u001b[1m\u001b[32m"));
    }

    private void initializeTigerProxy(CfgServer server, Configuration configuration) {
        CfgTigerProxyOptions reverseProxyCfg = server.getTigerProxyCfg();
        CfgStandaloneProxy standaloneCfg = new CfgStandaloneProxy();
        standaloneCfg.setServer(new CfgStandaloneServer());
        standaloneCfg.getServer().setPort(reverseProxyCfg.getServerPort());
        standaloneCfg.setTigerProxy(reverseProxyCfg.getProxyCfg());
        if (reverseProxyCfg.getProxyCfg().getProxyRoutes() == null) {
            reverseProxyCfg.getProxyCfg().setProxyRoutes(new ArrayList());
        }
        if (reverseProxyCfg.getProxiedServer() != null) {
            this.getDestinationUrlFromProxiedServer(server, configuration, reverseProxyCfg);
        }
        reverseProxyCfg.getProxyCfg().getProxyRoutes().forEach(route -> {
            route.setFrom(this.replaceSysPropsInString(route.getFrom()));
            route.setTo(this.replaceSysPropsInString(route.getTo()));
        });
        String jarFile = "tiger-standalone-proxy-" + server.getVersion() + ".jar";
        Object downloadUrl = ((String)server.getSource().get(0)).equals("nexus") ? "https://build.top.local/nexus/service/local/repositories/releases/content/de/gematik/test/tiger-standalone-proxy/" + server.getVersion() + "/" + jarFile : (((String)server.getSource().get(0)).equals("maven") ? "https://repo1.maven.org/maven2/de/gematik/test/tiger-standalone-proxy/" + server.getVersion() + "/" + jarFile : (String)server.getSource().get(0));
        File folder = new File(server.getExternalJarOptions().getWorkingDir());
        server.setSource(List.of(downloadUrl));
        if (server.getExternalJarOptions().getHealthcheck() == null) {
            server.getExternalJarOptions().setHealthcheck("http://127.0.0.1:" + reverseProxyCfg.getServerPort());
        }
        if (server.getExternalJarOptions().getArguments() == null) {
            server.getExternalJarOptions().setArguments(new ArrayList());
        }
        server.getExternalJarOptions().getArguments().add("--spring.profiles.active=" + server.getName());
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory());
        om.writeValue(Path.of(folder.getAbsolutePath(), "application-" + server.getName() + ".yaml").toFile(), (Object)standaloneCfg);
        this.initializeExternalJar(server);
    }

    public String replaceSysPropsInString(String str) {
        return TokenSubstituteHelper.substitute((String)str, (String)"", this.environmentVariables);
    }

    private void getDestinationUrlFromProxiedServer(CfgServer server, Configuration configuration, CfgTigerProxyOptions cfg) {
        Object destUrl;
        CfgServer proxiedServer = configuration.getServers().stream().filter(srv -> srv.getName().equals(cfg.getProxiedServer())).findAny().orElseThrow(() -> new TigerTestEnvException("Proxied server '" + cfg.getProxiedServer() + "' not found in list!"));
        switch (proxiedServer.getType()) {
            case DOCKER: {
                if (proxiedServer.getExternalJarOptions().getHealthcheck() == null) {
                    if (!proxiedServer.isStarted()) {
                        throw new TigerTestEnvException("If reverse proxy is to be used with docker container '" + proxiedServer.getName() + "' make sure to start it first or have a valid healthcheck setting!");
                    }
                    destUrl = cfg.getProxyProtocol() + "://127.0.0.1:" + server.getDockerOptions().getPorts().values().iterator().next();
                    break;
                }
                destUrl = proxiedServer.getExternalJarOptions().getHealthcheck();
                break;
            }
            case EXTERNALJAR: {
                ((AbstractStringAssert)Assertions.assertThat((String)proxiedServer.getExternalJarOptions().getHealthcheck()).withFailMessage("To be proxied server '" + proxiedServer.getName() + "' has no valid healthcheck Url", new Object[0])).isNotBlank();
                destUrl = proxiedServer.getExternalJarOptions().getHealthcheck();
                break;
            }
            case EXTERNALURL: {
                ((ListAssert)Assertions.assertThat((List)proxiedServer.getSource()).withFailMessage("To be proxied server '" + proxiedServer.getName() + "' has no sources configured", new Object[0])).isNotEmpty();
                ((AbstractStringAssert)Assertions.assertThat((String)((String)proxiedServer.getSource().get(0))).withFailMessage("To be proxied server '" + proxiedServer.getName() + "' has empty source[0] configured", new Object[0])).isNotBlank();
                destUrl = (String)proxiedServer.getSource().get(0);
                break;
            }
            default: {
                throw new TigerTestEnvException("Sophisticated reverse proxy for '" + proxiedServer.getType() + "' is not supported!");
            }
        }
        TigerRoute tigerRoute = new TigerRoute();
        tigerRoute.setFrom("/");
        tigerRoute.setTo((String)destUrl);
        cfg.getProxyCfg().getProxyRoutes().add(tigerRoute);
    }

    public void initializeExternalUrl(CfgServer server) {
        log.info(Ansi.colorize((String)("starting external URL instance " + server.getName() + "..."), (String)"\u001b[1m\u001b[32m"));
        URL url = new URL(this.replaceSysPropsInString((String)server.getSource().get(0)));
        this.addServerToLocalProxyRouteMap(server, url);
        log.info("  Waiting 50% of start up time for external URL instance  " + server.getName() + " to come up ...");
        if (this.waitForService(server, (long)server.getStartupTimeoutSec().intValue() * 500L, true)) {
            return;
        }
        this.waitForService(server, (long)server.getStartupTimeoutSec().intValue() * 500L, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeExternalJar(CfgServer server) throws RuntimeException, InterruptedException, IOException, URISyntaxException {
        log.info(Ansi.colorize((String)("starting external jar instance " + server.getName() + " in folder " + server.getExternalJarOptions().getWorkingDir() + "..."), (String)"\u001b[1m\u001b[32m"));
        log.info("preparing check for external jar location...");
        String jarUrl = (String)server.getSource().get(0);
        String jarName = jarUrl.substring(jarUrl.lastIndexOf("/") + 1);
        File jarFile = Paths.get(server.getExternalJarOptions().getWorkingDir(), jarName).toFile();
        log.info("checking external jar location: " + jarUrl + "," + jarName + "," + jarFile.getAbsolutePath());
        if (!jarFile.exists()) {
            if (jarUrl.startsWith("local:")) {
                throw new TigerTestEnvException("Local jar " + jarFile.getAbsolutePath() + " not found!");
            }
            this.downloadJar(server, jarUrl, jarFile);
        }
        log.info("creating cmd line...");
        List options = server.getExternalJarOptions().getOptions().stream().map(this::replaceSysPropsInString).collect(Collectors.toList());
        String javaExe = this.findJavaExecutable();
        options.add(0, javaExe);
        options.add("-jar");
        options.add(jarName);
        options.addAll(server.getExternalJarOptions().getArguments());
        log.info("executing '" + String.join((CharSequence)" ", options));
        log.info("in working dir: " + new File(server.getExternalJarOptions().getWorkingDir()).getAbsolutePath());
        AtomicReference proc = new AtomicReference();
        TigerTestEnvException throwing = null;
        try {
            AtomicReference exception = new AtomicReference();
            Thread thread = new Thread(() -> {
                Process p = null;
                try {
                    p = new ProcessBuilder(new String[0]).command((String[])options.toArray(String[]::new)).directory(new File(server.getExternalJarOptions().getWorkingDir())).inheritIO().start();
                }
                catch (Throwable t) {
                    log.error("Failed to start process", t);
                    exception.set(t);
                }
                this.externalProcesses.put(server.getName(), p);
                proc.set(p);
                log.info("Proc set in atomic var " + p);
            });
            thread.setName(server.getName());
            thread.start();
            if (!SHUTDOWN_HOOK_ACTIVE) {
                Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                    if (!this.externalProcesses.isEmpty()) {
                        log.info("interrupting threads...");
                        this.externalProcesses.values().forEach(Process::destroy);
                        log.info("stopping threads...");
                        this.externalProcesses.values().forEach(Process::destroyForcibly);
                    }
                }));
                SHUTDOWN_HOOK_ACTIVE = true;
            }
            if (server.getExternalJarOptions().getHealthcheck().equals("NONE")) {
                log.warn("Healthcheck is configured as NONE, so unable to add route to local proxy!");
            } else {
                URL url = new URL(server.getExternalJarOptions().getHealthcheck());
                this.addServerToLocalProxyRouteMap(server, url);
            }
            if (exception.get() != null) {
                throwing = new TigerTestEnvException("Unable to start external jar!", (Throwable)exception.get());
            }
            if (this.waitForService(server, (long)server.getStartupTimeoutSec().intValue() * 500L, true)) {
                if (exception.get() != null) {
                    throwing = new TigerTestEnvException("Unable to start external jar!", (Throwable)exception.get());
                }
            } else {
                if (exception.get() != null) {
                    throwing = new TigerTestEnvException("Unable to start external jar!", (Throwable)exception.get());
                }
                this.waitForService(server, (long)server.getStartupTimeoutSec().intValue() * 500L, false);
                if (exception.get() != null) {
                    throwing = new TigerTestEnvException("Unable to start external jar!", (Throwable)exception.get());
                }
            }
        }
        finally {
            log.info("proc: " + proc.get());
            if (proc.get() != null) {
                if (((Process)proc.get()).isAlive()) {
                    log.info("Started " + server.getName());
                } else if (((Process)proc.get()).exitValue() == 0) {
                    log.info("Process exited already " + server.getName());
                } else {
                    log.info("Unclear process state" + proc);
                    log.info("Output from cmd: " + IOUtils.toString((InputStream)((Process)proc.get()).getInputStream(), (Charset)StandardCharsets.UTF_8));
                }
            } else {
                throwing = throwing == null ? new TigerTestEnvException("External Jar startup failed") : new TigerTestEnvException("External Jar startup failed", throwing);
            }
        }
        if (throwing != null) {
            throw throwing;
        }
    }

    private void addServerToLocalProxyRouteMap(CfgServer server, URL url) throws URISyntaxException {
        int port = url.getPort();
        if (port == -1) {
            port = url.getDefaultPort();
        }
        this.localTigerProxy.addRoute(TigerRoute.builder().from(HTTP + server.getName()).to(url.toURI().getScheme() + "://" + url.getHost() + ":" + port).build());
    }

    private String findJavaExecutable() {
        String[] paths = System.getenv("PATH").split(SystemUtils.IS_OS_WINDOWS ? ";" : ":");
        String javaProg = "java" + (SystemUtils.IS_OS_WINDOWS ? ".exe" : "");
        return Arrays.stream(paths).map(path -> Path.of(path, javaProg).toFile()).filter(file -> file.exists() && file.canExecute()).map(File::getAbsolutePath).findAny().orElseThrow(() -> new TigerTestEnvException("Unable to find executable java program in PATH"));
    }

    /*
     * Exception decompiling
     */
    private boolean waitForService(CfgServer server, long timeoutms, boolean quiet) throws IOException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 2[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void downloadJar(CfgServer server, String jarUrl, File jarFile) throws InterruptedException {
        log.info("downloading jar for external server from " + jarUrl + "...");
        File workDir = new File(server.getExternalJarOptions().getWorkingDir());
        if (!workDir.exists() && !workDir.mkdirs()) {
            throw new TigerTestEnvException("Unable to create working directory " + workDir.getAbsolutePath());
        }
        long startms = System.currentTimeMillis();
        AtomicBoolean finished = new AtomicBoolean(false);
        AtomicReference exception = new AtomicReference();
        Thread t = new Thread(() -> {
            try {
                FileUtils.copyURLToFile((URL)new URL(jarUrl), (File)jarFile);
                finished.set(true);
            }
            catch (IOException ioe) {
                exception.set(ioe);
            }
        });
        t.start();
        int progressCtr = 0;
        while (!finished.get()) {
            if (System.currentTimeMillis() - startms > 900000L) {
                t.interrupt();
                t.stop();
                throw new TigerTestEnvException("Download of " + jarUrl + " took longer then 15 minutes!");
            }
            if (exception.get() != null) {
                throw new TigerTestEnvException("Failure while downloading jar " + jarUrl + "!", (Throwable)exception.get());
            }
            Thread.sleep(500L);
            if (++progressCtr != 8) continue;
            log.info("downloaded jar for " + server.getName() + "  " + jarFile.length() / 1000L + " kb");
            progressCtr = 0;
        }
    }

    @Override
    public void shutDown(CfgServer server) {
        log.info("Shutting down server '" + server.getName() + "'");
        this.getConfiguration().getServers().stream().filter(srv -> srv.getName().equals(server.getName())).findAny().orElseThrow(() -> new TigerTestEnvException("Unknown server '" + server.getName() + "'!"));
        ServerType type = server.getType();
        if (type == ServerType.EXTERNALURL) {
            this.shutDownExternal(server);
        } else if (type == ServerType.DOCKER) {
            this.shutDownDocker(server);
        } else if (type == ServerType.EXTERNALJAR || type == ServerType.TIGERPROXY) {
            this.shutDownJar(server);
        } else {
            throw new TigerTestEnvException("Unsupported server uri type " + type);
        }
    }

    private void loadPKIForProxy(CfgServer srv) {
        log.info("  loading PKI resources for instance " + srv.getName() + "...");
        srv.getPkiKeys().stream().filter(key -> key.getType().equals("cert")).forEach(key -> {
            log.info("Adding certificate " + key.getId());
            this.getLocalTigerProxy().addKey(key.getId(), (Key)KeyMgr.readCertificateFromPem((String)("-----BEGIN CERTIFICATE-----\n" + key.getPem().replace(" ", "\n") + "\n-----END CERTIFICATE-----")).getPublicKey());
        });
        srv.getPkiKeys().stream().filter(key -> key.getType().equals("key")).forEach(key -> {
            log.info("Adding key " + key.getId());
            this.getLocalTigerProxy().addKey(key.getId(), KeyMgr.readKeyFromPem((String)("-----BEGIN PRIVATE KEY-----\n" + key.getPem().replace(" ", "\n") + "\n-----END PRIVATE KEY-----")));
        });
    }

    private void shutDownDocker(CfgServer server) {
        log.info("Stopping docker container " + server.getName() + "...");
        this.removeRoute(server);
        this.dockerManager.stopContainer(server);
    }

    private void shutDownExternal(CfgServer server) {
        this.removeRoute(server);
    }

    private void shutDownJar(CfgServer server) {
        log.info("Stopping external jar " + server.getName() + "...");
        this.removeRoute(server);
        Process proc = this.externalProcesses.get(server.getName());
        if (proc != null) {
            log.info("interrupting thread for " + server.getName() + "...");
            proc.destroy();
            log.info("stopping thread for " + server.getName() + "...");
            proc.destroyForcibly();
        } else {
            log.warn("Process for server " + server.getName() + " not found... No need to shutdown");
        }
    }

    private void removeRoute(CfgServer server) {
        log.info("Removing routes for " + server.getName() + "...");
        Predicate<TigerRoute> isServerRoute = route -> route.getFrom().equals(HTTP + server.getName()) || route.getFrom().equals(HTTPS + server.getName());
        this.routesList.stream().filter(isServerRoute).forEach(r -> this.localTigerProxy.removeRoute(r.getFrom()));
        this.routesList.removeIf(isServerRoute);
    }

    public List<TigerRoute> getRoutes() {
        return this.routesList;
    }

    @Override
    @Generated
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @Generated
    public DockerMgr getDockerManager() {
        return this.dockerManager;
    }

    @Generated
    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Generated
    public TigerProxy getLocalTigerProxy() {
        return this.localTigerProxy;
    }

    @Generated
    public List<TigerRoute> getRoutesList() {
        return this.routesList;
    }

    @Generated
    public Map<String, Process> getExternalProcesses() {
        return this.externalProcesses;
    }
}

