/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.testenvmgr;

import com.github.dockerjava.api.async.ResultCallback;
import com.github.dockerjava.api.command.InspectImageResponse;
import com.github.dockerjava.api.exception.DockerException;
import com.github.dockerjava.api.exception.NotModifiedException;
import com.github.dockerjava.api.model.ContainerConfig;
import com.github.dockerjava.api.model.ExposedPort;
import com.github.dockerjava.api.model.Ports;
import com.github.dockerjava.api.model.PullResponseItem;
import de.gematik.test.tiger.common.OsEnvironment;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvException;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.config.CfgEnvSets;
import de.gematik.test.tiger.testenvmgr.config.CfgServer;
import de.gematik.test.tiger.testenvmgr.config.Configuration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.Slf4jLogConsumer;
import org.testcontainers.containers.startupcheck.OneShotStartupCheckStrategy;
import org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import org.testcontainers.utility.DockerImageName;
import org.testcontainers.utility.MountableFile;

public class DockerMgr {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DockerMgr.class);
    private static final int MOD_ALL_EXEC = 511;
    private static final String CLZPATH = "classpath:";
    private final Map<String, GenericContainer<?>> containers = new HashMap();

    public void startContainer(CfgServer server, Configuration configuration, TigerTestEnvMgr envmgr) {
        Object imageName;
        Object object = imageName = envmgr == null ? (String)server.getSource().get(0) : envmgr.replaceSysPropsInString((String)server.getSource().get(0));
        if (server.getVersion() != null) {
            imageName = (String)imageName + ":" + server.getVersion();
        }
        DockerImageName imgName = DockerImageName.parse((String)imageName);
        this.pullImage((String)imageName);
        GenericContainer container = new GenericContainer(imgName);
        try {
            InspectImageResponse iiResponse = container.getDockerClient().inspectImageCmd((String)imageName).exec();
            ContainerConfig containerConfig = iiResponse.getConfig();
            if (containerConfig == null) {
                throw new TigerTestEnvException("Docker image '" + (String)imageName + "' has no configuration info!");
            }
            if (server.getDockerOptions().isProxied()) {
                File tmpScriptFolder;
                String[] startCmd = containerConfig.getCmd();
                String[] entryPointCmd = containerConfig.getEntrypoint();
                if (StringUtils.isNotEmpty((CharSequence)server.getDockerOptions().getEntryPoint())) {
                    entryPointCmd = new String[]{server.getDockerOptions().getEntryPoint()};
                }
                if (entryPointCmd != null && entryPointCmd[0].equals("/bin/sh") && entryPointCmd[1].equals("-c")) {
                    entryPointCmd = new String[]{"su", containerConfig.getUser(), "-c", "'" + entryPointCmd[2] + "'"};
                }
                if (!(tmpScriptFolder = Path.of("target", "tiger-testenv-mgr").toFile()).exists() && !tmpScriptFolder.mkdirs()) {
                    throw new TigerTestEnvException("Unable to create temp folder for modified startup script for server " + server.getName());
                }
                String scriptName = this.createContainerStartupScript(server, iiResponse, startCmd, entryPointCmd);
                String containerScriptPath = containerConfig.getWorkingDir() + "/" + scriptName;
                container.withCopyFileToContainer(MountableFile.forHostPath((Path)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName), (Integer)511), containerScriptPath);
                container.withCreateContainerCmdModifier(cmd -> cmd.withUser("root").withEntrypoint(new String[]{containerScriptPath}));
            }
            container.setLogConsumers(List.of(new Slf4jLogConsumer(log)));
            log.info("Passing in environment:");
            this.addEnvVarsToContainer(container, server.getEnvironment());
            server.getEnvironment().stream().filter(i -> i.startsWith("${")).map(i -> i.substring(2, i.length() - 1)).forEach(envsetName -> {
                List envVars = configuration.getEnvSets().stream().filter(envset -> envset.getName().equals(envsetName)).map(CfgEnvSets::getEnvVars).findAny().orElseThrow(() -> new TigerTestEnvException("Unknown reference to testenv set '" + envsetName));
                this.addEnvVarsToContainer(container, envVars);
            });
            if (server.getDockerOptions().isOneShot()) {
                container.withStartupCheckStrategy((StartupCheckStrategy)new OneShotStartupCheckStrategy());
            }
            container.start();
            this.waitForHealthyStartup(server, container);
            container.getDockerClient().renameContainerCmd(container.getContainerId()).withName("tiger." + server.getName()).exec();
            this.containers.put(server.getName(), container);
            HashMap ports = new HashMap();
            container.getContainerInfo().getNetworkSettings().getPorts().getBindings().entrySet().stream().filter(entry -> entry.getValue() != null).forEach(entry -> ports.put(((ExposedPort)entry.getKey()).getPort(), Integer.valueOf(((Ports.Binding[])entry.getValue())[0].getHostPortSpec())));
            server.getDockerOptions().setPorts(ports);
        }
        catch (DockerException de) {
            throw new TigerTestEnvException("Failed to start container for server " + server.getName(), de);
        }
    }

    /*
     * Exception decompiling
     */
    public void startComposition(CfgServer server) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addEnvVarsToContainer(GenericContainer<?> container, List<String> envVars) {
        envVars.stream().filter(i -> i.contains("=")).map(i -> i.split("=", 2)).forEach(envvar -> {
            log.info("  * " + envvar[0] + "=" + envvar[1]);
            container.addEnv(envvar[0], envvar[1]);
        });
    }

    public void pullImage(String imageName) {
        log.info("Pulling docker image " + imageName + "...");
        final AtomicBoolean pullComplete = new AtomicBoolean();
        pullComplete.set(false);
        final AtomicReference cbException = new AtomicReference();
        DockerClientFactory.instance().client().pullImageCmd(imageName).exec((ResultCallback)new ResultCallback.Adapter<PullResponseItem>(){

            public void onNext(PullResponseItem item) {
                log.debug(item.getStatus() + " " + (Serializable)(item.getProgressDetail() != null ? item.getProgressDetail().getCurrent() : ""));
            }

            public void onError(Throwable throwable) {
                cbException.set(throwable);
            }

            public void onComplete() {
                pullComplete.set(true);
            }
        });
        while (!pullComplete.get()) {
            if (cbException.get() != null) {
                throw new TigerTestEnvException("Unable to pull image " + imageName + "!", (Throwable)cbException.get());
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                log.warn("Interruption signaled", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
        log.info("Docker image " + imageName + " is available locally!");
    }

    private String createContainerStartupScript(CfgServer server, InspectImageResponse iiResponse, String[] startCmd, String[] entryPointCmd) {
        ContainerConfig containerConfig = iiResponse.getConfig();
        if (containerConfig == null) {
            throw new TigerTestEnvException("Docker image of server '" + server.getName() + "' has no configuration info!");
        }
        startCmd = startCmd == null ? new String[]{} : startCmd;
        entryPointCmd = entryPointCmd == null ? new String[]{} : entryPointCmd;
        try {
            String proxycert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/CertificateAuthorityCertificate.pem")), (Charset)StandardCharsets.UTF_8);
            String lecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/letsencrypt.crt")), (Charset)StandardCharsets.UTF_8);
            String risecert = IOUtils.toString((InputStream)Objects.requireNonNull(this.getClass().getResourceAsStream("/idp-rise-tu.crt")), (Charset)StandardCharsets.UTF_8);
            File tmpScriptFolder = Path.of("target", "tiger-testenv-mgr").toFile();
            if (!tmpScriptFolder.exists() && !tmpScriptFolder.mkdirs()) {
                throw new TigerTestEnvException("Unable to create script folder " + tmpScriptFolder.getAbsolutePath());
            }
            String scriptName = "__tigerStart_" + server.getName() + ".sh";
            String content = "#!/bin/sh -x\nenv\necho \"" + proxycert + "\" >> /etc/ssl/certs/ca-certificates.crt\necho \"" + lecert + "\" >> /etc/ssl/certs/ca-certificates.crt\necho \"" + risecert + "\" >> /etc/ssl/certs/ca-certificates.crt\n";
            if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
                String hostip = OsEnvironment.getDockerHostIp();
                log.info("patching /etc/hosts for possibly non supported symbolic host.docker.internal");
                content = content + "grep -q \"host.docker.internal\" /etc/hosts || echo \" \" >> /etc/hosts && echo \"" + hostip + "    host.docker.internal\" >> /etc/hosts\n";
                content = content + "echo HOSTS:\ncat /etc/hosts\n";
            } else {
                log.info("skipping etc hosts patch...");
            }
            content = content + this.getContainerWorkingDirectory(containerConfig) + String.join((CharSequence)" ", entryPointCmd).replace("\t", " ") + " " + String.join((CharSequence)" ", startCmd).replace("\t", " ") + "\n";
            FileUtils.writeStringToFile((File)Path.of(tmpScriptFolder.getAbsolutePath(), scriptName).toFile(), (String)content, (Charset)StandardCharsets.UTF_8);
            return scriptName;
        }
        catch (IOException ioe) {
            throw new TigerTestEnvException("Failed to configure start script on container for server " + server.getName(), ioe);
        }
    }

    private String getContainerWorkingDirectory(ContainerConfig containerConfig) {
        if (containerConfig.getWorkingDir() == null || containerConfig.getWorkingDir().isBlank()) {
            return "";
        }
        return "cd " + containerConfig.getWorkingDir() + "\n";
    }

    private void waitForHealthyStartup(CfgServer server, GenericContainer<?> container) {
        long startms = System.currentTimeMillis();
        long endhalfms = server.getStartupTimeoutSec() == null ? 5000L : (long)server.getStartupTimeoutSec().intValue() * 500L;
        try {
            Thread.sleep(endhalfms);
        }
        catch (InterruptedException e) {
            log.warn("Interrupted while waiting for startup of server " + server.getName(), (Throwable)e);
            Thread.currentThread().interrupt();
        }
        try {
            while (!container.isHealthy()) {
                Thread.sleep(500L);
                if (startms + endhalfms * 2L >= System.currentTimeMillis()) continue;
                throw new TigerTestEnvException("Startup of server %s timed out after %d seconds!", server.getName(), (System.currentTimeMillis() - startms) / 1000L);
            }
            log.info("HealthCheck OK (" + (container.isHealthy() ? 1 : 0) + ") for " + server.getName());
        }
        catch (InterruptedException ie) {
            log.warn("Interruption signaled while waiting for server " + server.getName() + " to start up", (Throwable)ie);
            Thread.currentThread().interrupt();
        }
        catch (TigerTestEnvException ttee) {
            throw ttee;
        }
        catch (RuntimeException rte) {
            int timeout = server.getStartupTimeoutSec() != null ? server.getStartupTimeoutSec() : 20;
            log.warn("probably no health check configured - defaulting to " + timeout + "s startup time");
            try {
                Thread.sleep((long)timeout * 1000L);
            }
            catch (InterruptedException interruptedException) {
                log.warn("Interruption signaled");
                Thread.currentThread().interrupt();
            }
            log.info("HealthCheck UNCLEAR for " + server.getName() + " as no healthcheck is configured, we assume it works and continue setup!");
        }
    }

    public void stopContainer(CfgServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getName());
        if (container != null && container.getDockerClient() != null) {
            try {
                container.getDockerClient().stopContainerCmd(container.getContainerId()).exec();
            }
            catch (NotModifiedException nmex) {
                log.warn("Failed to issue stop container cmd from docker client, trying test container's stop...");
            }
            container.stop();
        }
    }

    public void pauseContainer(CfgServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getName());
        container.getDockerClient().pauseContainerCmd(container.getContainerId()).exec();
    }

    public void unpauseContainer(CfgServer srv) {
        GenericContainer<?> container = this.containers.get(srv.getName());
        container.getDockerClient().unpauseContainerCmd(container.getContainerId()).exec();
    }

    @Generated
    public Map<String, GenericContainer<?>> getContainers() {
        return this.containers;
    }

    private static /* synthetic */ File[] lambda$startComposition$9(int x$0) {
        return new File[x$0];
    }

    private /* synthetic */ File lambda$startComposition$8(File folder, String f) {
        if (f.startsWith(CLZPATH)) {
            File tmpFile = Paths.get(folder.getAbsolutePath(), f.substring(CLZPATH.length())).toFile();
            InputStream is = this.getClass().getResourceAsStream(f.substring(CLZPATH.length()));
            if (is == null) {
                throw new TigerTestEnvException("Missing docker compose file in classpath " + f);
            }
            if (!tmpFile.getParentFile().exists() && !tmpFile.getParentFile().mkdirs()) {
                throw new TigerTestEnvException("Unable to create temp folder " + tmpFile.getParentFile().getAbsolutePath());
            }
            try (FileOutputStream fos = new FileOutputStream(tmpFile);){
                IOUtils.copy((InputStream)is, (OutputStream)fos);
                f = tmpFile.getAbsolutePath();
            }
            catch (IOException ioe) {
                throw new TigerTestEnvException("Unable to create temp docker compose files (" + f + ")", ioe);
            }
        }
        return new File(f);
    }
}

