<#--


    Copyright 2024 gematik GmbH

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

-->
<!DOCTYPE html>
<html lang="en">
<head>
    <#-- @ftlvariable name="report" type="io.cucumber.core.plugin.report.EvidenceReport" -->
    <#-- @ftlvariable name="jsonConverter" type="io.cucumber.core.plugin.report.EvidenceReportJsonConverter" -->
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <title>Evidence Report - ${report.context.scenario}</title>
    <style>
        <#include "./css/bootstrap.min.css">
    </style>
    <style>
        <#include "./css/json-viewer.css">
    </style>
    <style>
        <#include "./css/report.css">
    </style>
</head>

<body>
<header class="sticky-top">
    <h1>
        <img class="evidence-logo"
             src="data:image/png;base64,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"
             alt="Tiger logo"/>
        Tiger FHIR validation evidences
    </h1>
</header>
<main>
    <h2 class="scenario-title">&#9776; Scenario ${report.context.scenario}</h2>
    <#list report.steps as step>
        <div class="step">${step.name?no_esc}</div>
        <#if step.evidenceEntries?has_content>
            <div class="step-evidences">
                <#list step.evidenceEntries as entry>
                    <div class="row evidence-type-${entry.type}">
                        <div class="col-1 evidence-type evidence-type-${entry.type}">${entry.type}</div>
                        <div class="col-11 evidence-title">${entry.title}</div>
                    </div>
                    <div class="row evidence-type-${entry.type}">
                        <div class="col-1">&nbsp;</div>
                        <div class="col-11 evidence-details"
                             data-step-index="${step?index}"
                             data-entry-index="${entry?index}">
                            ${jsonConverter.toJson(entry.details)!''}
                        </div>
                    </div>
                </#list>
            </div>
        </#if>
    </#list>
</main>
</body>
<script>
  <#include "./js/json-viewer.js">
</script>
<script>
  function renderJsonFor(htmlElement) {

    const detailsString = htmlElement.textContent
    try {
      let detailsJson = JSON.parse(detailsString);
      // https://www.cssscript.com/minimal-json-data-formatter-jsonviewer/
      const jsonJsonViewer = new JSONViewer()
      htmlElement.textContent = ""
      htmlElement.appendChild(jsonJsonViewer.getContainer());

      const renderAll = -1;
      const collapseLevel = 0;
      jsonJsonViewer.showJSON(detailsJson, renderAll, collapseLevel)
    } catch (e) {
      htmlElement.textContent = detailsString
    }

  }

  document.querySelectorAll(".evidence-details").forEach(renderJsonFor)
</script>
</html>
