/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin.report;

import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import de.gematik.test.tiger.common.exceptions.TigerJexlException;
import de.gematik.test.tiger.glue.ResolvableArgument;
import de.gematik.test.tiger.glue.TigerParameterTypeDefinitions;
import io.cucumber.plugin.event.Argument;
import io.cucumber.plugin.event.DataTableArgument;
import io.cucumber.plugin.event.DocStringArgument;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.StepArgument;
import io.cucumber.plugin.event.TestCase;
import java.beans.ConstructorProperties;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.serenitybdd.core.Serenity;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class StepDescription {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StepDescription.class);
    private static final TigerTypedConfigurationKey<Integer> MAX_STEP_DESCRIPTION_DISPLAY_LENGTH = new TigerTypedConfigurationKey("tiger.lib.maxStepDescriptionDisplayLengthOnWebUi", Integer.class, (Object)300);
    private final PickleStepTestStep step;
    private static final String GENERICS_REGEX = "<[^<>]*>";
    private static final Pattern genericsPattern = Pattern.compile("<[^<>]*>");
    private final AtomicReference<Object> shouldResolveStepArgument = new AtomicReference();

    public static List<StepDescription> extractStepDescriptions(TestCase testCase) {
        return testCase.getTestSteps().stream().filter(PickleStepTestStep.class::isInstance).map(PickleStepTestStep.class::cast).map(StepDescription::of).toList();
    }

    public String getTooltip() {
        return this.getStepDescription(false, false);
    }

    public String getResolvedDescriptionPlain() {
        return this.getStepDescription(false, true);
    }

    public String getResolvedDescriptionHtml() {
        return this.getStepDescription(true, true);
    }

    public String getUnresolvedDescriptionHtml() {
        return this.getStepDescription(true, false);
    }

    private String getStepDescription(boolean convertToHtml, boolean resolve) {
        return this.resolveStepDescriptionFull(convertToHtml, resolve);
    }

    private static String tryResolvePlaceholders(String input) {
        try {
            return StepDescription.abbreviate(TigerGlobalConfiguration.resolvePlaceholders((String)input));
        }
        catch (TigerConfigurationException | TigerJexlException | JexlException e) {
            log.trace("Could not resolve placeholders in {}", (Object)input, (Object)e);
            return input;
        }
    }

    private static String tryResolvePlaceholders(Argument argument) {
        if (TigerParameterTypeDefinitions.isResolvedVariableType(argument.getParameterTypeName())) {
            return StepDescription.tryResolvePlaceholders(argument.getValue());
        }
        return argument.getValue();
    }

    private String resolveStepDescriptionFull(boolean convertToHtml, boolean resolve) {
        String keyWord = this.step.getStep().getKeyword();
        String stepText = resolve ? this.resolveStepDescriptionPrefix() : this.step.getStep().getText();
        UnaryOperator<String> converter = this.converter(convertToHtml);
        String prefix = (String)converter.apply(keyWord + stepText);
        Optional<String> docstringOrTable = this.extractDocStringOrTable(convertToHtml, resolve);
        return docstringOrTable.map(s -> prefix + System.lineSeparator() + s).orElse(prefix);
    }

    private String resolveStepDescriptionPrefix() {
        String stepDefinitionText = this.step.getPattern();
        List arguments = this.step.getDefinitionArgument();
        List<String> argumentsToResolve = arguments.stream().map(StepDescription::tryResolvePlaceholders).toList();
        if (argumentsToResolve.isEmpty()) {
            return stepDefinitionText;
        }
        return StepDescription.replacePlaceHoldersInOrder(stepDefinitionText, argumentsToResolve);
    }

    public void recordResolvedDescription() {
        String resolvedDescription = this.resolveStepDescriptionFull(false, true);
        Serenity.recordReportData().withTitle("Tiger Resolved Step Description").andContents(StringEscapeUtils.escapeJava((String)resolvedDescription));
    }

    private Optional<String> extractDocStringOrTable(boolean convertToHtml, boolean resolve) {
        StepArgument argument = this.step.getStep().getArgument();
        if (argument == null) {
            return Optional.empty();
        }
        if (argument instanceof DataTableArgument) {
            DataTableArgument dataTableArgument = (DataTableArgument)argument;
            if (convertToHtml) {
                return Optional.of(this.dataTableHtml(dataTableArgument, resolve));
            }
            return Optional.of(this.dataTablePlainText(dataTableArgument, resolve));
        }
        if (argument instanceof DocStringArgument) {
            DocStringArgument docStringArgument = (DocStringArgument)argument;
            if (convertToHtml) {
                return Optional.of(this.docStringHtml(docStringArgument, resolve));
            }
            return Optional.of(this.docStringPlainText(docStringArgument, resolve));
        }
        return Optional.empty();
    }

    private String dataTablePlainText(DataTableArgument dataTableArgument, boolean resolve) {
        UnaryOperator<String> resolver = this.resolver(resolve);
        return dataTableArgument.cells().stream().map(row -> row.stream().map(resolver).collect(Collectors.joining(" | ", "| ", " |"))).collect(Collectors.joining(System.lineSeparator()));
    }

    private String dataTableHtml(DataTableArgument dataTableArgument, boolean resolve) {
        StringBuilder result = new StringBuilder("<br/><table class=\"table table-sm table-data-table\">");
        UnaryOperator<String> resolver = this.resolver(resolve);
        dataTableArgument.cells().forEach(row -> {
            result.append("<tr>");
            row.forEach(cellText -> result.append("<td>").append(StringEscapeUtils.escapeHtml4((String)((String)resolver.apply((String)cellText)))).append("</td>"));
            result.append("</tr>");
        });
        result.append("</table>");
        return result.toString();
    }

    private UnaryOperator<String> resolver(boolean resolve) {
        return resolve && this.getShouldResolveStepArgument() != false ? StepDescription::tryResolvePlaceholders : UnaryOperator.identity();
    }

    private UnaryOperator<String> converter(boolean convertToHtml) {
        return convertToHtml ? StringEscapeUtils::escapeHtml4 : UnaryOperator.identity();
    }

    private String docStringHtml(DocStringArgument docStringArgument, boolean resolve) {
        return "<div class=\"steps-docstring\">" + StringEscapeUtils.escapeHtml4((String)this.docStringPlainText(docStringArgument, resolve)) + "</div>";
    }

    private String docStringPlainText(DocStringArgument docStringArgument, boolean resolve) {
        UnaryOperator<String> resolver = this.resolver(resolve);
        return (String)resolver.apply(docStringArgument.getContent());
    }

    private static String replacePlaceHoldersInOrder(String input, List<String> replacements) {
        Pattern placeholderPattern = Pattern.compile("\\{[^}]*+}");
        Matcher matcher = placeholderPattern.matcher(input);
        StringBuilder result = new StringBuilder();
        int replacementIndex = 0;
        while (matcher.find()) {
            String replacement = Matcher.quoteReplacement(replacements.get(replacementIndex));
            matcher.appendReplacement(result, replacement);
            ++replacementIndex;
        }
        matcher.appendTail(result);
        return result.toString();
    }

    boolean isMethodResolvable(String methodSignature) {
        int parenIndex = methodSignature.indexOf("(");
        int lastDotInMethodPath = methodSignature.lastIndexOf(46, parenIndex - 1);
        String className = methodSignature.substring(0, lastDotInMethodPath);
        String methodName = methodSignature.substring(lastDotInMethodPath + 1);
        Matcher matcher = genericsPattern.matcher(methodName);
        while (matcher.find()) {
            methodName = methodName.replaceAll(GENERICS_REGEX, "");
            matcher = genericsPattern.matcher(methodName);
        }
        try {
            Method method = BeanUtils.resolveSignature((String)methodName, Class.forName(className));
            if (method == null) {
                return false;
            }
            return Arrays.stream(method.getAnnotations()).anyMatch(a -> a.annotationType().equals(ResolvableArgument.class));
        }
        catch (ClassNotFoundException | IllegalArgumentException e) {
            return false;
        }
    }

    private boolean shouldResolveStepArgument() {
        String codeLocation = this.step.getCodeLocation();
        return this.isMethodResolvable(codeLocation);
    }

    private static String abbreviate(String input) {
        return StringUtils.abbreviate((String)input, (int)((Integer)MAX_STEP_DESCRIPTION_DISPLAY_LENGTH.getValueOrDefault()));
    }

    @ConstructorProperties(value={"step"})
    @Generated
    private StepDescription(PickleStepTestStep step) {
        this.step = step;
    }

    @Generated
    public static StepDescription of(PickleStepTestStep step) {
        return new StepDescription(step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    private Boolean getShouldResolveStepArgument() {
        Object $value = this.shouldResolveStepArgument.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = this.shouldResolveStepArgument;
            synchronized (atomicReference) {
                $value = this.shouldResolveStepArgument.get();
                if ($value == null) {
                    Boolean actualValue = this.shouldResolveStepArgument();
                    $value = actualValue == null ? this.shouldResolveStepArgument : actualValue;
                    this.shouldResolveStepArgument.set($value);
                }
            }
        }
        return (Boolean)($value == this.shouldResolveStepArgument ? null : $value);
    }
}

