/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin.report;

import com.google.common.collect.Streams;
import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.TigerNonPairedMessageFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.renderer.MessageMetaDataDto;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.LocalProxyRbelMessageListener;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.exceptions.TigerJexlException;
import de.gematik.test.tiger.common.exceptions.TigerOsException;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.rbel.RbelMessageRetriever;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.testenvmgr.env.FeatureUpdate;
import de.gematik.test.tiger.testenvmgr.env.ScenarioRunner;
import de.gematik.test.tiger.testenvmgr.env.ScenarioUpdate;
import de.gematik.test.tiger.testenvmgr.env.StepUpdate;
import de.gematik.test.tiger.testenvmgr.env.TestResult;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import io.cucumber.core.plugin.FeatureFileLoader;
import io.cucumber.core.plugin.IScenarioContext;
import io.cucumber.core.plugin.SerenityUtils;
import io.cucumber.core.plugin.report.EvidenceRecorder;
import io.cucumber.core.plugin.report.EvidenceRecorderFactory;
import io.cucumber.core.plugin.report.EvidenceRenderer;
import io.cucumber.core.plugin.report.EvidenceReport;
import io.cucumber.core.plugin.report.FeatureExecutionMonitor;
import io.cucumber.core.plugin.report.HtmlEvidenceRenderer;
import io.cucumber.core.plugin.report.LocationConverter;
import io.cucumber.core.plugin.report.ReportStepConfiguration;
import io.cucumber.core.plugin.report.StepDescription;
import io.cucumber.core.runner.TestCaseDelegate;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Location;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.TableCell;
import io.cucumber.messages.types.TableRow;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.HookTestStep;
import io.cucumber.plugin.event.PickleStepTestStep;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCase;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStep;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.UnaryOperator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import net.serenitybdd.core.Serenity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.jexl3.JexlException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.text.StringEscapeUtils;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.jetbrains.annotations.NotNull;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SerenityReporterCallbacks {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SerenityReporterCallbacks.class);
    public static final String TARGET_DIR = "target";
    private static final Object startupMutex = new Object();
    private static RuntimeException tigerStartupFailedException;
    private static boolean pauseMode;
    private final ThreadLocal<Boolean> scenarioAlreadyFailed = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final Pattern showSteps = Pattern.compile(".*TGR (zeige|show) ([\\w|\u00fc\u00df ]*)(Banner|banner|text|Text) \"(.*)\"");
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private final EvidenceRecorder evidenceRecorder = EvidenceRecorderFactory.getEvidenceRecorder();
    private final EvidenceRenderer evidenceRenderer = new EvidenceRenderer(new HtmlEvidenceRenderer());
    FeatureFileLoader featureLoader = new FeatureFileLoader();
    private int scPassed = 0;
    private int scFailed = 0;
    private final FeatureExecutionMonitor featureExecutionMonitor = new FeatureExecutionMonitor();

    @NotNull
    private static Path getEvidenceDir() throws IOException {
        Path parentDir = Path.of(TARGET_DIR, "evidences");
        if (Files.notExists(parentDir, new LinkOption[0])) {
            Files.createDirectories(parentDir, new FileAttribute[0]);
        }
        return parentDir;
    }

    public void handleTestSourceRead(Event event) {
        this.featureLoader.addTestSourceReadEvent((TestSourceRead)event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleTestRunStarted(Event ignoredEvent) {
        Object object = startupMutex;
        synchronized (object) {
            if (TigerDirector.isInitialized()) {
                return;
            }
            this.showTigerVersion();
            this.initializeTiger();
            TigerDirector.assertThatTigerIsInitialized();
            this.shouldAbortTestExecution();
            this.featureExecutionMonitor.startTestRun();
        }
    }

    public void handleTestRunFinished(TestRunFinished ignoredEvent) {
        this.scenarioAlreadyFailed.remove();
        this.featureExecutionMonitor.stopTestRun();
    }

    private void showTigerVersion() {
        log.info(Ansi.colorize((String)("Starting Tiger version " + this.getTigerVersionString()), (RbelAnsiColors)RbelAnsiColors.GREEN_BRIGHT));
    }

    private String getTigerVersionString() {
        try {
            Properties p = new Properties();
            p.load(SerenityReporterCallbacks.class.getResourceAsStream("/build.properties"));
            String version = p.getProperty("tiger.version");
            if (version.equals("${project.version}")) {
                version = "UNKNOWN";
            }
            return version + "-" + p.getProperty("tiger.build.timestamp");
        }
        catch (IOException | RuntimeException ignored) {
            return "UNKNOWN";
        }
    }

    private synchronized void initializeTiger() {
        if (tigerStartupFailedException != null) {
            return;
        }
        try {
            TigerDirector.registerShutdownHook();
            TigerDirector.start();
        }
        catch (RuntimeException rte) {
            tigerStartupFailedException = rte;
            throw tigerStartupFailedException;
        }
    }

    public void handleTestCaseStarted(TestCaseStarted testCaseStartedEvent, IScenarioContext context) {
        this.shouldAbortTestExecution();
        this.scenarioAlreadyFailed.set(Boolean.FALSE);
        Optional<Feature> currentFeature = this.featureFrom(context.getFeatureURI());
        TestCase testCase = testCaseStartedEvent.getTestCase();
        boolean isDryRun = TestCaseDelegate.of(testCase).isDryRun();
        currentFeature.ifPresent(feature -> this.informWorkflowUiAboutCurrentScenario((Feature)feature, testCase, context, isDryRun));
        this.evidenceRecorder.reset();
        this.featureExecutionMonitor.startTestCase(testCaseStartedEvent);
    }

    public int extractScenarioDataVariantIndex(IScenarioContext context, TestCase testCase) {
        Location searchLocation = new LocationConverter().convertLocation(testCase.getLocation());
        String scenarioId = this.scenarioIdFrom(testCase);
        return Streams.mapWithIndex(context.currentScenarioOutline(scenarioId).getExamples().stream().map(Examples::getTableBody).flatMap(Collection::stream).map(TableRow::getLocation).map(arg_0 -> ((Location)searchLocation).equals(arg_0)), Pair::of).filter(Pair::getLeft).map(Pair::getRight).map(Math::toIntExact).findFirst().orElse(-1);
    }

    private Optional<Feature> featureFrom(URI currentFeaturePath) {
        return Optional.ofNullable(this.featureLoader.getFeature(currentFeaturePath));
    }

    private void informWorkflowUiAboutCurrentScenario(Feature feature, TestCase testCase, IScenarioContext context, boolean isDryRun) {
        String scenarioId = this.scenarioIdFrom(testCase);
        Scenario scenario = context.getCurrentScenarioDefinition(scenarioId);
        int dataVariantIndex = this.extractScenarioDataVariantIndex(context, testCase);
        log.info("Scenario location {}", (Object)scenario.getLocation());
        Map<String, String> variantDataMap = this.getVariantDataMap(context, scenarioId, dataVariantIndex);
        log.debug("Current row for scenario variant {} {}", (Object)dataVariantIndex, variantDataMap);
        String scenarioUniqueId = ScenarioRunner.findScenarioUniqueId((URI)context.getFeatureURI(), (Location)SerenityReporterCallbacks.convertLocation(testCase.getLocation())).toString();
        ScenarioUpdate scenarioUpdate = ScenarioUpdate.builder().isDryRun(isDryRun).description(this.replaceOutlineParameters(scenario.getName(), variantDataMap, false)).uniqueId(scenarioUniqueId).variantIndex(dataVariantIndex).exampleKeys(context.isAScenarioOutline(scenarioId) ? context.getTable(scenarioId).getHeaders() : null).exampleList(variantDataMap).steps(this.stepUpdates(StepDescription.extractStepDescriptions(testCase))).build();
        FeatureUpdate featureUpdate = FeatureUpdate.builder().description(feature.getName()).scenarios(SerenityReporterCallbacks.convertToLinkedHashMap(scenarioUniqueId, scenarioUpdate)).build();
        TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(TigerStatusUpdate.builder().featureMap(SerenityReporterCallbacks.convertToLinkedHashMap(feature.getName(), featureUpdate)).build());
    }

    @NotNull
    private static <T> LinkedHashMap<String, T> convertToLinkedHashMap(String key, T value) {
        return new LinkedHashMap<String, T>(Map.of(key, value));
    }

    private Map<String, String> getVariantDataMap(IScenarioContext context, String scenarioId, int dataVariantIndex) {
        if (context.isAScenarioOutline(scenarioId)) {
            List examples = context.currentScenarioOutline(scenarioId).getExamples();
            List headers = ((Examples)examples.get(0)).getTableHeader().map(SerenityReporterCallbacks::getCellValues).orElse(Collections.emptyList());
            List values = SerenityReporterCallbacks.findExampleRow(dataVariantIndex, examples).map(SerenityReporterCallbacks::getCellValues).orElse(Collections.emptyList());
            return SerenityReporterCallbacks.createMap(headers, values);
        }
        return Map.of();
    }

    @NotNull
    private static List<String> getCellValues(TableRow row) {
        return row.getCells().stream().map(TableCell::getValue).toList();
    }

    @NotNull
    private static <A, B> Map<A, B> createMap(List<A> keys, List<B> values) {
        HashMap<A, B> map = new HashMap<A, B>();
        Iterator<A> it1 = keys.iterator();
        Iterator<B> it2 = values.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            map.put(it1.next(), it2.next());
        }
        return map;
    }

    @NotNull
    private static Optional<TableRow> findExampleRow(int dataVariantIndex, List<Examples> examples) {
        return examples.stream().map(Examples::getTableBody).flatMap(Collection::stream).skip(dataVariantIndex).findFirst();
    }

    private String replaceOutlineParameters(String line, Map<String, String> variantDataMap, boolean convertToHtml) {
        if (variantDataMap == null) {
            return line;
        }
        UnaryOperator<Object> converter = convertToHtml ? StringEscapeUtils::escapeHtml4 : UnaryOperator.identity();
        String parsedLine = line;
        for (Map.Entry<String, String> entry : variantDataMap.entrySet()) {
            String parameterReference = (String)converter.apply("<" + entry.getKey() + ">");
            String parameterValue = (String)converter.apply(entry.getValue());
            parsedLine = parsedLine.replace(parameterReference, parameterValue);
        }
        return parsedLine;
    }

    private LinkedHashMap<String, StepUpdate> stepUpdates(List<StepDescription> testSteps) {
        LinkedHashMap<String, StepUpdate> map = new LinkedHashMap<String, StepUpdate>();
        Streams.mapWithIndex(testSteps.stream(), (step, stepIndex) -> StepUpdate.builder().description(step.getUnresolvedDescriptionHtml()).tooltip(step.getTooltip()).status(TestResult.PENDING).stepIndex(Math.toIntExact(stepIndex)).build()).forEach(stepUpdate -> map.put(Integer.toString(stepUpdate.getStepIndex()), (StepUpdate)stepUpdate));
        return map;
    }

    public void handleTestStepStarted(TestStepStarted event, IScenarioContext context) {
        this.shouldWaitIfInPauseMode();
        this.shouldAbortTestExecution();
        TestCase testCase = event.getTestCase();
        TestStep testStep = event.getTestStep();
        if (!(testStep instanceof HookTestStep) && testStep instanceof PickleStepTestStep) {
            TestResult result = Boolean.TRUE.equals(this.scenarioAlreadyFailed.get()) ? TestResult.SKIPPED : TestResult.EXECUTING;
            this.updateStepInformation(context, testCase, testStep, result, StepState.STARTED);
            this.evidenceRecorder.openStepContext(new ReportStepConfiguration(StepDescription.of((PickleStepTestStep)testStep).getUnresolvedDescriptionHtml()));
        }
    }

    private void updateStepInformation(IScenarioContext context, TestCase testCase, TestStep testStep, TestResult result, StepState stepState) {
        boolean dryRun = TestCaseDelegate.of(testCase).isDryRun();
        TestResult status = dryRun ? TestResult.TEST_DISCOVERED : result;
        int dataVariantIndex = this.extractScenarioDataVariantIndex(context, testCase);
        this.informWorkflowUiAboutCurrentStep(context, testCase, testStep, status, dryRun, dataVariantIndex, stepState);
    }

    private void addBannerMessageToUpdate(Map<String, String> variantDataMap, PickleStepTestStep pickleTestStep, TigerStatusUpdate.TigerStatusUpdateBuilder statusUpdateBuilder) {
        Matcher m = this.showSteps.matcher(pickleTestStep.getStep().getText());
        if (m.find()) {
            Color col;
            String colStr = this.replaceOutlineParameters(m.group(2), variantDataMap, false).trim();
            try {
                col = !colStr.isEmpty() ? (Color)Color.class.getDeclaredField(RbelAnsiColors.seekColor((String)colStr).name().toUpperCase()).get(null) : Color.BLACK;
            }
            catch (IllegalAccessException | NoSuchFieldException ignored) {
                col = Color.BLACK;
            }
            statusUpdateBuilder.bannerColor(String.format("#%06X", 0xFFFFFF & col.getRGB())).bannerMessage(SerenityReporterCallbacks.tryResolvePlaceholders(this.replaceOutlineParameters(m.group(4), variantDataMap, false)));
        }
    }

    public void handleTestStepFinished(TestStepFinished event, IScenarioContext context) {
        if (TigerDirector.getTigerTestEnvMgr().isShouldAbortTestExecution()) {
            return;
        }
        TestStep testStep = event.getTestStep();
        if (!(testStep instanceof HookTestStep)) {
            TestCase testCase;
            if (TigerDirector.getLibConfig().isAddCurlCommandsForRaCallsToReport() && TigerDirector.isSerenityAvailable() && TigerDirector.getCurlLoggingFilter() != null) {
                TigerDirector.getCurlLoggingFilter().printToReport();
            }
            if (context.getCurrentStep(testCase = event.getTestCase()) != null) {
                TestResult result = TestResult.from((Status)event.getResult().getStatus());
                if (TestResult.FAILED.equals((Object)result)) {
                    this.scenarioAlreadyFailed.set(true);
                }
                this.updateStepInformation(context, testCase, testStep, result, StepState.FINISHED);
                if (TigerDirector.isSerenityAvailable()) {
                    this.addStepEvidence();
                }
            }
        }
    }

    private void addStepEvidence() {
        this.evidenceRecorder.getCurrentStep().ifPresent(step -> step.getEvidenceEntries().forEach(entry -> Serenity.recordReportData().asEvidence().withTitle(String.valueOf((Object)entry.getType()) + " - " + entry.getTitle()).andContents(new JSONObject(entry.getDetails()).toString(2))));
    }

    private void informWorkflowUiAboutCurrentStep(IScenarioContext context, TestCase testCase, TestStep testStep, TestResult status, boolean isDryRun, int variantDataIndex, StepState stepState) {
        String scenarioId = this.scenarioIdFrom(testCase);
        Scenario scenario = context.getCurrentScenarioDefinition(scenarioId);
        PickleStepTestStep pickleTestStep = (PickleStepTestStep)testStep;
        Optional<Feature> feature = this.featureFrom(context.getFeatureURI());
        List steps = testCase.getTestSteps();
        int stepIndex = SerenityReporterCallbacks.findStepIndex((TestStep)pickleTestStep, steps);
        TigerStatusUpdate.TigerStatusUpdateBuilder builder = TigerStatusUpdate.builder();
        String featureName = feature.map(Feature::getName).orElse("?");
        Map<String, String> variantDataMap = this.getVariantDataMap(context, scenarioId, variantDataIndex);
        if (!isDryRun) {
            this.addBannerMessageToUpdate(variantDataMap, pickleTestStep, builder);
        }
        String scenarioUniqueId = ScenarioRunner.findScenarioUniqueId((URI)context.getFeatureURI(), (Location)SerenityReporterCallbacks.convertLocation(testCase.getLocation())).toString();
        StepDescription stepDescription = StepDescription.of(pickleTestStep);
        List<RbelElement> currentStepMessages = this.getCurrentStepMessages(isDryRun, stepState);
        List<MessageMetaDataDto> messageMetaData = SerenityReporterCallbacks.getMessageMetaData(currentStepMessages);
        StepUpdate currentStepUpdate = StepUpdate.builder().description(this.getHtmlDescription(stepDescription, isDryRun, status)).tooltip(stepDescription.getTooltip()).status(status).stepIndex(stepIndex).rbelMetaData(messageMetaData).build();
        ScenarioUpdate scenarioUpdate = ScenarioUpdate.builder().isDryRun(isDryRun).description(this.replaceOutlineParameters(scenario.getName(), variantDataMap, false)).uniqueId(scenarioUniqueId).variantIndex(variantDataIndex).exampleKeys(context.isAScenarioOutline(scenarioId) ? context.getTable(scenarioId).getHeaders() : null).exampleList(variantDataMap).steps(Map.of(String.valueOf(stepIndex), currentStepUpdate)).build();
        if (TestResult.EXECUTING.equals((Object)status)) {
            stepDescription.recordResolvedDescription();
        }
        FeatureUpdate featureUpdate = FeatureUpdate.builder().description(featureName).scenarios(SerenityReporterCallbacks.convertToLinkedHashMap(scenarioUniqueId, scenarioUpdate)).build();
        TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(builder.featureMap(SerenityReporterCallbacks.convertToLinkedHashMap(featureName, featureUpdate)).build());
        LocalProxyRbelMessageListener.getInstance().removeStepRbelMessages(currentStepMessages);
    }

    private void updateLastStepMessages(IScenarioContext context, TestCase testCase, int variantDataIndex) {
        List steps = testCase.getTestSteps();
        if (steps.isEmpty()) {
            return;
        }
        Object e = steps.get(steps.size() - 1);
        if (e instanceof PickleStepTestStep) {
            PickleStepTestStep pickleTestStep = (PickleStepTestStep)e;
            Optional<Feature> feature = this.featureFrom(context.getFeatureURI());
            int stepIndex = SerenityReporterCallbacks.findStepIndex((TestStep)pickleTestStep, steps);
            String featureName = feature.map(Feature::getName).orElse("?");
            String scenarioUniqueId = ScenarioRunner.findScenarioUniqueId((URI)context.getFeatureURI(), (Location)SerenityReporterCallbacks.convertLocation(testCase.getLocation())).toString();
            List<RbelElement> currentStepMessages = this.getCurrentStepMessages(false, StepState.FINISHED);
            if (currentStepMessages.isEmpty()) {
                return;
            }
            List<MessageMetaDataDto> messageMetaData = SerenityReporterCallbacks.getMessageMetaData(currentStepMessages);
            StepUpdate currentStepUpdate = StepUpdate.builder().status(TestResult.UNUSED).stepIndex(stepIndex).rbelMetaData(messageMetaData).build();
            ScenarioUpdate scenarioUpdate = ScenarioUpdate.builder().uniqueId(scenarioUniqueId).status(TestResult.UNUSED).steps(Map.of(String.valueOf(stepIndex), currentStepUpdate)).variantIndex(variantDataIndex).build();
            FeatureUpdate featureUpdate = FeatureUpdate.builder().description(featureName).scenarios(SerenityReporterCallbacks.convertToLinkedHashMap(scenarioUniqueId, scenarioUpdate)).build();
            TigerStatusUpdate statusUpdate = TigerStatusUpdate.builder().featureMap(SerenityReporterCallbacks.convertToLinkedHashMap(featureName, featureUpdate)).build();
            TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(statusUpdate);
            LocalProxyRbelMessageListener.getInstance().removeStepRbelMessages(currentStepMessages);
        }
    }

    private String getHtmlDescription(StepDescription description, boolean isDryRun, TestResult stepResult) {
        if (isDryRun) {
            return description.getUnresolvedDescriptionHtml();
        }
        if (TestResult.EXECUTING.equals((Object)stepResult)) {
            return description.getResolvedDescriptionHtml();
        }
        return "";
    }

    @NotNull
    private static List<MessageMetaDataDto> getMessageMetaData(List<RbelElement> currentStepMessages) {
        return currentStepMessages.stream().map(MessageMetaDataDto::createFrom).collect(Collectors.toCollection(ArrayList::new));
    }

    private List<RbelElement> getCurrentStepMessages(boolean isDryRun, StepState stepState) {
        if (isDryRun || stepState != StepState.FINISHED) {
            return Collections.emptyList();
        }
        Integer waitTime = (Integer)RbelMessageRetriever.RBEL_REQUEST_TIMEOUT.getValueOrDefault();
        try {
            Awaitility.await().atMost((long)waitTime.intValue(), TimeUnit.SECONDS).pollInterval(200L, TimeUnit.MILLISECONDS).until(this::getFullyProcessedStepMessages, this::allRequestsPaired);
        }
        catch (ConditionTimeoutException e) {
            log.atWarn().addArgument((Object)waitTime).log("Not all messages are processed and paired after {} seconds.");
        }
        return LocalProxyRbelMessageListener.getInstance().getStepRbelMessages();
    }

    private List<RbelElement> getFullyProcessedStepMessages() {
        TigerDirector.getTigerTestEnvMgr().getLocalTigerProxyOptional().map(AbstractTigerProxy::getRbelLogger).map(RbelLogger::getMessageHistory).map(List::copyOf).orElseGet(Collections::emptyList).forEach(RbelConverter::waitUntilFullyProcessed);
        return LocalProxyRbelMessageListener.getInstance().getStepRbelMessages();
    }

    private boolean allRequestsPaired(List<RbelElement> stepMessages) {
        HashSet<RbelElement> messages = new HashSet<RbelElement>(stepMessages);
        return stepMessages.stream().filter(message -> message.hasFacet(RbelRequestFacet.class) && !message.hasFacet(TigerNonPairedMessageFacet.class)).allMatch(message -> message.getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getResponse).stream().anyMatch(messages::contains));
    }

    private static int findStepIndex(TestStep step, List<TestStep> steps) {
        List<TestStep> pickleSteps = steps.stream().filter(PickleStepTestStep.class::isInstance).toList();
        return pickleSteps.indexOf(step);
    }

    private static Location convertLocation(io.cucumber.plugin.event.Location location) {
        return new LocationConverter().convertLocation(location);
    }

    private static String tryResolvePlaceholders(String input) {
        try {
            return TigerGlobalConfiguration.resolvePlaceholders((String)input);
        }
        catch (TigerConfigurationException | TigerJexlException | JexlException e) {
            log.trace("Could not resolve placeholders in {}", (Object)input, (Object)e);
            return input;
        }
    }

    public void handleTestCaseFinished(TestCaseFinished event, IScenarioContext context) {
        String scenarioStatus;
        if (TigerDirector.getTigerTestEnvMgr().isShouldAbortTestExecution()) {
            return;
        }
        TestCase testCase = event.getTestCase();
        if (TestCaseDelegate.of(testCase).isDryRun()) {
            return;
        }
        int dataVariantIndex = this.extractScenarioDataVariantIndex(context, testCase);
        this.updateLastStepMessages(context, testCase, dataVariantIndex);
        switch (scenarioStatus = event.getResult().getStatus().toString()) {
            case "PASSED": {
                ++this.scPassed;
                break;
            }
            case "ERROR": 
            case "FAILED": {
                ++this.scFailed;
                break;
            }
            case "UNDEFINED": {
                break;
            }
            default: {
                log.warn("Unsupported scenario state: %s".formatted(scenarioStatus));
            }
        }
        log.info("------------ STATUS: {} passed {}", (Object)this.scPassed, this.scFailed > 0 ? this.scFailed + " failed or error" : "");
        if (TigerDirector.getLibConfig().createRbelHtmlReports) {
            this.createRbelLogReport(testCase.getName(), testCase.getUri(), dataVariantIndex);
        }
        this.createEvidenceFile(event, context, this.scenarioIdFrom(testCase));
        TigerGlobalConfiguration.clearLocalTestVariables();
    }

    private void createEvidenceFile(TestCaseFinished testCaseFinishedEvent, IScenarioContext scenarioContext, String scenarioId) {
        EvidenceReport evidenceReport = this.getEvidenceReport(testCaseFinishedEvent, scenarioContext, scenarioId);
        if (evidenceReport.getSteps().stream().anyMatch(step -> !step.getEvidenceEntries().isEmpty())) {
            int dataVariantIndex = this.extractScenarioDataVariantIndex(scenarioContext, testCaseFinishedEvent.getTestCase());
            Path reportFile = this.createEvidenceReportFile(scenarioContext, evidenceReport, scenarioId, dataVariantIndex);
            if (TigerDirector.isSerenityAvailable()) {
                Serenity.recordReportData().asEvidence().withTitle("Evidence Report").downloadable().fromFile(reportFile);
            }
        }
    }

    @NotNull
    private Path createEvidenceReportFile(IScenarioContext scenarioContext, EvidenceReport evidenceReport, String scenarioId, int variantDataIndex) throws IOException {
        String renderedReport = this.evidenceRenderer.render(evidenceReport);
        Path parentDir = SerenityReporterCallbacks.getEvidenceDir();
        return Files.writeString(parentDir.resolve(this.getFileNameFor("evidence", scenarioContext.getCurrentScenarioDefinition(scenarioId).getName(), variantDataIndex)), (CharSequence)renderedReport, StandardOpenOption.CREATE, StandardOpenOption.WRITE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    private EvidenceReport getEvidenceReport(TestCaseFinished testCaseFinishedEvent, IScenarioContext scenarioContext, String scenarioId) {
        return this.evidenceRecorder.getEvidenceReportForScenario(new EvidenceReport.ReportContext(scenarioContext.getCurrentScenarioDefinition(scenarioId).getName(), testCaseFinishedEvent.getTestCase().getUri()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createRbelLogReport(String scenarioName, URI scenarioUri, int variantDataIndex) {
        try {
            File folder = Paths.get(TARGET_DIR, "rbellogs").toFile();
            if (!folder.exists() && !folder.mkdirs()) {
                throw new TigerOsException("Unable to create folder '" + folder.getAbsolutePath() + "'");
            }
            RbelHtmlRenderer rbelRenderer = this.getRbelHtmlRenderer(scenarioName, scenarioUri, variantDataIndex);
            String html = rbelRenderer.doRender(LocalProxyRbelMessageListener.getInstance().getMessages());
            String name = this.getFileNameFor("rbel", scenarioName, variantDataIndex);
            File logFile = Paths.get(TARGET_DIR, "rbellogs", name).toFile();
            FileUtils.writeStringToFile((File)logFile, (String)html, (Charset)StandardCharsets.UTF_8);
            if (TigerDirector.isSerenityAvailable()) {
                Serenity.recordReportData().asEvidence().withTitle("RBellog " + (variantDataIndex + 1)).downloadable().fromFile(logFile.toPath());
            }
            log.info("Saved HTML report of scenario '{}' to {}", (Object)scenarioName, (Object)logFile.getAbsolutePath());
        }
        catch (IOException e) {
            log.error("Unable to create/save rbel log for scenario " + scenarioName, (Throwable)e);
        }
        finally {
            LocalProxyRbelMessageListener.getInstance().clearMessages();
        }
    }

    @NotNull
    private RbelHtmlRenderer getRbelHtmlRenderer(String scenarioName, URI scenarioUri, int dataVariantIndex) {
        RbelHtmlRenderer rbelRenderer = new RbelHtmlRenderer();
        rbelRenderer.setTitle(scenarioName);
        rbelRenderer.setSubTitle("<p>" + (String)(dataVariantIndex != -1 ? "<button class=\"js-modal-trigger\" data-bs-target=\"modal-data-variant\">Variant " + (dataVariantIndex + 1) + "</button>" : "") + "</p><p><i>" + String.valueOf(scenarioUri) + "</i></p>");
        rbelRenderer.setVersionInfo(this.getTigerVersionString());
        return rbelRenderer;
    }

    public String getFileNameFor(String type, String scenarioName, int dataVariantIndex) {
        if (((String)(scenarioName = this.replaceSpecialCharacters((String)scenarioName))).length() > 30) {
            scenarioName = ((String)scenarioName).substring(0, 30) + String.valueOf(UUID.nameUUIDFromBytes(((String)scenarioName).getBytes(StandardCharsets.UTF_8)));
        }
        if (dataVariantIndex != -1) {
            scenarioName = (String)scenarioName + "_" + (dataVariantIndex + 1);
        }
        return type + "_" + (String)scenarioName + "_" + this.sdf.format(new Date()) + ".html";
    }

    public String replaceSpecialCharacters(String name) {
        String result = name;
        String[] tokenMap = new String[]{"\u00e4", "ae", "\u00c4", "Ae", "\u00f6", "oe", "\u00d6", "Oe", "\u00fc", "ue", "\u00dc", "Ue", "\u00df", "s", " ", "_", "(", "_", ")", "_", "[", "_", "]", "_", "{", "_", "}", "_", "<", "_", ">", "_", "|", "_", "$", "_", "%", "_", "&", "_", "/", "_", "\\", "_", "?", "_", ":", "_", "*", "_", "\"", "_"};
        for (int i = 0; i < tokenMap.length; i += 2) {
            result = result.replace(tokenMap[i], tokenMap[i + 1]);
        }
        return result;
    }

    private void shouldAbortTestExecution() {
        if (TigerDirector.getTigerTestEnvMgr().isShouldAbortTestExecution()) {
            throw new AssertionError((Object)"Aborted test execution on user request");
        }
    }

    private void shouldWaitIfInPauseMode() {
        if (SerenityReporterCallbacks.isPauseMode()) {
            log.info("Test run is paused, via Workflow Ui pause button...");
            Awaitility.await().pollDelay(500L, TimeUnit.MILLISECONDS).atMost(TigerDirector.getLibConfig().getPauseExecutionTimeoutSeconds(), TimeUnit.SECONDS).until(() -> !SerenityReporterCallbacks.isPauseMode() || TigerDirector.getTigerTestEnvMgr().isShouldAbortTestExecution());
            log.info("Test run commencing...");
        }
    }

    public String scenarioIdFrom(TestCase testCase) {
        return SerenityUtils.scenarioIdFrom(this.featureLoader, testCase);
    }

    @Generated
    public static boolean isPauseMode() {
        return pauseMode;
    }

    @Generated
    public static void setPauseMode(boolean pauseMode) {
        SerenityReporterCallbacks.pauseMode = pauseMode;
    }

    @Generated
    public int getScPassed() {
        return this.scPassed;
    }

    @Generated
    public int getScFailed() {
        return this.scFailed;
    }

    private static enum StepState {
        STARTED,
        FINISHED;

    }
}

