/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin.report;

import io.cucumber.core.plugin.report.Evidence;
import java.beans.ConstructorProperties;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import lombok.Generated;

public final class EvidenceReport {
    private final ReportContext context;
    private final List<Step> steps;

    @ConstructorProperties(value={"context", "steps"})
    @Generated
    public EvidenceReport(ReportContext context, List<Step> steps) {
        this.context = context;
        this.steps = steps;
    }

    @Generated
    public ReportContext getContext() {
        return this.context;
    }

    @Generated
    public List<Step> getSteps() {
        return this.steps;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EvidenceReport)) {
            return false;
        }
        EvidenceReport other = (EvidenceReport)o;
        ReportContext this$context = this.getContext();
        ReportContext other$context = other.getContext();
        if (this$context == null ? other$context != null : !((Object)this$context).equals(other$context)) {
            return false;
        }
        List<Step> this$steps = this.getSteps();
        List<Step> other$steps = other.getSteps();
        return !(this$steps == null ? other$steps != null : !((Object)this$steps).equals(other$steps));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ReportContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : ((Object)$context).hashCode());
        List<Step> $steps = this.getSteps();
        result = result * 59 + ($steps == null ? 43 : ((Object)$steps).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EvidenceReport(context=" + String.valueOf(this.getContext()) + ", steps=" + String.valueOf(this.getSteps()) + ")";
    }

    public static final class ReportContext {
        private final String scenario;
        private final URI feature;

        @ConstructorProperties(value={"scenario", "feature"})
        @Generated
        public ReportContext(String scenario, URI feature) {
            this.scenario = scenario;
            this.feature = feature;
        }

        @Generated
        public String getScenario() {
            return this.scenario;
        }

        @Generated
        public URI getFeature() {
            return this.feature;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ReportContext)) {
                return false;
            }
            ReportContext other = (ReportContext)o;
            String this$scenario = this.getScenario();
            String other$scenario = other.getScenario();
            if (this$scenario == null ? other$scenario != null : !this$scenario.equals(other$scenario)) {
                return false;
            }
            URI this$feature = this.getFeature();
            URI other$feature = other.getFeature();
            return !(this$feature == null ? other$feature != null : !((Object)this$feature).equals(other$feature));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $scenario = this.getScenario();
            result = result * 59 + ($scenario == null ? 43 : $scenario.hashCode());
            URI $feature = this.getFeature();
            result = result * 59 + ($feature == null ? 43 : ((Object)$feature).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EvidenceReport.ReportContext(scenario=" + this.getScenario() + ", feature=" + String.valueOf(this.getFeature()) + ")";
        }
    }

    public static final class Step {
        private final String name;
        private final List<Evidence> evidenceEntries;

        public Step(String name) {
            this.name = name;
            this.evidenceEntries = Collections.unmodifiableList(new ArrayList());
        }

        public Step addEntry(Evidence stepEvidenceToAdd) {
            return this.withEvidenceEntries(Stream.concat(this.evidenceEntries.stream(), Stream.of(stepEvidenceToAdd)).toList());
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public List<Evidence> getEvidenceEntries() {
            return this.evidenceEntries;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Step)) {
                return false;
            }
            Step other = (Step)o;
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            List<Evidence> this$evidenceEntries = this.getEvidenceEntries();
            List<Evidence> other$evidenceEntries = other.getEvidenceEntries();
            return !(this$evidenceEntries == null ? other$evidenceEntries != null : !((Object)this$evidenceEntries).equals(other$evidenceEntries));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            List<Evidence> $evidenceEntries = this.getEvidenceEntries();
            result = result * 59 + ($evidenceEntries == null ? 43 : ((Object)$evidenceEntries).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "EvidenceReport.Step(name=" + this.getName() + ", evidenceEntries=" + String.valueOf(this.getEvidenceEntries()) + ")";
        }

        @ConstructorProperties(value={"name", "evidenceEntries"})
        @Generated
        public Step(String name, List<Evidence> evidenceEntries) {
            this.name = name;
            this.evidenceEntries = evidenceEntries;
        }

        @Generated
        private Step withEvidenceEntries(List<Evidence> evidenceEntries) {
            return this.evidenceEntries == evidenceEntries ? this : new Step(this.name, evidenceEntries);
        }
    }
}

