/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import de.gematik.test.tiger.exceptions.FailMessageOverrider;
import io.cucumber.core.plugin.IScenarioContext;
import io.cucumber.core.plugin.ISerenityReporter;
import io.cucumber.core.plugin.report.SerenityReporterCallbacks;
import io.cucumber.core.runner.TestCaseDelegate;
import io.cucumber.plugin.EventListener;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.Result;
import io.cucumber.plugin.event.Status;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.net.URI;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerSerenityReporterPlugin
implements EventListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerSerenityReporterPlugin.class);
    private final ISerenityReporter serenityReporter = ISerenityReporter.create();
    private final SerenityReporterCallbacks reporterCallbacks = new SerenityReporterCallbacks();

    public IScenarioContext getContext(URI featureURI) {
        return this.serenityReporter.getContext(featureURI);
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this::handleTestRunStarted);
        publisher.registerHandlerFor(TestSourceRead.class, this::handleTestSourceRead);
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        publisher.registerHandlerFor(TestStepStarted.class, this::handleTestStepStarted);
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::handleTestRunFinished);
        publisher.registerHandlerFor(WriteEvent.class, this::handleWriteEvent);
    }

    public void handleTestRunStarted(TestRunStarted event) {
        this.reporterCallbacks.handleTestRunStarted((Event)event);
        this.serenityReporter.handleTestRunStarted(event);
    }

    public void handleTestSourceRead(TestSourceRead event) {
        this.serenityReporter.handleTestSourceRead(event);
        log.info("Feature file started: {}", (Object)event.getUri());
        this.reporterCallbacks.handleTestSourceRead((Event)event);
    }

    public void handleTestCaseStarted(TestCaseStarted event) {
        this.serenityReporter.handleTestCaseStarted(event);
        this.reporterCallbacks.handleTestCaseStarted(event, this.getContext(event.getTestCase().getUri()));
    }

    public void handleTestStepStarted(TestStepStarted event) {
        this.serenityReporter.handleTestStepStarted(event);
        this.reporterCallbacks.handleTestStepStarted(event, this.getContext(event.getTestCase().getUri()));
    }

    public void handleTestStepFinished(TestStepFinished event) {
        FailMessageOverrider.overrideFailureMessage(event);
        if (TestCaseDelegate.of(event.getTestCase()).isDryRun()) {
            event = new TestStepFinished(event.getInstant(), event.getTestCase(), event.getTestStep(), new Result(Status.SKIPPED, event.getResult().getDuration(), event.getResult().getError()));
        }
        this.reporterCallbacks.handleTestStepFinished(event, this.getContext(event.getTestCase().getUri()));
        this.serenityReporter.handleTestStepFinished(event);
    }

    public void handleTestCaseFinished(TestCaseFinished event) {
        if (TestCaseDelegate.of(event.getTestCase()).isDryRun()) {
            event = new TestCaseFinished(event.getInstant(), event.getTestCase(), new Result(Status.SKIPPED, event.getResult().getDuration(), event.getResult().getError()));
        }
        this.reporterCallbacks.handleTestCaseFinished(event, this.getContext(event.getTestCase().getUri()));
        this.serenityReporter.handleTestCaseFinished(event);
    }

    public void handleTestRunFinished(TestRunFinished event) {
        this.reporterCallbacks.handleTestRunFinished(event);
        this.serenityReporter.handleTestRunFinished(event);
    }

    public void handleWriteEvent(WriteEvent event) {
        this.serenityReporter.handleWriteEvent(event);
    }

    @Generated
    public SerenityReporterCallbacks getReporterCallbacks() {
        return this.reporterCallbacks;
    }
}

