/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import de.gematik.test.tiger.common.config.ConfigurationValuePrecedence;
import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import java.util.HashMap;
import java.util.Map;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;

public class TigerLauncherDiscoveryListener
implements LauncherDiscoveryListener {
    public void launcherDiscoveryStarted(LauncherDiscoveryRequest request) {
        TigerGlobalConfiguration.initialize();
        this.backupInitialConfigParameters(request.getConfigurationParameters());
        this.forceDryRun();
        TigerLauncherDiscoveryListener.setExampleNamingStrategy();
        this.setDefaultFilterTags(request.getConfigurationParameters());
    }

    private void setDefaultFilterTags(ConfigurationParameters configurationParameters) {
        if (configurationParameters.get("cucumber.filter.tags").isEmpty()) {
            System.setProperty("cucumber.filter.tags", "not @Ignore");
        }
    }

    private void backupInitialConfigParameters(ConfigurationParameters configurationParameters) {
        String cucumberConfigKey = TigerConfigurationKeys.CUCUMBER_ENGINE_RUNTIME_CONFIGURATION.downsampleKey();
        Map currentConfiguration = TigerGlobalConfiguration.readMap((String[])new String[]{cucumberConfigKey});
        if (currentConfiguration.isEmpty()) {
            HashMap newConfiguration = new HashMap();
            configurationParameters.keySet().stream().filter(key -> key.startsWith("cucumber.")).filter(key -> !"cucumber.features".equals(key)).forEach(key -> newConfiguration.put(key, (String)configurationParameters.get(key).orElseThrow()));
            TigerGlobalConfiguration.putValue((String)cucumberConfigKey, newConfiguration, (ConfigurationValuePrecedence)ConfigurationValuePrecedence.RUNTIME_EXPORT);
        }
    }

    private void forceDryRun() {
        boolean autoRunOnStart = (Boolean)TigerConfigurationKeys.RUN_TESTS_ON_START.getValueOrDefault();
        System.setProperty("cucumber.execution.dry-run", Boolean.toString(!autoRunOnStart));
    }

    private static void setExampleNamingStrategy() {
        if (System.getProperty("cucumber.junit-platform.naming-strategy.short.example-name") == null) {
            System.setProperty("cucumber.junit-platform.naming-strategy.short.example-name", "pickle");
        }
    }
}

