/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import io.cucumber.core.plugin.FeatureFileLoader;
import io.cucumber.core.plugin.TestSourcesModel;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.Scenario;
import io.cucumber.plugin.event.TestCase;
import java.net.URI;

public class SerenityUtils {
    private SerenityUtils() {
    }

    public static String scenarioIdFrom(FeatureFileLoader featureLoader, TestCase testCase) {
        URI featureUri = testCase.getUri();
        TestSourcesModel.AstNode node = featureLoader.getAstNode(featureUri, testCase.getLocation().getLine());
        Scenario scenario = TestSourcesModel.getScenarioDefinition((TestSourcesModel.AstNode)node);
        Feature feature = featureLoader.getFeature(featureUri);
        return SerenityUtils.scenarioIdFrom(feature.getName(), TestSourcesModel.convertToId((String)scenario.getName()));
    }

    private static String scenarioIdFrom(String featureId, String scenarioIdOrExampleId) {
        return featureId != null && scenarioIdOrExampleId != null ? String.format("%s;%s", featureId, scenarioIdOrExampleId) : "";
    }
}

