/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import de.gematik.test.tiger.lib.rbel.RbelContentValidator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import javax.xml.transform.Source;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;

public class RbelXmlContentValidator
implements RbelContentValidator {
    private static final Map<String, UnaryOperator<DiffBuilder>> DIFF_OPTIONS = new HashMap<String, UnaryOperator<DiffBuilder>>();

    @Override
    public void verify(String oracle, RbelElement el, String diffOptionCSV) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)el.hasFacet(RbelXmlFacet.class)).withFailMessage("Node " + String.valueOf(el.getKey()) + " is not XML", new Object[0])).isTrue();
        this.compareXMLStructure(oracle, el.getRawStringContent(), diffOptionCSV);
    }

    public void compareXMLStructure(String oracle, String test, String diffOptionCSV) {
        ArrayList<UnaryOperator<DiffBuilder>> diffOptions = new ArrayList<UnaryOperator<DiffBuilder>>();
        Arrays.stream(diffOptionCSV.split(",")).map(String::trim).forEach(srcClassId -> {
            Assertions.assertThat(DIFF_OPTIONS).containsKey(srcClassId);
            diffOptions.add(DIFF_OPTIONS.get(srcClassId));
        });
        this.compareXMLStructure(oracle, test, diffOptions);
    }

    public void compareXMLStructure(String test, String oracle, List<UnaryOperator<DiffBuilder>> diffOptions) {
        Source srcTest = Input.from((Object)test).build();
        Source srcOracle = Input.from((Object)oracle).build();
        DiffBuilder db = DiffBuilder.compare((Object)srcOracle).withTest((Object)srcTest);
        for (UnaryOperator<DiffBuilder> src : diffOptions) {
            db = (DiffBuilder)src.apply(db);
        }
        db = db.checkForSimilar();
        db.withDifferenceEvaluator((comparison, outcome) -> {
            if (outcome != ComparisonResult.EQUAL && (comparison.getType() == ComparisonType.NAMESPACE_URI || comparison.getType() == ComparisonType.NAMESPACE_PREFIX)) {
                return ComparisonResult.SIMILAR;
            }
            return outcome;
        });
        Diff diff = db.build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)diff.hasDifferences()).withFailMessage("XML tree mismatch!\n" + String.valueOf(diff), new Object[0])).isFalse();
    }

    public void compareXMLStructure(String test, String oracle) {
        this.compareXMLStructure(test, oracle, Collections.emptyList());
    }

    static {
        DIFF_OPTIONS.put("nocomment", DiffBuilder::ignoreComments);
        DIFF_OPTIONS.put("txtignoreempty", DiffBuilder::ignoreElementContentWhitespace);
        DIFF_OPTIONS.put("txttrim", DiffBuilder::ignoreWhitespace);
        DIFF_OPTIONS.put("txtnormalize", DiffBuilder::normalizeWhitespace);
    }
}

