/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.lib.json.JsonChecker;
import de.gematik.test.tiger.lib.rbel.ModeType;
import de.gematik.test.tiger.lib.rbel.RbelMessageNodeElementMatchExecutor;
import de.gematik.test.tiger.lib.rbel.RbelMessageRetriever;
import java.util.HashMap;
import java.util.List;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelValidator.class);

    public void assertAttributeOfCurrentResponseMatches(String rbelPath, String value, boolean shouldMatch, RbelMessageRetriever rbelMessageRetriever) {
        RbelMessageNodeElementMatchExecutor.builder().rbelPath(rbelPath).shouldMatch(shouldMatch).oracle(value).elements(rbelMessageRetriever.findElementsInCurrentResponse(rbelPath)).build().execute();
    }

    public void assertAttributeOfCurrentRequestMatches(String rbelPath, String value, boolean shouldMatch, RbelMessageRetriever rbelMessageRetriever) {
        RbelMessageNodeElementMatchExecutor.builder().rbelPath(rbelPath).shouldMatch(shouldMatch).oracle(value).elements(rbelMessageRetriever.findElementsInCurrentRequest(rbelPath)).build().execute();
    }

    public void assertAttributeOfCurrentResponseMatchesAs(String rbelPath, ModeType mode, String oracle, String diffOptionCsv, RbelMessageRetriever rbelMessageRetriever) {
        this.assertAttributeForMessagesMatchAs(mode, oracle, rbelMessageRetriever.findElementsInCurrentResponse(rbelPath), diffOptionCsv);
    }

    public void assertAttributeOfCurrentRequestMatchesAs(String rbelPath, ModeType mode, String oracle, RbelMessageRetriever rbelMessageRetriever) {
        this.assertAttributeForMessagesMatchAs(mode, oracle, rbelMessageRetriever.findElementsInCurrentRequest(rbelPath), "");
    }

    public void assertAttributeForMessagesMatchAs(ModeType mode, String oracle, List<RbelElement> elements, String diffOptionCSV) {
        HashMap<String, Object> exceptions = new HashMap<String, Object>();
        for (RbelElement element : elements) {
            try {
                mode.verify(oracle, element, diffOptionCSV);
                log.debug("Found matching element: \n{}", (Object)element.printTreeStructure());
                return;
            }
            catch (JsonChecker.JsonCheckerMismatchException | AssertionError e) {
                exceptions.put(element.getUuid(), e);
            }
        }
        if (elements.size() == 1) {
            RbelElement element = elements.get(0);
            throw new AssertionError((Object)String.format("Element value:\n%s\nExpected:\n%s\nValidation message:\n%s", element.getRawStringContent(), oracle, exceptions.get(element.getUuid())));
        }
        throw new AssertionError((Object)String.format("No matching element for value %s found in list of %d elements! ", oracle, elements.size()));
    }
}

