/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.lib.rbel.RbelMessageRetriever;
import java.beans.ConstructorProperties;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelMessageNodeElementMatchExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMessageNodeElementMatchExecutor.class);
    private final String rbelPath;
    private final String oracle;
    private final boolean shouldMatch;
    private final List<RbelElement> elements;
    @Nullable
    private Pattern regexPattern;
    private boolean foundMatchingNode;

    public void execute() {
        ((AbstractStringAssert)Assertions.assertThat((String)this.oracle).withFailMessage("Matching string must not be empty for rbel path {}", new Object[]{this.rbelPath})).isNotBlank();
        this.compileRegexPattern();
        for (RbelElement element : this.elements) {
            if (this.foundMatchingNode) break;
            this.doesThisElementMatch(element);
        }
        if (this.shouldMatch && !this.foundMatchingNode) {
            if (this.elements.size() == 1) {
                throw new AssertionError((Object)("Element value:\n" + this.elements.get(0).getRawStringContent() + "\nExpected:\n" + this.oracle));
            }
            throw new AssertionError((Object)String.format("Expected that nodes to rbel path '%s' are equal to or match '%s'", this.rbelPath, this.oracle));
        }
    }

    private void compileRegexPattern() {
        try {
            this.regexPattern = Pattern.compile(this.oracle, 40);
        }
        catch (PatternSyntaxException pse) {
            log.atTrace().addArgument((Object)this.oracle).addArgument(pse::getMessage).log("Ignoring oracle '{}' as regex-pattern, error while compiling: '{}'");
        }
    }

    private void doesThisElementMatch(RbelElement element) {
        boolean itMatches;
        String text = RbelMessageRetriever.getValueOrContentString(element);
        boolean bl = itMatches = text.equals(this.oracle) || this.regexPattern != null && this.regexPattern.matcher(text).matches();
        if (this.shouldMatch) {
            if (itMatches) {
                this.foundMatchingNode = true;
            }
        } else if (itMatches) {
            throw new AssertionError((Object)String.format("Did not expect that value '%s' of node '%s' is equal to or matches '%s'", text, this.rbelPath, this.oracle));
        }
    }

    @Generated
    public static RbelMessageNodeElementMatchExecutorBuilder builder() {
        return new RbelMessageNodeElementMatchExecutorBuilder();
    }

    @ConstructorProperties(value={"rbelPath", "oracle", "shouldMatch", "elements"})
    @Generated
    public RbelMessageNodeElementMatchExecutor(String rbelPath, String oracle, boolean shouldMatch, List<RbelElement> elements) {
        this.rbelPath = rbelPath;
        this.oracle = oracle;
        this.shouldMatch = shouldMatch;
        this.elements = elements;
    }

    @ConstructorProperties(value={"rbelPath", "oracle", "shouldMatch", "elements", "regexPattern", "foundMatchingNode"})
    @Generated
    public RbelMessageNodeElementMatchExecutor(String rbelPath, String oracle, boolean shouldMatch, List<RbelElement> elements, @Nullable Pattern regexPattern, boolean foundMatchingNode) {
        this.rbelPath = rbelPath;
        this.oracle = oracle;
        this.shouldMatch = shouldMatch;
        this.elements = elements;
        this.regexPattern = regexPattern;
        this.foundMatchingNode = foundMatchingNode;
    }

    @Generated
    public static class RbelMessageNodeElementMatchExecutorBuilder {
        @Generated
        private String rbelPath;
        @Generated
        private String oracle;
        @Generated
        private boolean shouldMatch;
        @Generated
        private List<RbelElement> elements;
        @Generated
        private Pattern regexPattern;
        @Generated
        private boolean foundMatchingNode;

        @Generated
        RbelMessageNodeElementMatchExecutorBuilder() {
        }

        @Generated
        public RbelMessageNodeElementMatchExecutorBuilder rbelPath(String rbelPath) {
            this.rbelPath = rbelPath;
            return this;
        }

        @Generated
        public RbelMessageNodeElementMatchExecutorBuilder oracle(String oracle) {
            this.oracle = oracle;
            return this;
        }

        @Generated
        public RbelMessageNodeElementMatchExecutorBuilder shouldMatch(boolean shouldMatch) {
            this.shouldMatch = shouldMatch;
            return this;
        }

        @Generated
        public RbelMessageNodeElementMatchExecutorBuilder elements(List<RbelElement> elements) {
            this.elements = elements;
            return this;
        }

        @Generated
        public RbelMessageNodeElementMatchExecutorBuilder regexPattern(@Nullable Pattern regexPattern) {
            this.regexPattern = regexPattern;
            return this;
        }

        @Generated
        public RbelMessageNodeElementMatchExecutorBuilder foundMatchingNode(boolean foundMatchingNode) {
            this.foundMatchingNode = foundMatchingNode;
            return this;
        }

        @Generated
        public RbelMessageNodeElementMatchExecutor build() {
            return new RbelMessageNodeElementMatchExecutor(this.rbelPath, this.oracle, this.shouldMatch, this.elements, this.regexPattern, this.foundMatchingNode);
        }

        @Generated
        public String toString() {
            return "RbelMessageNodeElementMatchExecutor.RbelMessageNodeElementMatchExecutorBuilder(rbelPath=" + this.rbelPath + ", oracle=" + this.oracle + ", shouldMatch=" + this.shouldMatch + ", elements=" + String.valueOf(this.elements) + ", regexPattern=" + String.valueOf(this.regexPattern) + ", foundMatchingNode=" + this.foundMatchingNode + ")";
        }
    }
}

