/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaFactory;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.ValidationMessage;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.exceptions.GenericTigerException;
import de.gematik.test.tiger.lib.json.AbstractRbelJsonChecker;
import java.util.Set;
import java.util.stream.Collectors;

public class JsonSchemaChecker
extends AbstractRbelJsonChecker {
    private final ObjectMapper objectMapper = new ObjectMapper();

    @Override
    public void verify(String oracle, RbelElement element, String diffOptionCSV) {
        this.compareJsonToSchema(this.getAsJsonString(element), oracle);
    }

    public void compareJsonToSchema(String jsonToCheck, String schema) {
        try {
            JsonNode jsonNode = this.objectMapper.readTree(jsonToCheck);
            JsonNode schemaNode = this.objectMapper.readTree(schema);
            JsonSchemaFactory factory = JsonSchemaFactory.getInstance((SpecVersion.VersionFlag)SpecVersion.VersionFlag.V202012);
            JsonSchema jsonSchema = factory.getSchema(schemaNode);
            Set errors = jsonSchema.validate(jsonNode);
            if (!errors.isEmpty()) {
                String errorMessages = errors.stream().map(ValidationMessage::toString).collect(Collectors.joining("\n  "));
                throw new JsonSchemaAssertionError("JSON schema validation failed:\n  " + errorMessages);
            }
        }
        catch (JsonProcessingException e) {
            throw new JsonSchemaProcessingError("Failed to process input json and/or input schema", e);
        }
    }

    public static class JsonSchemaAssertionError
    extends AssertionError {
        public JsonSchemaAssertionError(String message) {
            super((Object)message);
        }
    }

    public static class JsonSchemaProcessingError
    extends GenericTigerException {
        public JsonSchemaProcessingError(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

