/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.json;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.exceptions.GenericTigerException;
import de.gematik.test.tiger.lib.json.AbstractRbelJsonChecker;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import net.serenitybdd.annotations.Step;
import org.apache.commons.collections.IteratorUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.skyscreamer.jsonassert.Customization;
import org.skyscreamer.jsonassert.JSONAssert;
import org.skyscreamer.jsonassert.JSONCompareMode;
import org.skyscreamer.jsonassert.JSONCompareResult;
import org.skyscreamer.jsonassert.ValueMatcher;
import org.skyscreamer.jsonassert.comparator.CustomComparator;
import org.skyscreamer.jsonassert.comparator.JSONComparator;

public class JsonChecker
extends AbstractRbelJsonChecker {
    public static final String IGNORE_JSON_VALUE = "${json-unit.ignore}";
    private static final String OPTIONAL_MARKER = "____";
    private static final String NULL_MARKER = "$NULL";
    final CustomComparator customComparator = new JsonCheckerComparator();

    @Override
    public void verify(String oracle, RbelElement element, String diffOptionCSV) {
        this.compareJsonStrings(this.getAsJsonString(element), oracle, false);
    }

    @Step
    public void compareJsonStrings(String jsonStr, String oracleStr, boolean checkExtraAttributes) {
        JSONTokener jsonTokener = new JSONTokener(jsonStr);
        JSONTokener oracleTokener = new JSONTokener(oracleStr);
        Object jsonValue = jsonTokener.nextValue();
        Object oracleValue = oracleTokener.nextValue();
        this.compareJsonStrings(jsonValue, oracleValue, checkExtraAttributes);
    }

    public void compareJsonStrings(Object jsonValue, Object oracleValue, boolean checkExtraAttributes) {
        if (NULL_MARKER.equals(oracleValue) && jsonValue == JSONObject.NULL || NULL_MARKER.equals(jsonValue) && oracleValue == JSONObject.NULL) {
            return;
        }
        if (!jsonValue.getClass().equals(oracleValue.getClass())) {
            throw new JsonCheckerMismatchException(String.format("Could not compare %s to %s: Different types!", jsonValue.getClass().getSimpleName(), oracleValue.getClass().getSimpleName()));
        }
        if (jsonValue instanceof JSONObject) {
            JSONObject jsonObject = (JSONObject)jsonValue;
            this.assertJsonObjectShouldMatchOrContainInAnyOrder(jsonObject, (JSONObject)oracleValue, checkExtraAttributes);
        } else if (jsonValue instanceof JSONArray) {
            JSONArray jsonArray = (JSONArray)jsonValue;
            this.assertJsonArrayShouldMatchInAnyOrder(jsonArray.toString(), oracleValue.toString(), checkExtraAttributes);
        } else {
            this.compareValues(jsonValue, oracleValue);
        }
    }

    @Step
    public void assertJsonArrayShouldMatchInAnyOrder(String json, String oracle) {
        this.assertJsonArrayShouldMatchInAnyOrder(json, oracle, true);
    }

    public void assertJsonArrayShouldMatchInAnyOrder(String json, String oracle, boolean checkExtraAttributes) {
        JSONAssert.assertEquals((String)oracle, (String)json, (JSONComparator)new CustomComparator(JSONCompareMode.LENIENT, new Customization[]{new Customization("***", (testJson, oracleJson) -> {
            if (testJson instanceof JSONObject) {
                this.assertJsonObjectShouldMatchOrContainInAnyOrder(testJson.toString(), oracleJson.toString(), checkExtraAttributes);
                return true;
            }
            if (testJson instanceof JSONArray) {
                this.assertJsonArrayShouldMatchInAnyOrder(testJson.toString(), oracleJson.toString(), checkExtraAttributes);
                return true;
            }
            return IGNORE_JSON_VALUE.equals(oracleJson) || testJson.toString().equals(oracleJson.toString()) || testJson.toString().matches(oracleJson.toString());
        })}));
    }

    @Step
    public void assertJsonObjectShouldMatchOrContainInAnyOrder(String jsonStr, String oracleStr, boolean checkExtraAttributes) {
        JSONObject json = this.convertToJsonObject(jsonStr);
        JSONObject oracle = this.convertToJsonObject(oracleStr);
        this.assertJsonObjectShouldMatchOrContainInAnyOrder(json, oracle, checkExtraAttributes);
    }

    public void assertJsonObjectShouldMatchOrContainInAnyOrder(JSONObject json, JSONObject oracle, boolean checkExtraAttributes) {
        try {
            Optional<JsonCheckerMismatchException> checkerMismatchException;
            for (String oracleKey : oracle.keySet()) {
                if (!this.keyNotContainedInSetOrOptional(oracleKey, json.keySet())) continue;
                throw new JsonCheckerMismatchException("Expected JSON to have key '" + oracleKey + "', but only found keys '" + String.valueOf(json.keySet()) + "'");
            }
            if (checkExtraAttributes && (checkerMismatchException = json.keySet().stream().filter(key -> this.keyNotContainedInSetOrOptional((String)key, oracle.keySet())).findAny().map(key -> new JsonCheckerMismatchException("EXTRA Key " + key + " detected in received in JSON"))).isPresent()) {
                throw checkerMismatchException.get();
            }
            this.compareAllAttributes(json, oracle);
        }
        catch (NoSuchMethodError nsme) {
            throw new JsonCheckerMismatchException(this.dumpComparisonBetween("JSON does not match!\nExpected:\n%s\n\n--------\n\nReceived:\n%s", oracle.toString(2), json.toString(2)), nsme);
        }
    }

    private boolean keyNotContainedInSetOrOptional(String oracleKey, Set<String> keySet) {
        if (oracleKey.startsWith(OPTIONAL_MARKER)) {
            return false;
        }
        return keySet.stream().map(key -> StringUtils.stripStart((String)key, (String)OPTIONAL_MARKER)).noneMatch(oracleKey::equals);
    }

    private Optional<Object> findTargetByKey(JSONObject json, String jsonKey) {
        return json.keySet().stream().filter(key -> StringUtils.stripStart((String)key, (String)OPTIONAL_MARKER).equals(StringUtils.stripStart((String)jsonKey, (String)OPTIONAL_MARKER))).map(arg_0 -> ((JSONObject)json).get(arg_0)).findAny();
    }

    private JSONObject convertToJsonObject(String jsonStr) {
        try {
            return new JSONObject(jsonStr);
        }
        catch (RuntimeException e) {
            throw new JsonCheckerConversionException(jsonStr, e);
        }
    }

    private void compareAllAttributes(JSONObject json, JSONObject oracle) {
        Iterator keyIt = oracle.keys();
        while (keyIt.hasNext()) {
            String oracleKey = (String)keyIt.next();
            Optional<Object> jsonTargetOptional = this.findTargetByKey(json, oracleKey);
            Optional<Object> oracleTargetOptional = this.findTargetByKey(oracle, oracleKey);
            if (jsonTargetOptional.isEmpty() && oracleKey.startsWith(OPTIONAL_MARKER) || oracleTargetOptional.isEmpty() && oracleKey.startsWith(OPTIONAL_MARKER)) continue;
            Object jsonTarget = jsonTargetOptional.orElseThrow(() -> new JsonCheckerMismatchException("Could not find attribute by key '" + oracleKey + "' in '" + String.valueOf(json) + "'"));
            Object oracleTarget = oracleTargetOptional.orElseThrow(() -> new JsonCheckerMismatchException("Could not find attribute by key '" + oracleKey + "' in '" + String.valueOf(oracle) + "'"));
            try {
                this.compareValues(jsonTarget, oracleTarget);
            }
            catch (AssertionError e) {
                throw new JsonCheckerMismatchException("Comparison failed at key '" + oracleKey + "'", (Throwable)((Object)e));
            }
        }
    }

    private void compareValues(Object jsonTarget, Object oracleTarget) {
        if (NULL_MARKER.equals(oracleTarget) && jsonTarget == JSONObject.NULL || NULL_MARKER.equals(jsonTarget) && oracleTarget == JSONObject.NULL) {
            return;
        }
        if (IGNORE_JSON_VALUE.equals(oracleTarget)) {
            return;
        }
        if (!(oracleTarget instanceof String) && !jsonTarget.getClass().equals(oracleTarget.getClass())) {
            throw new JsonCheckerMismatchException("Expected an '" + oracleTarget.getClass().getSimpleName() + "', but found '" + jsonTarget.getClass().getSimpleName() + "'");
        }
        if (oracleTarget instanceof JSONObject) {
            this.assertJsonObjectShouldMatchOrContainInAnyOrder(jsonTarget.toString(), oracleTarget.toString(), true);
        } else if (oracleTarget instanceof JSONArray) {
            JSONAssert.assertEquals((String)oracleTarget.toString(), (String)jsonTarget.toString(), (JSONComparator)this.customComparator);
        } else {
            String jsoValue = jsonTarget.toString();
            if (!jsoValue.equals(oracleTarget)) {
                try {
                    ((AbstractStringAssert)Assertions.assertThat((String)jsoValue).withFailMessage(this.dumpComparisonAtKeyDiffer(oracleTarget.toString(), jsoValue), new Object[0])).matches((CharSequence)oracleTarget.toString());
                }
                catch (RuntimeException ex) {
                    throw new JsonCheckerMismatchException(this.dumpComparisonAtKeyDiffer(oracleTarget.toString(), jsoValue));
                }
            }
        }
    }

    @Step
    public void assertJsonAttributeShouldMatch(JSONObject json, String claimName, String regex) {
        block7: {
            if (regex != null && regex.equals("$REMOVE")) {
                Assertions.assertThat((Object[])IteratorUtils.toArray((Iterator)json.keys())).doesNotContain(new Object[]{claimName});
                return;
            }
            Assertions.assertThat((Object[])IteratorUtils.toArray((Iterator)json.keys())).contains(new Object[]{claimName});
            if (regex == null) {
                if (json.get(claimName) != JSONObject.NULL) {
                    Assertions.assertThat((Object)json.get(claimName)).isNull();
                }
                return;
            }
            String jsoValue = json.get(claimName).toString();
            if (jsoValue.equals(regex)) break block7;
            try {
                ((AbstractStringAssert)Assertions.assertThat((String)jsoValue).withFailMessage(this.dumpComparisonAtKeyDiffer(regex, jsoValue), new Object[0])).matches((CharSequence)regex);
            }
            catch (AssertionError e) {
                throw new JsonCheckerMismatchException("Assertion failed at key '" + claimName + "'", (Throwable)((Object)e));
            }
        }
    }

    @Step
    public void assertJsonAttributeShouldNotMatch(JSONObject json, String claimName, String regex) {
        Assertions.assertThat((Object[])IteratorUtils.toArray((Iterator)json.keys())).contains(new Object[]{claimName});
        if (regex == null) {
            Assertions.assertThat((Object)json.get(claimName)).isNotEqualTo(JSONObject.NULL);
            Assertions.assertThat((Object)json.get(claimName)).isNotNull();
        } else {
            String jsoValue = json.get(claimName).toString();
            if (!jsoValue.equals(regex)) {
                ((AbstractStringAssert)Assertions.assertThat((String)jsoValue).withFailMessage(this.dumpComparisonAtKeyDiffer(regex, jsoValue), new Object[0])).doesNotMatch((CharSequence)regex);
            } else {
                Assertions.fail((String)this.dumpComparisonAtKeyDiffer(regex, jsoValue));
            }
        }
    }

    private String dumpComparisonAtKeyDiffer(String expected, String received) {
        return this.dumpComparisonBetween("JSON object does match\nExpected:\n%s\n\n--------\n\nReceived:\n%s", expected, received);
    }

    private String dumpComparisonBetween(String pattern, String expected, String received) {
        return String.format(pattern, expected, received);
    }

    private class JsonCheckerComparator
    extends CustomComparator {
        public JsonCheckerComparator() {
            super(JSONCompareMode.LENIENT, new Customization[]{new Customization("***", (ValueMatcher)new CustomValueMatcher())});
        }

        protected void compareJSONArrayOfJsonObjects(String key, JSONArray expected, JSONArray actual, JSONCompareResult result) throws JSONException {
            if (expected.length() == 1 && actual.length() == 1) {
                this.compareJSON(expected.getJSONObject(0), actual.getJSONObject(0));
                return;
            }
            super.compareJSONArrayOfJsonObjects(key, expected, actual, result);
        }
    }

    public static class JsonCheckerMismatchException
    extends GenericTigerException {
        public JsonCheckerMismatchException(String s) {
            super(s);
        }

        public JsonCheckerMismatchException(String s, Throwable e) {
            super(s, e);
        }
    }

    static class JsonCheckerConversionException
    extends GenericTigerException {
        public JsonCheckerConversionException(String failingJsonString, Exception e) {
            super("Exception while trying to convert '" + failingJsonString + "' to JSON-Object", (Throwable)e);
        }
    }

    private class CustomValueMatcher
    implements ValueMatcher<Object> {
        private CustomValueMatcher() {
        }

        public boolean equal(Object testJson, Object oracleJson) {
            JsonChecker.this.compareJsonStrings(testJson, oracleJson, true);
            return true;
        }
    }
}

