/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.test.tiger.RbelLoggerWriter;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.TigerLibConfig;
import de.gematik.test.tiger.lib.rbel.ModeType;
import io.cucumber.java.ParameterType;
import io.restassured.http.Method;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TigerParameterTypeDefinitions {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static RbelLoggerWriter rbelLoggerWriter;
    private static final List<String> resolvedVariableTypeNames;

    public static boolean isResolvedVariableType(String typeName) {
        return resolvedVariableTypeNames.contains(typeName);
    }

    protected TigerParameterTypeDefinitions() {
    }

    @ParameterType(value="GET|POST|DELETE|PUT|OPTIONS|\".*\"|'.*'")
    public static Method requestType(String name) {
        return Method.valueOf((String)TigerParameterTypeDefinitions.resolveToString(name));
    }

    @ParameterType(value="XML|JSON|\".*\"|'.*'")
    public static ModeType modeType(String mode) {
        return ModeType.valueOf(TigerParameterTypeDefinitions.resolveToString(mode));
    }

    @ParameterType(value="\".*\"|'.*'")
    public static String tigerResolvedString(String string) {
        return TigerParameterTypeDefinitions.resolveToString(string);
    }

    @ParameterType(value="\".*\"|'.*'")
    @NotNull
    public static URI tigerResolvedUrl(String address) {
        return new URI(TigerParameterTypeDefinitions.resolveToString(address));
    }

    @ParameterType(value="XML|JSON|JWE|JWT|BEARER_TOKEN|URL|\".*\"|'.*'")
    public static RbelContentType rbelContentType(String value) {
        return RbelContentType.seekValueFor((String)TigerParameterTypeDefinitions.resolveToString(value));
    }

    private static String resolveToString(String value) {
        if (value.charAt(0) == '\"' || value.charAt(0) == '\'') {
            return TigerParameterTypeDefinitions.resolve(value.substring(1, value.length() - 1)).getContentAsString();
        }
        return TigerParameterTypeDefinitions.resolve(value).getContentAsString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RbelSerializationResult resolve(String value) {
        Class<TigerParameterTypeDefinitions> clazz = TigerParameterTypeDefinitions.class;
        synchronized (TigerParameterTypeDefinitions.class) {
            if (rbelLoggerWriter == null) {
                rbelLoggerWriter = new RbelLoggerWriter();
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            String resolvedInput = TigerGlobalConfiguration.resolvePlaceholders((String)value);
            TigerLibConfig libConfig = TigerDirector.getLibConfig();
            if (libConfig != null && libConfig.getHttpClientConfig().isActivateRbelWriter()) {
                RbelElement input = rbelLoggerWriter.getRbelConverter().convertElement(resolvedInput, null);
                return rbelLoggerWriter.getRbelWriter().serialize(input, new TigerJexlContext().withRootElement((Object)input));
            }
            return RbelSerializationResult.withUnknownType((byte[])resolvedInput.getBytes(DEFAULT_CHARSET));
        }
    }

    static {
        resolvedVariableTypeNames = List.of("tigerResolvedString", "tigerResolvedUrl");
    }
}

