/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.glue.ResolvableArgument;
import de.gematik.test.tiger.lib.TigerHttpClient;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.When;
import io.restassured.RestAssured;
import io.restassured.config.RedirectConfig;
import io.restassured.http.Method;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGlueCode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpGlueCode.class);

    @When(value="TGR send empty {requestType} request to {tigerResolvedUrl}")
    @Wenn(value="TGR eine leere {requestType} Anfrage an {tigerResolvedUrl} sendet")
    @Dann(value="TGR sende eine leere {requestType} Anfrage an {tigerResolvedUrl}")
    public void sendEmptyRequest(Method method, URI address) {
        log.info("Sending empty {} request to {}", (Object)method, (Object)address);
        TigerHttpClient.executeCommandWithContingentWait(() -> TigerHttpClient.givenDefaultSpec().request(method, address));
    }

    @When(value="TGR send empty {requestType} request to {tigerResolvedUrl} without waiting for the response")
    @Dann(value="TGR sende eine leere {requestType} Anfrage an {tigerResolvedUrl} ohne auf Antwort zu warten")
    public void sendEmptyRequestNonBlocking(Method method, URI address) {
        log.info("Sending empty non-blocking {} request to {}", (Object)method, (Object)address);
        TigerHttpClient.executeCommandInBackground(() -> TigerHttpClient.givenDefaultSpec().request(method, address));
    }

    @When(value="TGR send empty {requestType} request to {tigerResolvedUrl} with headers:")
    @Wenn(value="TGR eine leere {requestType} Anfrage an {tigerResolvedUrl} und den folgenden Headern sendet:")
    @Dann(value="TGR sende eine leere {requestType} Anfrage an {tigerResolvedUrl} mit folgenden Headern:")
    @ResolvableArgument
    public void sendEmptyRequestWithHeaders(Method method, URI address, DataTable customHeaders) {
        log.info("Sending empty {} request with headers to {}", (Object)method, (Object)address);
        Map defaultHeaders = TigerGlobalConfiguration.readMap((String[])new String[]{"tiger", "httpClient", "defaultHeader"});
        defaultHeaders.putAll(this.resolveMap(customHeaders.asMap(), false));
        TigerHttpClient.executeCommandWithContingentWait(() -> TigerHttpClient.givenDefaultSpec().headers(defaultHeaders).request(method, address));
    }

    @When(value="TGR send empty {requestType} request to {tigerResolvedUrl} without waiting for the response with headers:")
    @Dann(value="TGR sende eine leere {requestType} Anfrage an {tigerResolvedUrl} ohne auf Antwort zu warten mit folgenden Headern:")
    @ResolvableArgument
    public void sendEmptyRequestWithHeadersNonBlocking(Method method, URI address, DataTable customHeaders) {
        log.info("Sending empty {} non-blocking request with headers to {}", (Object)method, (Object)address);
        Map defaultHeaders = TigerGlobalConfiguration.readMap((String[])new String[]{"tiger", "httpClient", "defaultHeader"});
        defaultHeaders.putAll(this.resolveMap(customHeaders.asMap(), false));
        TigerHttpClient.executeCommandInBackground(() -> TigerHttpClient.givenDefaultSpec().headers(defaultHeaders).request(method, address));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with body {string}")
    @Wenn(value="TGR eine leere {requestType} Anfrage an {tigerResolvedUrl} und dem folgenden body {string} sendet")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit Body {string}")
    public void sendRequestWithBody(Method method, URI address, String body) {
        log.info("Sending {} request with body to {}", (Object)method, (Object)address);
        TigerHttpClient.executeCommandWithContingentWait(() -> TigerHttpClient.sendResolvedBody(method, address, body));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with body {string} without waiting for the response")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit Body {string} ohne auf Antwort zu warten")
    public void sendRequestWithBodyNonBlocking(Method method, URI address, String body) {
        log.info("Sending {} non-blocking request with body to {}", (Object)method, (Object)address);
        TigerHttpClient.executeCommandInBackground(() -> TigerHttpClient.sendResolvedBody(method, address, body));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with:")
    @Wenn(value="TGR eine {requestType} Anfrage an {tigerResolvedUrl} mit den folgenden Daten sendet:")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit folgenden Daten:")
    @ResolvableArgument
    public void sendRequestWithParams(Method method, URI address, DataTable parameters) {
        List dataAsMaps = parameters.asMaps();
        if (dataAsMaps.size() != 1) {
            throw new AssertionError((Object)("Expected exactly one entry for data table, got " + dataAsMaps.size()));
        }
        TigerHttpClient.executeCommandWithContingentWait(() -> TigerHttpClient.givenDefaultSpec().formParams(this.resolveMap((Map)dataAsMaps.get(0), true)).request(method, address));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with multiline body:")
    @Wenn(value="TGR eine {requestType} Anfrage an {tigerResolvedUrl} mit den folgenden mehrzeiligen Daten sendet:")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit folgenden mehrzeiligen Daten:")
    @ResolvableArgument
    public void sendRequestWithMultiLineBody(Method method, URI address, String body) {
        log.info("Sending complex {} request with body to {}", (Object)method, (Object)address);
        TigerHttpClient.executeCommandWithContingentWait(() -> TigerHttpClient.sendResolvedBody(method, address, body));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with contentType {string} and multiline body:")
    @Wenn(value="TGR eine {requestType} Anfrage an {tigerResolvedUrl} mit ContentType {string} und den folgenden mehrzeiligen Daten sendet:")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit ContentType {string} und folgenden mehrzeiligen Daten:")
    @ResolvableArgument
    public void sendRequestWithMultiLineBody(Method method, URI address, String contentType, String body) {
        log.info("Sending complex {} request with body to {}", (Object)method, (Object)address);
        TigerHttpClient.executeCommandWithContingentWait(() -> TigerHttpClient.sendResolvedBody(method, address, contentType, body));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} without waiting for the response with:")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} ohne auf Antwort zu warten mit folgenden Daten:")
    @ResolvableArgument
    public void sendRequestWithParamsNonBlocking(Method method, URI address, DataTable parameters) {
        List dataAsMaps = parameters.asMaps();
        if (dataAsMaps.size() != 1) {
            throw new AssertionError((Object)("Expected exactly one entry for data table, got " + dataAsMaps.size()));
        }
        TigerHttpClient.executeCommandInBackground(() -> TigerHttpClient.givenDefaultSpec().formParams(this.resolveMap((Map)dataAsMaps.get(0), true)).request(method, address));
    }

    @When(value="TGR set default header {tigerResolvedString} to {tigerResolvedString}")
    @Wenn(value="TGR den default header {tigerResolvedString} auf den Wert {tigerResolvedString} setzen")
    @Dann(value="TGR setze den default header {tigerResolvedString} auf den Wert {tigerResolvedString}")
    public void setDefaultHeader(String header, String value) {
        TigerGlobalConfiguration.putValue((String)("tiger.httpClient.defaultHeader." + header), (String)value);
    }

    @When(value="TGR set default headers:")
    @Dann(value="TGR setze folgende default headers:")
    @Wenn(value="TGR folgende default headers gesetzt werden:")
    @ResolvableArgument
    public void setDefaultHeaders(String docstring) {
        Arrays.stream(docstring.split("\n")).filter(line -> !line.isEmpty()).filter(line -> line.contains("=")).map(line -> List.of(StringUtils.substringBefore((String)line, (String)"="), StringUtils.substringAfter((String)line, (String)"="))).forEach(kvp -> TigerGlobalConfiguration.putValue((String)("tiger.httpClient.defaultHeader." + TigerHttpClient.resolveToString((String)kvp.get(0)).trim()), (String)TigerHttpClient.resolveToString((String)kvp.get(1)).trim()));
    }

    @When(value="TGR clear all default headers")
    @Wenn(value="TGR l\u00f6sche alle default headers")
    public void clearDefaultHeaders() {
        TigerGlobalConfiguration.readMap((String[])new String[]{"tiger", "httpClient", "defaultHeader"}).forEach((key, value) -> TigerGlobalConfiguration.listSources().stream().sorted(Comparator.comparing(source -> source.getPrecedence().getValue())).forEach(source -> source.removeValue(new TigerConfigurationKey(new String[]{"tiger", "httpClient", "defaultHeader", key}))));
    }

    @When(value="TGR disable HttpClient followRedirects configuration")
    @Wenn(value="TGR HttpClient followRedirects Konfiguration deaktiviert")
    public void disableHttpClientFollowRedirects() {
        RedirectConfig newRedirectConfig = RestAssured.config.getRedirectConfig().followRedirects(false);
        TigerHttpClient.applyRedirectConfig(newRedirectConfig);
    }

    @When(value="TGR reset HttpClient followRedirects configuration")
    @Wenn(value="TGR HttpClient followRedirects Konfiguration zur\u00fccksetzt")
    public void resetHttpClientRedirectConfiguration() {
        TigerHttpClient.resetRedirectConfig();
    }

    private Map<String, String> resolveMap(Map<String, String> map, boolean encoded) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> TigerHttpClient.resolveToString((String)entry.getKey()), entry -> encoded ? URLEncoder.encode(TigerHttpClient.resolveToString((String)entry.getValue()), StandardCharsets.UTF_8) : TigerHttpClient.resolveToString((String)entry.getValue())));
    }
}

