/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin.report;

import io.cucumber.core.plugin.report.Evidence;
import io.cucumber.core.plugin.report.EvidenceReport;
import io.cucumber.core.plugin.report.ReportStepConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

public class EvidenceRecorder {
    private List<EvidenceReport.Step> steps;

    EvidenceRecorder() {
        this.reset();
    }

    void reset() {
        this.steps = new ArrayList<EvidenceReport.Step>();
    }

    void openStepContext(ReportStepConfiguration stepConfiguration) {
        this.steps.add(new EvidenceReport.Step(stepConfiguration.getStepName()));
    }

    public void recordEvidence(Evidence stepEvidence) {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("No step opened in EvidenceRecorder yet");
        }
        int lastIndex = this.steps.size() - 1;
        EvidenceReport.Step lastReportStep = this.steps.get(lastIndex);
        this.steps.set(lastIndex, lastReportStep.addEntry(stepEvidence));
    }

    EvidenceReport getEvidenceReportForScenario(EvidenceReport.ReportContext reportContext) {
        return new EvidenceReport(reportContext, Collections.unmodifiableList(this.steps));
    }

    Optional<EvidenceReport.Step> getCurrentStep() {
        if (this.steps.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.steps.get(this.steps.size() - 1));
    }
}

