/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import de.gematik.test.tiger.exceptions.FailMessageOverrider;
import io.cucumber.core.plugin.ScenarioContextDelegate;
import io.cucumber.core.plugin.SerenityReporter;
import io.cucumber.core.plugin.report.SerenityReporterCallbacks;
import io.cucumber.core.runner.TestCaseDelegate;
import io.cucumber.plugin.event.Event;
import io.cucumber.plugin.event.EventPublisher;
import io.cucumber.plugin.event.TestCaseFinished;
import io.cucumber.plugin.event.TestCaseStarted;
import io.cucumber.plugin.event.TestRunFinished;
import io.cucumber.plugin.event.TestRunStarted;
import io.cucumber.plugin.event.TestSourceRead;
import io.cucumber.plugin.event.TestStepFinished;
import io.cucumber.plugin.event.TestStepStarted;
import io.cucumber.plugin.event.WriteEvent;
import java.util.concurrent.atomic.AtomicBoolean;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerSerenityReporterPlugin
extends SerenityReporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerSerenityReporterPlugin.class);
    private SerenityReporterCallbacks reporterCallbacks = new SerenityReporterCallbacks();
    private final AtomicBoolean isDryRun = new AtomicBoolean(false);

    public ScenarioContextDelegate getScenarioContextDelegate() {
        return new ScenarioContextDelegate(this.getContext());
    }

    public void setEventPublisher(EventPublisher publisher) {
        publisher.registerHandlerFor(TestRunStarted.class, this::handleTestRunStarted);
        publisher.registerHandlerFor(TestSourceRead.class, this::handleTestSourceRead);
        publisher.registerHandlerFor(TestCaseStarted.class, this::handleTestCaseStarted);
        publisher.registerHandlerFor(TestStepStarted.class, this::handleTestStepStarted);
        publisher.registerHandlerFor(TestStepFinished.class, this::handleTestStepFinished);
        publisher.registerHandlerFor(TestCaseFinished.class, this::handleTestCaseFinished);
        publisher.registerHandlerFor(TestRunFinished.class, this::handleTestRunFinished);
        publisher.registerHandlerFor(WriteEvent.class, this::handleWriteEvent);
    }

    protected void handleTestRunStarted(TestRunStarted event) {
        this.reporterCallbacks.handleTestRunStarted((Event)event, this.getScenarioContextDelegate());
        super.handleTestRunStarted(event);
    }

    protected void handleTestSourceRead(TestSourceRead event) {
        super.handleTestSourceRead(event);
        log.info("Feature file started: {}", (Object)event.getUri());
        this.reporterCallbacks.handleTestSourceRead((Event)event);
    }

    protected void handleTestCaseStarted(TestCaseStarted event) {
        this.isDryRun.set(TestCaseDelegate.of(event.getTestCase()).isDryRun());
        super.handleTestCaseStarted(event);
        this.reporterCallbacks.handleTestCaseStarted(event, this.getScenarioContextDelegate());
    }

    protected void handleTestStepStarted(TestStepStarted event) {
        super.handleTestStepStarted(event);
        this.reporterCallbacks.handleTestStepStarted(event, this.getScenarioContextDelegate());
    }

    protected void handleTestStepFinished(TestStepFinished event) {
        FailMessageOverrider.overrideFailureMessage(event);
        this.reporterCallbacks.handleTestStepFinished(event, this.getScenarioContextDelegate());
        super.handleTestStepFinished(event);
    }

    protected void handleTestCaseFinished(TestCaseFinished event) {
        this.reporterCallbacks.handleTestCaseFinished(event, this.getScenarioContextDelegate());
        super.handleTestCaseFinished(event);
    }

    protected void handleTestRunFinished(TestRunFinished event) {
        this.reporterCallbacks.handleTestRunFinished(event, this.getScenarioContextDelegate());
        super.handleTestRunFinished(event);
    }

    protected void handleWriteEvent(WriteEvent event) {
        super.handleWrite(event);
    }

    @Generated
    public SerenityReporterCallbacks getReporterCallbacks() {
        return this.reporterCallbacks;
    }
}

