/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.core.plugin;

import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.testenvmgr.env.ScenarioRunner;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import lombok.Generated;
import org.awaitility.Awaitility;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestIdentifier;
import org.junit.platform.launcher.TestPlan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerExecutionListener
implements TestExecutionListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerExecutionListener.class);

    public void testPlanExecutionStarted(TestPlan testPlan) {
        ScenarioRunner.addScenarios(this.collectScenarios(testPlan));
    }

    public void testPlanExecutionFinished(TestPlan testPlan) {
        super.testPlanExecutionFinished(testPlan);
        testPlan.getConfigurationParameters().getBoolean("cucumber.execution.dry-run").ifPresent(dryRun -> {
            if (dryRun.booleanValue()) {
                log.debug("Dry run detected. Will wait for tiger shutdown");
                Awaitility.await().logging(arg_0 -> ((Logger)log).trace(arg_0)).pollInterval(1L, TimeUnit.SECONDS).atMost(TigerDirector.getLibConfig().getPauseExecutionTimeoutSeconds(), TimeUnit.SECONDS).until(() -> TigerDirector.getTigerTestEnvMgr().isShutDown());
            }
        });
    }

    public void dynamicTestRegistered(TestIdentifier testIdentifier) {
        if (testIdentifier.isTest()) {
            ScenarioRunner.addScenarios(List.of(testIdentifier));
        }
    }

    public Set<TestIdentifier> collectScenarios(TestPlan testPlan) {
        Set roots = testPlan.getRoots();
        return roots.stream().map(r -> this.collectScenarios(testPlan, (TestIdentifier)r)).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    public Set<TestIdentifier> collectScenarios(TestPlan testplan, TestIdentifier root) {
        HashSet<TestIdentifier> result = new HashSet<TestIdentifier>();
        for (TestIdentifier child : testplan.getChildren(root.getUniqueIdObject())) {
            if (child.isContainer()) {
                result.addAll(this.collectScenarios(testplan, child));
                continue;
            }
            result.add(child);
        }
        return result;
    }

    @Generated
    public TigerExecutionListener() {
    }
}

