/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib;

import com.google.common.annotations.VisibleForTesting;
import de.gematik.rbellogger.RbelOptions;
import de.gematik.rbellogger.util.IRbelMessageListener;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.test.tiger.LocalProxyRbelMessageListener;
import de.gematik.test.tiger.common.Ansi;
import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.TigerConfigurationException;
import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.web.TigerBrowserUtil;
import de.gematik.test.tiger.lib.TigerLibConfig;
import de.gematik.test.tiger.lib.exception.TigerStartupException;
import de.gematik.test.tiger.lib.rbel.RbelMessageValidator;
import de.gematik.test.tiger.lib.reports.TigerRestAssuredCurlLoggingFilter;
import de.gematik.test.tiger.lib.serenityrest.SerenityRestUtils;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgrApplication;
import de.gematik.test.tiger.testenvmgr.controller.TestExecutionController;
import de.gematik.test.tiger.testenvmgr.data.BannerType;
import de.gematik.test.tiger.testenvmgr.env.ScenarioRunner;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.log.TigerServerLogManager;
import de.gematik.test.tiger.testenvmgr.util.TigerEnvironmentStartupException;
import de.gematik.test.tiger.testenvmgr.util.TigerTestEnvException;
import io.cucumber.core.plugin.report.SerenityReporterCallbacks;
import io.restassured.filter.Filter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import net.serenitybdd.rest.SerenityRest;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Fail;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class TigerDirector {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerDirector.class);
    private static TigerRestAssuredCurlLoggingFilter curlLoggingFilter;
    private static TigerTestEnvMgr tigerTestEnvMgr;
    private static boolean initialized;
    private static TigerLibConfig libConfig;
    private static ConfigurableApplicationContext envMgrApplicationContext;
    private static boolean shutdownHookRegistered;

    public static synchronized void start() {
        if (initialized) {
            log.info("Tiger Director already started, skipping");
            return;
        }
        try {
            TigerDirector.showTigerBanner();
            TigerDirector.readConfiguration();
            TigerDirector.registerRestAssuredFilter();
            TigerDirector.applyLoggingLevels();
            TigerDirector.applyTestLibConfig();
        }
        catch (TigerConfigurationException tcex) {
            throw tcex;
        }
        catch (RuntimeException rte) {
            throw new TigerConfigurationException("Unable to read/process configuration - " + rte.getMessage(), (Throwable)rte);
        }
        try {
            TigerDirector.startTestEnvMgr();
            TigerDirector.startWorkflowUi();
            TigerDirector.setupTestEnvironment(Optional.empty());
            TigerDirector.setDefaultProxyToLocalTigerProxy();
            initialized = true;
            if (TigerDirector.getTigerTestEnvMgr().isLocalTigerProxyActive()) {
                LocalProxyRbelMessageListener.initialize();
                if (TigerDirector.libConfig.clearEnvironmentStartupTraffic) {
                    LocalProxyRbelMessageListener.getInstance().clearAllMessages();
                }
            }
        }
        catch (RuntimeException e) {
            initialized = false;
            TigerDirector.quit(true);
            throw e;
        }
    }

    public static synchronized void startStandaloneTestEnvironment() {
        log.info("Starting Tiger testenvironment in STANDALONE MODE!");
        if (initialized) {
            log.info("Tiger Director already started, skipping");
            return;
        }
        try {
            TigerDirector.showTigerBanner();
            TigerDirector.readConfiguration();
            if (TigerDirector.getLibConfig().isActivateWorkflowUi()) {
                log.warn("Starting Workflow UI in standalone mode is not supported, deactivating the flag in config");
                TigerDirector.getLibConfig().activateWorkflowUi = false;
            }
            TigerDirector.applyLoggingLevels();
            TigerDirector.applyTestLibConfig();
        }
        catch (RuntimeException rte) {
            throw new TigerConfigurationException("Unable to read/process configuration - " + rte.getMessage(), (Throwable)rte);
        }
        try {
            TigerDirector.startTestEnvMgr();
            if (tigerTestEnvMgr.getConfiguration().isLocalProxyActive()) {
                log.warn("Starting local Tiger Proxy in standalone mode is not supported, deactivating the flag in config");
                tigerTestEnvMgr.getConfiguration().setLocalProxyActive(false);
            }
            TigerDirector.setupTestEnvironment(Optional.empty());
            initialized = true;
        }
        catch (RuntimeException e) {
            initialized = false;
            TigerDirector.quit(true);
            throw e;
        }
    }

    private static void applyLoggingLevels() {
        try {
            TigerGlobalConfiguration.readMapWithCaseSensitiveKeys((String[])new String[]{"tiger", "logging", "level"}).forEach(TigerServerLogManager::setLoggingLevel);
        }
        catch (NoClassDefFoundError ncde) {
            log.warn("Unable to detect logback library! Setting log level feature not supported");
        }
    }

    public static synchronized void registerShutdownHook() {
        if (shutdownHookRegistered) {
            return;
        }
        shutdownHookRegistered = true;
        log.info("Registering shutdown hook...");
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (tigerTestEnvMgr == null) {
                log.info(Ansi.colorize((String)"Finished shutdown (no test environment) OK", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
                return;
            }
            if (!tigerTestEnvMgr.isShuttingDown()) {
                TigerDirector.quit(true);
            }
        }));
    }

    public static void waitForAcknowledgedQuit() {
        TigerDirector.quit(true);
    }

    private static void quit(boolean shouldUserAcknowledgeShutdown) {
        block9: {
            try {
                if (TigerDirector.getLibConfig() != null && TigerDirector.getLibConfig().isActivateWorkflowUi() && shouldUserAcknowledgeShutdown) {
                    System.out.println(Ansi.colorize((String)"TGR Workflow UI is active, please press quit in browser window...", (RbelAnsiColors)RbelAnsiColors.GREEN_BOLD));
                    if (tigerTestEnvMgr == null) break block9;
                    tigerTestEnvMgr.receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerMessage("Test run finished, press SHUTDOWN").bannerColor("green").bannerType(BannerType.TESTRUN_ENDED).build());
                    try {
                        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(TigerDirector.getLibConfig().getPauseExecutionTimeoutSeconds(), TimeUnit.SECONDS).until(() -> tigerTestEnvMgr.getUserConfirmQuit().get() || tigerTestEnvMgr.isShouldAbortTestExecution());
                        break block9;
                    }
                    finally {
                        tigerTestEnvMgr.shutDown();
                    }
                }
                if (tigerTestEnvMgr != null) {
                    tigerTestEnvMgr.receivedQuitConfirmationFromWorkflowUi();
                    System.out.println("TGR Shutting down test env...");
                    tigerTestEnvMgr.shutDown();
                }
            }
            finally {
                TigerDirector.unregisterRestAssuredFilter();
                System.out.println("TGR Destroying spring boot context after testrun...");
                if (envMgrApplicationContext != null) {
                    envMgrApplicationContext.close();
                }
                System.out.println("TGR Tiger shut down orderly");
            }
        }
    }

    private static void setupTestEnvironment(Optional<IRbelMessageListener> tigerProxyMessageListener) {
        if (((Boolean)TigerConfigurationKeys.SKIP_ENVIRONMENT_SETUP.getValueOrDefault()).equals(Boolean.FALSE)) {
            log.info("\n" + Banner.toBannerStr((String)"SETTING UP TESTENV...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
            tigerTestEnvMgr.setUpEnvironment(tigerProxyMessageListener);
            log.info("\n" + Banner.toBannerStr((String)"TESTENV SET UP OK", (String)RbelAnsiColors.BLUE_BOLD.toString()));
        }
    }

    public static synchronized void readConfiguration() {
        libConfig = TigerGlobalConfiguration.instantiateConfigurationBeanStrict(TigerLibConfig.class, (String[])new String[]{"TIGER_LIB"}).orElseGet(TigerLibConfig::new);
    }

    private static void showTigerBanner() {
        if (((Boolean)TigerConfigurationKeys.SHOW_TIGER_LOGO.getValueOrDefault()).equals(Boolean.TRUE)) {
            try {
                log.info("\n" + IOUtils.toString((InputStream)Objects.requireNonNull(TigerDirector.class.getResourceAsStream("/tiger2-logo.ansi")), (Charset)StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new TigerStartupException("Unable to read tiger logo!");
            }
        }
    }

    private static void applyTestLibConfig() {
        if (libConfig.isRbelPathDebugging()) {
            RbelOptions.activateRbelPathDebugging();
        } else {
            RbelOptions.deactivateRbelPathDebugging();
        }
        if (libConfig.isRbelAnsiColors()) {
            RbelAnsiColors.activateAnsiColors();
        } else {
            RbelAnsiColors.deactivateAnsiColors();
        }
    }

    private static synchronized void startTestEnvMgr() {
        log.info("\n" + Banner.toBannerStr((String)"STARTING TESTENV MGR...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
        Map properties = TigerTestEnvMgr.getConfiguredLoggingLevels();
        properties.put("server.port", TigerConfigurationKeys.TESTENV_MGR_RESERVED_PORT.getValueOrDefault());
        properties.put("spring.mustache.enabled", false);
        properties.put("spring.mustache.check-template-location", false);
        envMgrApplicationContext = new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).properties(properties).sources(new Class[]{TigerTestEnvMgrApplication.class}).web(WebApplicationType.SERVLET).registerShutdownHook(false).initializers(new ApplicationContextInitializer[0]).run(new String[0]);
        tigerTestEnvMgr = (TigerTestEnvMgr)envMgrApplicationContext.getBean(TigerTestEnvMgr.class);
        TestExecutionController testExecutionController = (TestExecutionController)envMgrApplicationContext.getBean(TestExecutionController.class);
        testExecutionController.setShutdownListener(() -> {
            Awaitility.await().pollDelay(300L, TimeUnit.MILLISECONDS).until(() -> true);
            tigerTestEnvMgr.abortTestExecution();
            TigerDirector.quit(false);
        });
        testExecutionController.setPauseListener(() -> SerenityReporterCallbacks.setPauseMode(!SerenityReporterCallbacks.isPauseMode()));
    }

    private static synchronized void startWorkflowUi() {
        if (TigerDirector.libConfig.activateWorkflowUi) {
            log.info("\n" + Banner.toBannerStr((String)"STARTING WORKFLOW UI ...", (String)RbelAnsiColors.BLUE_BOLD.toString()));
            if (TigerDirector.libConfig.startBrowser) {
                TigerBrowserUtil.openUrlInBrowser((String)("http://localhost:" + ((Integer)TigerConfigurationKeys.TESTENV_MGR_RESERVED_PORT.getValue().orElseThrow(() -> new TigerEnvironmentStartupException("Failed to start browser!"))).toString()), (String)"Workflow UI");
            }
            log.info("Waiting for workflow Ui to fetch status...");
            try {
                int duration = 10;
                if (!TigerDirector.libConfig.startBrowser) {
                    log.info("Workflow UI http://localhost:" + TigerConfigurationKeys.TESTENV_MGR_RESERVED_PORT.getValue().orElseThrow());
                    duration = 60;
                }
                Awaitility.await().atMost(Duration.ofSeconds(duration)).pollInterval(Duration.ofSeconds(1L)).until(() -> tigerTestEnvMgr.isWorkflowUiSentFetch());
            }
            catch (ConditionTimeoutException cte) {
                TigerDirector.libConfig.activateWorkflowUi = false;
                throw new TigerTestEnvException("No feedback from workflow Ui, aborting!", (Throwable)cte);
            }
            try {
                TimeUnit.MILLISECONDS.sleep(2000L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TigerTestEnvException("Interrupt received while waiting for workflow Ui to become ready", (Throwable)e);
            }
        }
    }

    private static synchronized void setDefaultProxyToLocalTigerProxy() {
        TigerProxyConfiguration tpCfg = tigerTestEnvMgr.getConfiguration().getTigerProxy();
        if (tigerTestEnvMgr.isLocalTigerProxyActive()) {
            tigerTestEnvMgr.getLocalTigerProxyOptional().ifPresent(SerenityRestUtils::setupSerenityRest);
            tigerTestEnvMgr.setDefaultProxyToLocalTigerProxy();
        } else {
            log.info(Ansi.colorize((String)"SKIPPING TIGER PROXY settings as localProxyActive==false...", (RbelAnsiColors)RbelAnsiColors.RED_BOLD));
        }
    }

    public static synchronized boolean isInitialized() {
        return initialized;
    }

    public static TigerTestEnvMgr getTigerTestEnvMgr() {
        TigerDirector.assertThatTigerIsInitialized();
        return tigerTestEnvMgr;
    }

    public static String getLocalTigerProxyUrl() {
        TigerDirector.assertThatTigerIsInitialized();
        if (tigerTestEnvMgr.getLocalTigerProxyOptional().isEmpty() || !tigerTestEnvMgr.getConfiguration().isLocalProxyActive()) {
            return null;
        }
        return tigerTestEnvMgr.getLocalTigerProxyOrFail().getBaseUrl();
    }

    public static void assertThatTigerIsInitialized() {
        if (!initialized) {
            throw new TigerStartupException("Tiger test environment has not been initialized successfully!");
        }
    }

    public static boolean isSerenityAvailable() {
        return TigerDirector.isSerenityAvailable(false);
    }

    public static boolean isSerenityAvailable(boolean quiet) {
        try {
            Class.forName("net.serenitybdd.core.Serenity");
            return true;
        }
        catch (ClassNotFoundException e) {
            if (!quiet) {
                log.warn("Trying to use Serenity functionality, but Serenity BDD packages are not declared as runtime dependency.", (Throwable)e);
            }
            return false;
        }
    }

    @VisibleForTesting
    public static synchronized void testUninitialize() {
        initialized = false;
        tigerTestEnvMgr = null;
        curlLoggingFilter = null;
        RbelMessageValidator.clearInstance();
        LocalProxyRbelMessageListener.clearTestingInstance();
        System.clearProperty("TIGER_TESTENV_CFGFILE");
        System.clearProperty("http.proxyHost");
        System.clearProperty("https.proxyHost");
        System.clearProperty("http.proxyPort");
        System.clearProperty("https.proxyPort");
        ScenarioRunner.clearScenarios();
        TigerGlobalConfiguration.reset();
    }

    public static synchronized void registerRestAssuredFilter() {
        if (TigerDirector.getLibConfig().isAddCurlCommandsForRaCallsToReport() && curlLoggingFilter == null) {
            curlLoggingFilter = new TigerRestAssuredCurlLoggingFilter();
            SerenityRest.filters((Filter)curlLoggingFilter, (Filter[])new Filter[0]);
        }
    }

    public static synchronized void unregisterRestAssuredFilter() {
        if (curlLoggingFilter != null) {
            SerenityRest.replaceFiltersWith(new ArrayList());
        }
        curlLoggingFilter = null;
    }

    public static void pauseExecution() {
        TigerDirector.pauseExecution("", false);
    }

    public static void pauseExecution(String message, boolean isHtml) {
        String defaultMessage = "Test execution paused, click to continue";
        if (StringUtils.isBlank((CharSequence)message)) {
            message = defaultMessage;
        }
        if (!TigerDirector.getLibConfig().isActivateWorkflowUi()) {
            throw new TigerTestEnvException("The step 'TGR pause test run execution with message \"{}\"' is not supported outside the Workflow UI. Please check the manual for more information.", new Object[]{message});
        }
        tigerTestEnvMgr.receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerMessage(message).bannerColor("green").bannerType(BannerType.STEP_WAIT).bannerIsHtml(isHtml).build());
        Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(TigerDirector.getLibConfig().getPauseExecutionTimeoutSeconds(), TimeUnit.SECONDS).until(() -> tigerTestEnvMgr.getUserAcknowledgedOnWorkflowUi().compareAndSet(true, false));
    }

    public static void pauseExecution(String message) {
        TigerDirector.pauseExecution(message, false);
    }

    public static void pauseExecutionAndFailIfDesired(String message, String errorMessage) {
        if (TigerDirector.getLibConfig().isActivateWorkflowUi()) {
            tigerTestEnvMgr.receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerMessage(message).bannerColor("black").bannerType(BannerType.FAIL_PASS).build());
            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(TigerDirector.getLibConfig().getPauseExecutionTimeoutSeconds(), TimeUnit.SECONDS).until(() -> tigerTestEnvMgr.getUserAcknowledgedOnWorkflowUi().compareAndSet(true, false));
            if (tigerTestEnvMgr.isUserPressedFailTestExecution()) {
                Fail.fail((String)errorMessage);
            }
        } else {
            throw new TigerTestEnvException("The step 'TGR pause test run execution with message \"{}\" and message in case of error \"{}\"' is not supported outside the Workflow UI. Please check the manual for more information.", new Object[]{message, errorMessage});
        }
    }

    @Generated
    private TigerDirector() {
    }

    @Generated
    public static TigerRestAssuredCurlLoggingFilter getCurlLoggingFilter() {
        return curlLoggingFilter;
    }

    @Generated
    public static TigerLibConfig getLibConfig() {
        return libConfig;
    }

    static {
        initialized = false;
        shutdownHookRegistered = false;
    }
}

