/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.test.tiger.common.banner.Banner;
import de.gematik.test.tiger.common.config.ConfigurationValuePrecedence;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.testenvmgr.controller.TigerGlobalConfigurationController;
import de.gematik.test.tiger.testenvmgr.data.BannerType;
import de.gematik.test.tiger.testenvmgr.env.TigerStatusUpdate;
import de.gematik.test.tiger.testenvmgr.servers.AbstractTigerServer;
import de.gematik.test.tiger.testenvmgr.servers.TigerServerStatus;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Gegebensei;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.LocalDateTime;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.OptionalAssert;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerGlue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerGlue.class);
    private TigerGlobalConfigurationController tigerGlobalConfigurationController;

    public TigerGlue() {
        this(new TigerGlobalConfigurationController());
    }

    public TigerGlue(TigerGlobalConfigurationController tigerGlobalConfigurationController) {
        this.tigerGlobalConfigurationController = tigerGlobalConfigurationController;
    }

    @Wenn(value="TGR setze globale Variable {tigerResolvedString} auf {tigerResolvedString}")
    @When(value="TGR set global variable {tigerResolvedString} to {tigerResolvedString}")
    public void ctxtISetGlobalVariableTo(String key, String value) {
        log.debug("Setting global variable {} to '{}'", (Object)key, (Object)value);
        TigerGlobalConfiguration.putValue((String)key, (String)value);
    }

    @Wenn(value="TGR setze lokale Variable {tigerResolvedString} auf {tigerResolvedString}")
    @When(value="TGR set local variable {tigerResolvedString} to {tigerResolvedString}")
    public void ctxtISetLocalVariableTo(String key, String value) {
        log.debug("Setting local variable {} to '{}'", (Object)key, (Object)value);
        TigerGlobalConfiguration.putValue((String)key, (String)value, (ConfigurationValuePrecedence)ConfigurationValuePrecedence.LOCAL_TEST_CASE_CONTEXT);
    }

    @Wenn(value="TGR setze lokale Feature Variable {tigerResolvedString} auf {tigerResolvedString}")
    @When(value="TGR set local feature variable {tigerResolvedString} to {tigerResolvedString}")
    public void setFeatureVariable(String key, String value) {
        log.debug("Setting feature variable {} to '{}'", (Object)key, (Object)value);
        TigerGlobalConfiguration.putValue((String)key, (String)value, (ConfigurationValuePrecedence)ConfigurationValuePrecedence.TEST_CONTEXT);
    }

    @Dann(value="TGR pr\u00fcfe Variable {tigerResolvedString} stimmt \u00fcberein mit {tigerResolvedString}")
    @Then(value="TGR assert variable {tigerResolvedString} matches {tigerResolvedString}")
    public void ctxtAssertVariableMatches(String key, String regex) {
        String value = (String)TigerGlobalConfiguration.readStringOptional((String)key).orElseThrow(() -> new TigerLibraryException("Wanted to assert value of key " + key + " (resolved to " + key + ") but couldn't find it!"));
        if (!Objects.equals(value, regex)) {
            Assertions.assertThat((String)value).matches((CharSequence)regex);
        }
    }

    @Dann(value="TGR pr\u00fcfe Variable {tigerResolvedString} ist unbekannt")
    @Then(value="TGR assert variable {tigerResolvedString} is unknown")
    public void ctxtAssertVariableUnknown(String key) {
        Optional optionalValue = TigerGlobalConfiguration.readStringOptional((String)key);
        ((OptionalAssert)Assertions.assertThat((Optional)optionalValue).withFailMessage("Wanted to assert value of key {} (resolved to {}) is not set but found value {}!", new Object[]{key, key, optionalValue})).isEmpty();
    }

    @Gegebensei(value="TGR zeige {word} Banner {tigerResolvedString}")
    @Given(value="TGR show {word} banner {tigerResolvedString}")
    public void tgrShowColoredBanner(String color, String text) {
        log.info("\n" + Banner.toBannerStrWithCOLOR((String)text, (String)color.toUpperCase()));
    }

    @Gegebensei(value="TGR zeige {word} Text {tigerResolvedString}")
    @Given(value="TGR show {word} text {tigerResolvedString}")
    public void tgrShowColoredText(String color, String text) {
        log.info("\n" + Banner.toTextStr((String)text, (String)color.toUpperCase()));
    }

    @Gegebensei(value="TGR zeige Banner {tigerResolvedString}")
    @Given(value="TGR show banner {tigerResolvedString}")
    public void tgrIWantToShowBanner(String text) {
        log.info("\n" + Banner.toBannerStrWithCOLOR((String)text, (String)"WHITE"));
    }

    @When(value="TGR wait for user abort")
    @Wenn(value="TGR warte auf Abbruch")
    public void tgrWaitForUserAbort() {
        TigerDirector.waitForAcknowledgedQuit();
    }

    @When(value="TGR pause test run execution")
    @Wenn(value="TGR pausiere Testausf\u00fchrung")
    public void tgrPauseExecution() {
        TigerDirector.pauseExecution();
    }

    @When(value="TGR pause test run execution with message {string}")
    @Wenn(value="TGR pausiere Testausf\u00fchrung mit Nachricht {string}")
    public void tgrPauseExecutionWithMessage(String message) {
        TigerDirector.pauseExecution(TigerGlobalConfiguration.resolvePlaceholders((String)message));
    }

    @When(value="TGR pause test run execution with message {tigerResolvedString} and message in case of error {tigerResolvedString}")
    @Wenn(value="TGR pausiere Testausf\u00fchrung mit Nachricht {tigerResolvedString} und Meldung im Fehlerfall {tigerResolvedString}")
    public void tgrPauseExecutionWithMessageAndErrorMessage(String message, String errorMessage) {
        TigerDirector.pauseExecutionAndFailIfDesired(message, errorMessage);
    }

    @When(value="TGR show HTML Notification:")
    @Wenn(value="TGR zeige HTML Notification:")
    public void tgrShowHtmlNotification(String message) {
        String bannerMessage = TigerGlobalConfiguration.resolvePlaceholders((String)message);
        if (TigerDirector.getLibConfig().isActivateWorkflowUi()) {
            TigerDirector.getTigerTestEnvMgr().receiveTestEnvUpdate(TigerStatusUpdate.builder().bannerMessage(bannerMessage).bannerColor("green").bannerType(BannerType.STEP_WAIT).bannerIsHtml(true).build());
            Awaitility.await().pollInterval(1L, TimeUnit.SECONDS).atMost(TigerDirector.getLibConfig().getPauseExecutionTimeoutSeconds(), TimeUnit.SECONDS).until(() -> TigerDirector.getTigerTestEnvMgr().getUserAcknowledgedOnWorkflowUi().compareAndSet(true, false));
        } else {
            log.warn("Workflow UI is not active! Can't display message '{}'", (Object)bannerMessage);
        }
    }

    @When(value="TGR assert {tigerResolvedString} matches {tigerResolvedString}")
    @Dann(value="TGR pr\u00fcfe das {tigerResolvedString} mit {tigerResolvedString} \u00fcberein stimmt")
    public void tgrAssertMatches(String value1, String value2) {
        if (!Objects.equals(value1, value2)) {
            Assertions.assertThat((String)value1).matches((CharSequence)value2);
        }
    }

    @Dann(value="TGR gebe variable {tigerResolvedString} aus")
    @Then(value="TGR print variable {tigerResolvedString}")
    public void printVariable(String key) {
        Optional optionalValue = TigerGlobalConfiguration.readStringOptional((String)key);
        System.out.println(key + ": '" + optionalValue.orElse("This key is not set!") + "'");
    }

    @Given(value="TGR stop server {tigerResolvedString}")
    @Gegebensei(value="TGR stoppe Server {tigerResolvedString}")
    public void tgrStopServer(String servername) {
        AbstractTigerServer server = (AbstractTigerServer)TigerDirector.getTigerTestEnvMgr().getServers().get(servername);
        if (server == null) {
            throw new TigerServerNotFoundException(servername);
        }
        if (server.getStatus() != TigerServerStatus.RUNNING) {
            throw new TigerLibraryException("Server with name " + servername + " is not running! Current status is " + server.getStatus());
        }
        log.trace("Starting shutdown at {}", (Object)LocalDateTime.now());
        server.stopServerAndCleanUp();
        log.trace("Shutdown complete at {} with status {}", (Object)LocalDateTime.now(), (Object)server.getStatus());
    }

    @Given(value="TGR start server {tigerResolvedString}")
    @Gegebensei(value="TGR starte Server {tigerResolvedString}")
    public void tgrStartServer(String servername) {
        AbstractTigerServer server = (AbstractTigerServer)TigerDirector.getTigerTestEnvMgr().getServers().get(servername);
        if (server == null) {
            throw new TigerServerNotFoundException(servername);
        }
        if (server.getStatus() != TigerServerStatus.STOPPED) {
            throw new TigerLibraryException("Server with name " + servername + " is not stopped! Current status is " + server.getStatus());
        }
        server.start(TigerDirector.getTigerTestEnvMgr());
    }

    @Given(value="TGR save TigerGlobalConfiguration to file {tigerResolvedString}")
    @Gegebensei(value="TGR speichere TigerGlobalConfiguration in Datei {tigerResolvedString}")
    public void tgrSaveTigerGlobalConfigurationToFile(String filename) throws IOException {
        String configAsYaml = this.tigerGlobalConfigurationController.getGlobalConfigurationAsYaml();
        Files.writeString(Path.of(filename, new String[0]), (CharSequence)configAsYaml, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    }

    @Given(value="TGR load TigerGlobalConfiguration from file {tigerResolvedString}")
    @Gegebensei(value="TGR lade TigerGlobalConfiguration aus Datei {tigerResolvedString}")
    public void tgrLoadTigerGlobalConfigurationFromFile(String filename) throws IOException {
        String configAsYaml = Files.readString(Path.of(filename, new String[0]), StandardCharsets.UTF_8);
        this.tigerGlobalConfigurationController.importConfiguration(configAsYaml);
    }

    public static class TigerServerNotFoundException
    extends TigerLibraryException {
        public TigerServerNotFoundException(String servername) {
            super("Server with name " + servername + " not found!");
        }
    }
}

