/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.junit;

import io.cucumber.core.options.CommandlineOptionsParser;
import io.cucumber.core.options.RuntimeOptions;
import io.cucumber.core.plugin.Options;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.Generated;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.LauncherDiscoveryRequestBuilder;
import org.junit.platform.launcher.core.LauncherFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerCucumberRunner {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerCucumberRunner.class);

    public static void main(String[] args) {
        log.info("Starting TigerCucumberRunner.main()...");
        ArrayList<String> argvList = new ArrayList<String>(Arrays.asList(args));
        int index = argvList.indexOf("--tags");
        if (index <= 0) {
            argvList.add("--tags");
            argvList.add("not @Ignore");
        }
        String[] arr = argvList.toArray(new String[0]);
        RuntimeOptions cmdLineOptions = new CommandlineOptionsParser((OutputStream)System.out).parse(arr).build();
        Map<String, String> configurationParameters = TigerCucumberRunner.convertToConfigurationParametersMap(cmdLineOptions);
        LauncherDiscoveryRequest request = LauncherDiscoveryRequestBuilder.request().configurationParameters(configurationParameters).build();
        Launcher launcher = LauncherFactory.create();
        launcher.execute(request, new TestExecutionListener[0]);
        System.exit(0);
    }

    private static Map<String, String> convertToConfigurationParametersMap(RuntimeOptions runtimeOptions) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (runtimeOptions.isMonochrome()) {
            map.put("cucumber.ansi-colors.disabled", Boolean.toString(true));
        }
        if (runtimeOptions.isDryRun()) {
            map.put("cucumber.execution.dry-run", Boolean.toString(true));
        }
        if (!runtimeOptions.getFeaturePaths().isEmpty()) {
            map.put("cucumber.features", TigerCucumberRunner.commaSeparatedString(runtimeOptions.getFeaturePaths(), URI::toString));
        }
        if (!runtimeOptions.getNameFilters().isEmpty()) {
            map.put("cucumber.filter.name", TigerCucumberRunner.commaSeparatedString(runtimeOptions.getNameFilters(), Pattern::toString));
        }
        if (!runtimeOptions.getTagExpressions().isEmpty()) {
            map.put("cucumber.filter.tags", TigerCucumberRunner.commaSeparatedString(runtimeOptions.getTagExpressions(), Object::toString));
        }
        if (!runtimeOptions.getGlue().isEmpty()) {
            map.put("cucumber.glue", TigerCucumberRunner.commaSeparatedString(runtimeOptions.getGlue(), URI::toString));
        }
        Optional.ofNullable(runtimeOptions.getObjectFactoryClass()).ifPresent(objectFactoryClass -> map.put("cucumber.object-factory", objectFactoryClass.getName()));
        Optional.ofNullable(runtimeOptions.getUuidGeneratorClass()).ifPresent(uuidGeneratorClass -> map.put("cucumber.uuid-generator", uuidGeneratorClass.getName()));
        Optional.ofNullable(runtimeOptions.getSnippetType()).ifPresent(snippetType -> map.put("cucumber.snippet-type", snippetType.name()));
        map.put("cucumber.plugin", String.join((CharSequence)",", "io.cucumber.core.plugin.TigerSerenityReporterPlugin", TigerCucumberRunner.commaSeparatedString(runtimeOptions.plugins(), Options.Plugin::pluginString)));
        return map;
    }

    private static <T> String commaSeparatedString(Collection<T> collection, Function<T, String> toStringFunction) {
        return collection.stream().map(toStringFunction).collect(Collectors.joining(","));
    }
}

