/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelCborFacet;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHostnameFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.test.tiger.LocalProxyRbelMessageListener;
import de.gematik.test.tiger.RbelLoggerWriter;
import de.gematik.test.tiger.common.config.TigerConfigurationKeys;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.lib.enums.ModeType;
import de.gematik.test.tiger.lib.json.JsonChecker;
import de.gematik.test.tiger.lib.json.JsonSchemaChecker;
import de.gematik.test.tiger.lib.rbel.RbelMessageNodeElementMatchExecutor;
import de.gematik.test.tiger.lib.rbel.RequestParameter;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.transform.Source;
import lombok.Generated;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;

public class RbelMessageValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMessageValidator.class);
    public static final String RBEL_NAMESPACE = "rbel";
    public static final String FOUND_IN_MESSAGES = "' found in messages";
    private static final List<String> EMPTY_PATH = List.of("", "/");
    public static final TigerTypedConfigurationKey<Integer> RBEL_REQUEST_TIMEOUT = new TigerTypedConfigurationKey("tiger.rbel.request.timeout", Integer.class, (Object)5);
    private static final Map<String, UnaryOperator<DiffBuilder>> DIFF_OPTIONS = new HashMap<String, UnaryOperator<DiffBuilder>>();
    private static RbelMessageValidator instance;
    private final TigerTestEnvMgr tigerTestEnvMgr;
    private final TigerProxy tigerProxy;
    private final LocalProxyRbelMessageListener localProxyRbelMessageListener;
    protected RbelElement currentRequest;
    private RbelElement lastFoundMessage;
    protected RbelElement currentResponse;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RbelMessageValidator getInstance() {
        Class<RbelMessageValidator> clazz = RbelMessageValidator.class;
        synchronized (RbelMessageValidator.class) {
            if (instance == null) {
                instance = new RbelMessageValidator();
            }
            instance.registerJexlToolbox();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    @VisibleForTesting
    public static synchronized void clearInstance() {
        instance = null;
        TigerJexlExecutor.deregisterNamespace((String)RBEL_NAMESPACE);
    }

    private RbelMessageValidator() {
        this(TigerDirector.getTigerTestEnvMgr(), TigerDirector.getTigerTestEnvMgr().getLocalTigerProxyOrFail());
    }

    @Deprecated(forRemoval=true)
    public RbelMessageValidator(TigerTestEnvMgr tigerTestEnvMgr, TigerProxy tigerProxy) {
        this(tigerTestEnvMgr, tigerProxy, LocalProxyRbelMessageListener.getInstance());
    }

    public RbelMessageValidator(TigerTestEnvMgr tigerTestEnvMgr, TigerProxy tigerProxy, LocalProxyRbelMessageListener localProxyRbelMessageListener) {
        this.registerJexlToolbox();
        this.tigerTestEnvMgr = tigerTestEnvMgr;
        this.tigerProxy = tigerProxy;
        this.localProxyRbelMessageListener = localProxyRbelMessageListener;
    }

    private void registerJexlToolbox() {
        TigerJexlExecutor.registerAdditionalNamespace((String)RBEL_NAMESPACE, (Object)new JexlToolbox());
    }

    public List<RbelElement> getRbelMessages() {
        this.tigerProxy.waitForAllCurrentMessagesToBeParsed();
        return this.localProxyRbelMessageListener.getValidatableRbelMessages().stream().toList();
    }

    public void clearRbelMessages() {
        this.localProxyRbelMessageListener.clearValidatableRbelMessages();
    }

    public void filterRequestsAndStoreInContext(RequestParameter requestParameter) {
        RbelElement message = this.tryFindMessageByDescription(requestParameter);
        if (message.hasFacet(RbelRequestFacet.class)) {
            this.storeRequestAndWaitForAndStoreResponse(message);
        } else if (message.hasFacet(RbelResponseFacet.class)) {
            this.storeResponseAndSearchAndStoreRequest(message);
        } else {
            log.atInfo().addArgument(() -> ((RbelElement)message).getRawStringContent()).log("Found message that is neither request nor response:\n\n{}");
        }
    }

    private RbelElement tryFindMessageByDescription(RequestParameter requestParameter) {
        try {
            this.lastFoundMessage = this.findMessageByDescription(requestParameter);
            return this.lastFoundMessage;
        }
        catch (AssertionError e) {
            this.clearCurrentMessages();
            throw e;
        }
    }

    @VisibleForTesting
    public void clearCurrentMessages() {
        this.setCurrentRequest(null);
        this.setCurrentResponse(null);
        this.lastFoundMessage = null;
    }

    private void storeRequestAndWaitForAndStoreResponse(RbelElement request) {
        this.setCurrentRequest(request);
        this.setCurrentResponse(null);
        if (request.getFacet(RbelRequestFacet.class).filter(RbelRequestFacet::isResponseRequired).isPresent()) {
            try {
                int requestTimeout = (Integer)RBEL_REQUEST_TIMEOUT.getValueOrDefault();
                Awaitility.await((String)"Waiting for matching request").atMost((long)requestTimeout, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).until(() -> this.tigerTestEnvMgr.isShouldAbortTestExecution() || this.findAndStoreCorrespondingResponse(request));
                if (this.tigerTestEnvMgr.isShouldAbortTestExecution()) {
                    throw new AssertionError((Object)"User aborted test run");
                }
            }
            catch (ConditionTimeoutException cte) {
                log.atError().addArgument(() -> ((RbelElement)request).getRawStringContent()).log("Missing response to filtered request!\n\n{}");
                throw new TigerLibraryException("Missing response to filtered request!", new Object[]{cte});
            }
        }
    }

    private void storeResponseAndSearchAndStoreRequest(RbelElement response) {
        this.setCurrentResponse(response);
        if (!this.findAndStoreCorrespondingRequest(response)) {
            this.setCurrentRequest(response);
            log.atInfo().addArgument(() -> ((RbelElement)response).getRawStringContent()).log("Missing request to filtered response!\n\n{}");
        }
    }

    private boolean findAndStoreCorrespondingResponse(RbelElement message) {
        return this.findAndStoreCorrespondingOtherMessage(message, RbelResponseFacet.class, TracingMessagePairFacet::getResponse, this::setCurrentResponse);
    }

    private boolean findAndStoreCorrespondingRequest(RbelElement message) {
        return this.findAndStoreCorrespondingOtherMessage(message, RbelRequestFacet.class, TracingMessagePairFacet::getRequest, this::setCurrentRequest);
    }

    private boolean findAndStoreCorrespondingOtherMessage(RbelElement message, Class<? extends RbelFacet> otherMessageFacet, Function<TracingMessagePairFacet, RbelElement> getOtherMessageFromPair, Consumer<RbelElement> storeOtherMessage) {
        return message.getFacet(TracingMessagePairFacet.class).stream().map(getOtherMessageFromPair).filter(msg -> msg.hasFacet(otherMessageFacet)).anyMatch(msg -> {
            storeOtherMessage.accept((RbelElement)msg);
            return true;
        });
    }

    public RbelElement waitForMessageToBePresent(RequestParameter requestParameter) {
        return this.findMessageByDescription(requestParameter);
    }

    protected RbelElement findMessageByDescription(RequestParameter requestParameter) {
        int waitsec = (Integer)RBEL_REQUEST_TIMEOUT.getValueOrDefault();
        Optional<RbelElement> initialElement = this.getInitialElement(requestParameter);
        AtomicReference candidate = new AtomicReference();
        try {
            Awaitility.await((String)"Waiting for matching request").atMost((long)waitsec, TimeUnit.SECONDS).pollDelay(0L, TimeUnit.SECONDS).pollInterval(400L, TimeUnit.MILLISECONDS).until(() -> {
                if (this.tigerTestEnvMgr.isShouldAbortTestExecution()) {
                    return true;
                }
                Optional<RbelElement> found = this.filterRequests(requestParameter, initialElement);
                found.ifPresent(candidate::set);
                return found.isPresent();
            });
            if (this.tigerTestEnvMgr.isShouldAbortTestExecution()) {
                throw new AssertionError((Object)"User aborted test run");
            }
        }
        catch (ConditionTimeoutException cte) {
            log.error("Didn't find any matching messages!");
            this.printAllPathsOfMessages(this.getRbelMessages());
            if (requestParameter.getPath() == null) {
                throw new AssertionError((Object)String.format("No request with matching rbelPath '%s%s", requestParameter.getRbelPath(), FOUND_IN_MESSAGES));
            }
            if (requestParameter.getRbelPath() == null) {
                throw new AssertionError((Object)String.format("No request with path '%s%s", requestParameter.getPath(), FOUND_IN_MESSAGES));
            }
            throw new AssertionError((Object)String.format("No request with path '%s' and rbelPath '%s' matching '%s%s", requestParameter.getPath(), requestParameter.getRbelPath(), StringUtils.abbreviate((String)requestParameter.getValue(), (int)300), FOUND_IN_MESSAGES));
        }
        return (RbelElement)candidate.get();
    }

    private Optional<RbelElement> getInitialElement(RequestParameter requestParameter) {
        Deque<RbelElement> validatableRbelMessages = this.localProxyRbelMessageListener.getValidatableRbelMessages();
        if (requestParameter.isStartFromLastMessage()) {
            RbelElement markerMessage = requestParameter.isRequireRequestMessage() ? this.currentRequest : this.lastFoundMessage;
            return validatableRbelMessages.stream().dropWhile(msg -> msg != markerMessage).skip(1L).findFirst();
        }
        if (requestParameter.isRequireNewMessage() && !validatableRbelMessages.isEmpty()) {
            return Optional.ofNullable(validatableRbelMessages.getLast());
        }
        return Optional.empty();
    }

    protected Optional<RbelElement> filterRequests(RequestParameter requestParameter, Optional<RbelElement> startFromMessageInclusively) {
        String methodFilter;
        String hostFilter;
        List<RbelElement> msgs = this.getRbelElementsOptionallyFromGivenMessageInclusively(startFromMessageInclusively);
        List candidateMessages = this.getCandidateMessages(requestParameter, msgs, hostFilter = (String)TigerConfigurationKeys.REQUEST_FILTER_HOST.getValueOrDefault(), methodFilter = (String)TigerConfigurationKeys.REQUEST_FILTER_METHOD.getValueOrDefault());
        if (candidateMessages.isEmpty()) {
            return Optional.empty();
        }
        if (StringUtils.isEmpty((CharSequence)requestParameter.getRbelPath())) {
            if (candidateMessages.size() > 1) {
                log.atWarn().addArgument(() -> requestParameter.isFilterPreviousRequest() ? "last" : "first").log("Found more then one candidate message. Returning {} message. This may not be deterministic!");
                this.printAllPathsOfMessages(candidateMessages);
            }
            if (requestParameter.isFilterPreviousRequest()) {
                return Optional.of((RbelElement)candidateMessages.get(candidateMessages.size() - 1));
            }
            return Optional.of((RbelElement)candidateMessages.get(0));
        }
        if (requestParameter.isFilterPreviousRequest()) {
            candidateMessages = Lists.reverse(candidateMessages);
        }
        return this.filterMatchingCandidateMessages(requestParameter, candidateMessages);
    }

    private List<RbelElement> getRbelElementsOptionallyFromGivenMessageInclusively(Optional<RbelElement> startFromMessageExclusively) {
        List<RbelElement> msgs = this.getRbelMessages();
        if (startFromMessageExclusively.isPresent()) {
            int idx = -1;
            for (int i = 0; i < msgs.size(); ++i) {
                if (msgs.get(i) != startFromMessageExclusively.get()) continue;
                idx = i;
                break;
            }
            if (idx > 0) {
                msgs = new ArrayList<RbelElement>(msgs.subList(idx, msgs.size()));
            }
        }
        return msgs;
    }

    @NotNull
    private List<RbelElement> getCandidateMessages(RequestParameter requestParameter, List<RbelElement> msgs, String hostFilter, String methodFilter) {
        return msgs.stream().filter(el -> !requestParameter.isRequireRequestMessage() || el.hasFacet(RbelRequestFacet.class)).filter(req -> this.doesPathOfMessageMatch((RbelElement)req, requestParameter.getPath())).filter(req -> hostFilter == null || hostFilter.isEmpty() || this.doesHostMatch((RbelElement)req, hostFilter)).filter(req -> methodFilter == null || methodFilter.isEmpty() || this.doesMethodMatch((RbelElement)req, methodFilter)).toList();
    }

    @NotNull
    private Optional<RbelElement> filterMatchingCandidateMessages(RequestParameter requestParameter, List<RbelElement> candidateMessages) {
        for (RbelElement candidateMessage : candidateMessages) {
            List pathExecutionResult = new RbelPathExecutor((RbelPathAble)candidateMessage, requestParameter.getRbelPath()).execute();
            if (pathExecutionResult.isEmpty()) continue;
            if (StringUtils.isEmpty((CharSequence)requestParameter.getValue())) {
                return Optional.of(candidateMessage);
            }
            String content = pathExecutionResult.stream().map(RbelMessageValidator::getValueOrContentString).map(String::trim).collect(Collectors.joining());
            try {
                if (content.equals(requestParameter.getValue()) || content.matches(requestParameter.getValue()) || Pattern.compile(requestParameter.getValue(), 32).matcher(content).matches()) {
                    return Optional.of(candidateMessage);
                }
                log.atInfo().addArgument(() -> StringUtils.abbreviate((String)content, (int)300)).addArgument(() -> StringUtils.abbreviate((String)requestParameter.getValue(), (int)300)).log("Found rbel node but \n'{}' didnt match\n'{}'");
            }
            catch (Exception ex) {
                log.error("Failure while trying to apply regular expression '{}'!", (Object)requestParameter.getValue(), (Object)ex);
            }
        }
        return Optional.empty();
    }

    public boolean doesPathOfMessageMatch(RbelElement req, String path) {
        if (path == null) {
            return true;
        }
        try {
            URI uri = new URI(req.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getPath).map(RbelMessageValidator::getValueOrContentString).orElse(""));
            boolean match = this.doesItMatch(uri.getPath(), path);
            if (!match && EMPTY_PATH.contains(path) && EMPTY_PATH.contains(uri.getPath())) {
                match = true;
            }
            return match;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    public boolean doesHostMatch(RbelElement req, String hostFilter) {
        String host = req.getFacet(RbelTcpIpMessageFacet.class).flatMap(e -> RbelHostnameFacet.tryToExtractServerName((RbelElement)e.getReceiver())).orElse("");
        return this.doesItMatch(host, hostFilter);
    }

    public boolean doesMethodMatch(RbelElement req, String method) {
        String reqMethod = req.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getMethod).map(RbelElement::getRawStringContent).map(String::toUpperCase).orElse("");
        return this.doesItMatch(reqMethod, method);
    }

    private boolean doesItMatch(String toTest, String matchingString) {
        try {
            return StringUtils.equals((CharSequence)toTest, (CharSequence)matchingString) || toTest.matches(matchingString);
        }
        catch (PatternSyntaxException rte) {
            log.error("Probable error while parsing regex!", (Throwable)rte);
            return false;
        }
    }

    public void assertAttributeOfCurrentResponseMatches(String rbelPath, String value, boolean shouldMatch) {
        RbelMessageNodeElementMatchExecutor.builder().rbelPath(rbelPath).shouldMatch(shouldMatch).oracle(value).elements(this.findElementsInCurrentResponse(rbelPath)).build().execute();
    }

    public void assertAttributeOfCurrentRequestMatches(String rbelPath, String value, boolean shouldMatch) {
        RbelMessageNodeElementMatchExecutor.builder().rbelPath(rbelPath).shouldMatch(shouldMatch).oracle(value).elements(this.findElementsInCurrentRequest(rbelPath)).build().execute();
    }

    public void assertAttributeOfCurrentResponseMatchesAs(String rbelPath, ModeType mode, String oracle, String diffOptionCsv) {
        this.assertAttributeForMessagesMatchAs(mode, oracle, this.findElementsInCurrentResponse(rbelPath), diffOptionCsv);
    }

    public void assertAttributeOfCurrentRequestMatchesAs(String rbelPath, ModeType mode, String oracle) {
        this.assertAttributeForMessagesMatchAs(mode, oracle, this.findElementsInCurrentRequest(rbelPath), "");
    }

    public void assertAttributeForMessagesMatchAs(ModeType mode, String oracle, List<RbelElement> elements, String diffOptionCSV) {
        for (RbelElement element : elements) {
            try {
                switch (mode) {
                    case JSON: {
                        new JsonChecker().compareJsonStrings(this.getAsJsonString(element), oracle, false);
                        break;
                    }
                    case XML: {
                        this.compareXMLStructureOfRbelElement(element, oracle, diffOptionCSV);
                        break;
                    }
                    case JSON_SCHEMA: {
                        new JsonSchemaChecker().compareJsonToSchema(this.getAsJsonString(element), oracle);
                    }
                }
                log.debug("Found matching element: \n{}", (Object)element.printTreeStructure());
                return;
            }
            catch (JsonChecker.JsonCheckerMismatchException | AssertionError object) {
            }
        }
        if (elements.size() == 1) {
            throw new AssertionError((Object)String.format("Element value:\n%s\nExpected:\n%s", elements.get(0).getRawStringContent(), oracle));
        }
        throw new AssertionError((Object)String.format("No matching element for value %s found in list of %d elements! ", oracle, elements.size()));
    }

    private String getAsJsonString(RbelElement target) {
        if (target.hasFacet(RbelJsonFacet.class)) {
            return target.getRawStringContent();
        }
        if (target.hasFacet(RbelCborFacet.class)) {
            return target.getFacet(RbelCborFacet.class).map(RbelCborFacet::getNode).map(JsonNode::toString).orElse("");
        }
        throw new AssertionError((Object)"Node is neither JSON nor CBOR, can not match with JSON");
    }

    private void printAllPathsOfMessages(List<RbelElement> msgs) {
        long requests = msgs.stream().filter(msg -> msg.getFacet(RbelHttpRequestFacet.class).isPresent()).count();
        log.info("Found the following {} messages:\n{} ", (Object)requests, (Object)msgs.stream().map(msg -> msg.getFacet(RbelHttpRequestFacet.class)).filter(Optional::isPresent).map(Optional::get).map(req -> "=>\t" + req.getPathAsString() + " : " + req.getChildElements()).collect(Collectors.joining("\n")));
    }

    public void compareXMLStructure(String test, String oracle, List<UnaryOperator<DiffBuilder>> diffOptions) {
        ArrayList diffs = new ArrayList();
        Source srcTest = Input.from((Object)test).build();
        Source srcOracle = Input.from((Object)oracle).build();
        DiffBuilder db = DiffBuilder.compare((Object)srcOracle).withTest((Object)srcTest);
        for (UnaryOperator<DiffBuilder> src : diffOptions) {
            db = (DiffBuilder)src.apply(db);
        }
        db = db.checkForSimilar();
        db.withDifferenceEvaluator((comparison, outcome) -> {
            if (outcome != ComparisonResult.EQUAL && (comparison.getType() == ComparisonType.NAMESPACE_URI || comparison.getType() == ComparisonType.NAMESPACE_PREFIX)) {
                return ComparisonResult.SIMILAR;
            }
            return outcome;
        });
        Diff diff = db.build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)diff.hasDifferences()).withFailMessage("XML tree mismatch!\n" + diff, new Object[0])).isFalse();
    }

    public void compareXMLStructure(String test, String oracle) {
        this.compareXMLStructure(test, oracle, Collections.emptyList());
    }

    public void compareXMLStructure(String test, String oracle, String diffOptionCSV) {
        ArrayList<UnaryOperator<DiffBuilder>> diffOptions = new ArrayList<UnaryOperator<DiffBuilder>>();
        Arrays.stream(diffOptionCSV.split(",")).map(String::trim).forEach(srcClassId -> {
            Assertions.assertThat(DIFF_OPTIONS).containsKey(srcClassId);
            diffOptions.add(DIFF_OPTIONS.get(srcClassId));
        });
        this.compareXMLStructure(test, oracle, diffOptions);
    }

    public void compareXMLStructureOfRbelElement(RbelElement el, String oracle, String diffOptionCSV) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)el.hasFacet(RbelXmlFacet.class)).withFailMessage("Node " + el.getKey() + " is not XML", new Object[0])).isTrue();
        this.compareXMLStructure(el.getRawStringContent(), oracle, diffOptionCSV);
    }

    public RbelElement findElementInCurrentResponse(String rbelPath) {
        try {
            this.assertCurrentResponseFound();
            List elems = this.currentResponse.findRbelPathMembers(rbelPath);
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("No node matching path '" + rbelPath + "'!", new Object[0])).isNotEmpty();
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("Expected exactly one match for path '" + rbelPath + "'!", new Object[0])).hasSize(1);
            return (RbelElement)elems.get(0);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to find element in last response for rbel path '" + rbelPath + RbelMessageValidator.printMessageTree(this.currentResponse)));
        }
    }

    @NotNull
    private static String printMessageTree(RbelElement msg) {
        return "' in message\n " + msg.printTreeStructure();
    }

    private void assertCurrentResponseFound() {
        if (this.currentResponse == null) {
            throw new AssertionError((Object)"No current response message found!");
        }
    }

    public RbelElement findElementInCurrentRequest(String rbelPath) {
        try {
            this.assertCurrentRequestFound();
            List elems = this.currentRequest.findRbelPathMembers(rbelPath);
            if (elems.size() != 1) {
                log.atWarn().addArgument((Object)rbelPath).addArgument(() -> ((RbelElement)this.currentRequest).printTreeStructure()).log("Could not find elements {} in message\n {}");
            }
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("No node matching path '" + rbelPath + "'!", new Object[0])).isNotEmpty();
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("Expected exactly one match for path '" + rbelPath + "'!", new Object[0])).hasSize(1);
            return (RbelElement)elems.get(0);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to find element in last request for rbel path '" + rbelPath + RbelMessageValidator.printMessageTree(this.currentRequest)));
        }
    }

    public List<RbelElement> findElementsInCurrentResponse(String rbelPath) {
        this.assertCurrentResponseFound();
        List elems = this.currentResponse.findRbelPathMembers(rbelPath);
        if (elems.isEmpty()) {
            throw new AssertionError((Object)("Unable to find element in response for rbel path '" + rbelPath + RbelMessageValidator.printMessageTree(this.currentResponse)));
        }
        return elems;
    }

    public List<RbelElement> findElementsInCurrentRequest(String rbelPath) {
        this.assertCurrentRequestFound();
        List elems = this.currentRequest.findRbelPathMembers(rbelPath);
        if (elems.isEmpty()) {
            throw new AssertionError((Object)("Unable to find element in request for rbel path '" + rbelPath + RbelMessageValidator.printMessageTree(this.currentRequest)));
        }
        return elems;
    }

    private void assertCurrentRequestFound() {
        if (this.currentRequest == null) {
            throw new AssertionError((Object)"No current request message found!");
        }
    }

    public void findAnyMessageMatchingAtNode(String rbelPath, String value) {
        if (this.getRbelMessages().stream().map(msg -> {
            List findings = new RbelPathExecutor((RbelPathAble)msg, rbelPath).execute();
            if (findings.isEmpty()) {
                return null;
            }
            return RbelMessageValidator.getValueOrContentString((RbelElement)findings.get(0));
        }).filter(Objects::nonNull).filter(msg -> msg.equals(value)).findAny().isEmpty()) {
            throw new AssertionError((Object)("No message with matching value '" + value + "' at path '" + rbelPath + "'"));
        }
    }

    public void findLastRequest() {
        ReverseListIterator descendingIterator = new ReverseListIterator(this.getRbelMessages());
        RbelElement lastRequest = StreamSupport.stream(Spliterators.spliteratorUnknownSize(descendingIterator, 16), false).filter(msg -> msg.hasFacet(RbelRequestFacet.class)).findFirst().orElseThrow(() -> new TigerLibraryException("No Request found."));
        this.setCurrentRequest(lastRequest);
        this.setCurrentResponse(lastRequest.getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getResponse).orElse(null));
    }

    public void readTgrFile(String filePath) {
        List readElements = this.tigerProxy.readTrafficFromTgrFile(filePath);
        readElements.forEach(this.localProxyRbelMessageListener::triggerNewReceivedMessage);
    }

    public static String getValueOrContentString(RbelElement elem) {
        return elem.printValue().orElseGet(() -> ((RbelElement)elem).getRawStringContent());
    }

    @Generated
    private LocalProxyRbelMessageListener getLocalProxyRbelMessageListener() {
        return this.localProxyRbelMessageListener;
    }

    @Generated
    public void setCurrentRequest(RbelElement currentRequest) {
        this.currentRequest = currentRequest;
    }

    @Generated
    public RbelElement getCurrentRequest() {
        return this.currentRequest;
    }

    @Generated
    protected void setCurrentResponse(RbelElement currentResponse) {
        this.currentResponse = currentResponse;
    }

    @Generated
    public RbelElement getCurrentResponse() {
        return this.currentResponse;
    }

    static {
        DIFF_OPTIONS.put("nocomment", DiffBuilder::ignoreComments);
        DIFF_OPTIONS.put("txtignoreempty", DiffBuilder::ignoreElementContentWhitespace);
        DIFF_OPTIONS.put("txttrim", DiffBuilder::ignoreWhitespace);
        DIFF_OPTIONS.put("txtnormalize", DiffBuilder::normalizeWhitespace);
    }

    public class JexlToolbox {
        public String currentResponseAsString(String rbelPath) {
            return RbelMessageValidator.this.findElementInCurrentResponse(rbelPath).getRawStringContent();
        }

        public String currentResponseAsString() {
            return RbelMessageValidator.this.currentResponse.getRawStringContent();
        }

        public RbelElement currentResponse(String rbelPath) {
            return RbelMessageValidator.this.findElementInCurrentResponse(rbelPath);
        }

        public String currentRequestAsString(String rbelPath) {
            return RbelMessageValidator.getValueOrContentString(RbelMessageValidator.this.findElementInCurrentRequest(rbelPath));
        }

        public String currentRequestAsString() {
            return RbelMessageValidator.this.currentRequest.getRawStringContent();
        }

        public RbelElement currentRequest(String rbelPath) {
            return RbelMessageValidator.this.findElementInCurrentRequest(rbelPath);
        }

        public RbelElement lastResponse() {
            return this.lastMessageMatching(msg -> msg.hasFacet(RbelResponseFacet.class) || msg.hasFacet(RbelHttpResponseFacet.class));
        }

        public String lastResponseAsString() {
            return Optional.ofNullable(this.lastResponse()).map(RbelElement::getRawStringContent).orElseThrow(NoSuchElementException::new);
        }

        public RbelElement lastRequest() {
            return this.lastMessageMatching(msg -> msg.hasFacet(RbelRequestFacet.class) || msg.hasFacet(RbelHttpRequestFacet.class));
        }

        private RbelElement lastMessageMatching(Predicate<RbelElement> testMessage) {
            Iterator<RbelElement> backwardsIterator = RbelMessageValidator.this.localProxyRbelMessageListener.getValidatableRbelMessages().descendingIterator();
            while (backwardsIterator.hasNext()) {
                RbelElement element = backwardsIterator.next();
                if (!testMessage.test(element)) continue;
                return element;
            }
            throw new NoSuchElementException();
        }

        public String lastRequestAsString() {
            return Optional.ofNullable(this.lastRequest()).map(RbelElement::getRawStringContent).orElseThrow(NoSuchElementException::new);
        }

        public String getValueAtLocationAsString(RbelElement element, String rbelPath) {
            return element.findElement(rbelPath).flatMap(el -> el.getFacet(RbelValueFacet.class)).map(RbelValueFacet::getValue).map(Object::toString).orElseThrow(() -> new NoSuchElementException("Unable to find a matching element for '" + rbelPath + "'"));
        }

        public String encodeAs(String valueToEncode, String contentType) {
            RbelContentType encodeAs = RbelContentType.seekValueFor((String)contentType);
            RbelLoggerWriter rbelLoggerWriter = new RbelLoggerWriter();
            RbelElement toEncode = rbelLoggerWriter.getRbelConverter().convertElement(valueToEncode, null);
            return rbelLoggerWriter.getRbelWriter().serializeWithEnforcedContentType(toEncode, encodeAs, new TigerJexlContext()).getContentAsString();
        }
    }
}

