/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.test.tiger.RbelLoggerWriter;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.common.util.ResetableLazyInitializer;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.exception.TigerHttpGlueCodeException;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RedirectConfig;
import io.restassured.http.Method;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.specification.QueryableRequestSpecification;
import io.restassured.specification.RequestSpecification;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.SoftAssertionsProvider;

public class TigerHttpClient {
    public static final String KEY_HTTP_CLIENT = "httpClient";
    public static final String KEY_TIGER = "tiger";
    public static final String KEY_DEFAULT_HEADER = "defaultHeader";
    private static final ResetableLazyInitializer<RbelLoggerWriter> RBEL_LOGGER_WRITER = new ResetableLazyInitializer(RbelLoggerWriter::new);
    private static final TigerTypedConfigurationKey<Boolean> executeBlocking = new TigerTypedConfigurationKey(new TigerConfigurationKey(new String[]{"tiger", "httpClient", "executeBlocking"}), Boolean.class, (Object)true);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;

    private TigerHttpClient() {
    }

    public static void reset() {
        RBEL_LOGGER_WRITER.reset();
    }

    public static RequestSpecification givenDefaultSpec() {
        EncoderConfig encoderConfig = RestAssured.config().getEncoderConfig().appendDefaultContentCharsetToContentTypeIfUndefined(true);
        RequestSpecification requestSpecification = RestAssured.given().urlEncodingEnabled(false).config(RestAssured.config().encoderConfig(encoderConfig));
        requestSpecification.headers(TigerGlobalConfiguration.readMap((String[])new String[]{KEY_TIGER, KEY_HTTP_CLIENT, KEY_DEFAULT_HEADER}));
        Optional.ofNullable(((QueryableRequestSpecification)requestSpecification).getContentType()).ifPresent(ct -> TigerHttpClient.setExactContentTypeHeader(requestSpecification, ct));
        return requestSpecification;
    }

    public static void executeCommandInBackground(SoftAssertionsProvider.ThrowingRunnable command) {
        TigerDirector.getTigerTestEnvMgr().getCachedExecutor().submit(() -> {
            try {
                command.run();
            }
            catch (Exception e) {
                throw new TigerHttpGlueCodeException("Error during request execution", e);
            }
        });
    }

    public static void executeCommandWithContingentWait(SoftAssertionsProvider.ThrowingRunnable command) {
        if (Boolean.TRUE.equals(executeBlocking.getValueOrDefault())) {
            try {
                command.run();
            }
            catch (Exception e) {
                throw new TigerHttpGlueCodeException("Error during request execution", e);
            }
        } else {
            TigerHttpClient.executeCommandInBackground(command);
        }
    }

    public static void applyRedirectConfig(RedirectConfig newRedirectConfig) {
        RestAssured.config = RestAssured.config.redirect(newRedirectConfig);
    }

    public static void resetRedirectConfig() {
        TigerHttpClient.applyRedirectConfig(new RedirectConfig());
    }

    public static String resolveToString(String value) {
        return TigerHttpClient.resolve(value).getContentAsString();
    }

    public static RbelSerializationResult resolve(String value) {
        String resolvedInput = TigerGlobalConfiguration.resolvePlaceholders((String)value);
        if (TigerDirector.getLibConfig().getHttpClientConfig().isActivateRbelWriter()) {
            RbelElement input = ((RbelLoggerWriter)RBEL_LOGGER_WRITER.get()).getRbelConverter().convertElement(resolvedInput, null);
            return ((RbelLoggerWriter)RBEL_LOGGER_WRITER.get()).getRbelWriter().serialize(input, new TigerJexlContext().withRootElement((Object)input));
        }
        return RbelSerializationResult.withUnknownType((byte[])resolvedInput.getBytes(DEFAULT_CHARSET));
    }

    public static void sendResolvedBody(Method method, URI address, String body) {
        TigerHttpClient.sendResolvedBody(method, address, null, body);
    }

    public static void sendResolvedBody(Method method, URI address, String contentType, String body) {
        RbelSerializationResult resolved = TigerHttpClient.resolve(body);
        RequestSpecification requestSpecification = TigerHttpClient.givenDefaultSpec();
        if (contentType != null) {
            TigerHttpClient.setExactContentTypeHeader(requestSpecification, contentType);
        }
        resolved.getContentType().map(RbelContentType::getContentTypeString).filter(o -> StringUtils.isEmpty((CharSequence)((RequestSpecificationImpl)requestSpecification).getContentType())).ifPresent(arg_0 -> ((RequestSpecification)requestSpecification).contentType(arg_0));
        requestSpecification.body(resolved.getContent()).request(method, address);
    }

    private static void setExactContentTypeHeader(RequestSpecification requestSpecification, String contentType) {
        requestSpecification.config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().appendDefaultContentCharsetToContentTypeIfUndefined(false)));
        requestSpecification.contentType(contentType);
    }
}

