/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.rbellogger.builder.RbelBuilder;
import de.gematik.rbellogger.builder.RbelBuilderManager;
import de.gematik.rbellogger.builder.RbelObjectJexl;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelSerializationAssertion;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.tree.RbelContentTreeNode;
import de.gematik.test.tiger.lib.TigerDirector;
import io.cucumber.java.Before;
import io.cucumber.java.de.Gegebensei;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.When;
import lombok.Generated;
import org.junit.jupiter.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelBuilderGlueCode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelBuilderGlueCode.class);
    private final RbelBuilderManager rbelBuilders = new RbelBuilderManager();

    @Before
    public void beforeScenario() {
        TigerDirector.readConfiguration();
    }

    @Gegebensei(value="TGR erstellt ein neues Rbel-Objekt {tigerResolvedString} mit Inhalt {tigerResolvedString}")
    @Given(value="TGR creates a new Rbel object {tigerResolvedString} with content {tigerResolvedString}")
    public void createFromContent(String name, String content) {
        this.rbelBuilders.put(name, RbelBuilder.fromString((String)content));
        RbelObjectJexl.initJexl((RbelBuilderManager)this.rbelBuilders);
    }

    @Gegebensei(value="TGR erstellt ein neues leeres Rbel-Objekt {tigerResolvedString} mit Typ {rbelContentType}")
    @Given(value="TGR creates a new empty Rbel object {tigerResolvedString} of type {rbelContentType}")
    public void createFromScratch(String name, RbelContentType type) {
        this.rbelBuilders.put(name, RbelBuilder.fromScratch((RbelContentType)type));
        RbelObjectJexl.initJexl((RbelBuilderManager)this.rbelBuilders);
    }

    @Wenn(value="TGR setzt Rbel-Objekt {tigerResolvedString} an Stelle {tigerResolvedString} auf Wert {tigerResolvedString}")
    @When(value="TGR sets Rbel object {tigerResolvedString} at {tigerResolvedString} to new value {tigerResolvedString}")
    public void setValueAt(String objectName, String rbelPath, String newValue) {
        RbelBuilder rbelBuilder = this.rbelBuilders.get(objectName);
        rbelBuilder.setValueAt(rbelPath, newValue);
        this.logRbelBuilderChangesOptionally(objectName, rbelPath, newValue, rbelBuilder);
    }

    @Wenn(value="TGR erg\u00e4nzt Rbel-Objekt {tigerResolvedString} an Stelle {tigerResolvedString} um {tigerResolvedString}")
    @When(value="TGR extends Rbel object {tigerResolvedString} at path {tigerResolvedString} by a new entry {tigerResolvedString}")
    public void addEntryAt(String objectName, String rbelPath, String newEntry) {
        RbelBuilder rbelBuilder = this.rbelBuilders.get(objectName);
        rbelBuilder.addEntryAt(rbelPath, newEntry);
        this.logRbelBuilderChangesOptionally(objectName, rbelPath, newEntry, rbelBuilder);
    }

    @Wenn(value="TGR pr\u00fcft, dass Rbel-Objekt {tigerResolvedString} an Stelle {tigerResolvedString} gleich {tigerResolvedString} ist")
    @When(value="TGR asserts Rbel object {tigerResolvedString} at {tigerResolvedString} equals {tigerResolvedString}")
    public void assertValueAtEquals(String objectName, String rbelPath, String expectedValue) {
        RbelBuilder rbelBuilder = this.rbelBuilders.get(objectName);
        Assertions.assertEquals((Object)expectedValue, (Object)((RbelContentTreeNode)rbelBuilder.getTreeRootNode().findElement(rbelPath).orElseThrow()).getRawStringContent());
    }

    @Wenn(value="TGR pr\u00fcft, dass {tigerResolvedString} gleich {tigerResolvedString} mit Typ {rbelContentType} ist")
    @When(value="TGR asserts {tigerResolvedString} equals {tigerResolvedString} of type {rbelContentType}")
    public void assertJexlOutputEquals(String jexlExpressionActual, String jexlExpressionExpected, RbelContentType contentType) {
        RbelSerializationAssertion.assertEquals((String)jexlExpressionExpected, (String)jexlExpressionActual, (RbelContentType)contentType);
    }

    private void logMessageOptionally(String message) {
        if (TigerDirector.getLibConfig().createRbelModificationReports) {
            log.info(message.translateEscapes());
        }
    }

    private void logRbelBuilderChangesOptionally(String objectName, String rbelPath, String newValue, RbelBuilder rbelBuilder) {
        this.logMessageOptionally(String.format("Changed Rbel object '%s' at '%s' to '%s'", objectName, rbelPath, newValue));
        RbelElement asRbelElement = new RbelElement(rbelBuilder.getTreeRootNode().getContent(), null);
        this.logMessageOptionally("New Object: %s".formatted(asRbelElement.printTreeStructure()));
    }
}

