/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.visitor.VoidVisitor;
import de.gematik.test.tiger.glue.MethodVisitor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class AnnotationParser {
    private final String sourceFolder;
    private final String targetFolder;

    public AnnotationParser(String sourceFolder, String targetFolder) {
        this.sourceFolder = sourceFolder;
        this.targetFolder = targetFolder;
    }

    public static void main(String[] args) throws IOException {
        File f = new File(".");
        Object folder = "src/main/java/de/gematik/test/tiger/glue/";
        String docFolder = "../doc/user_manual/";
        if (!f.getAbsolutePath().endsWith("tiger-test-lib/.")) {
            folder = "tiger-test-lib/" + (String)folder;
            docFolder = "./doc/user_manual/";
        }
        AnnotationParser annotationParser = new AnnotationParser((String)folder, docFolder);
        annotationParser.extractJavaDocsToAdoc(args);
    }

    public void extractJavaDocsToAdoc(String[] args) throws IOException {
        for (String arg : args) {
            Path path = Paths.get(this.sourceFolder, arg);
            String lines = Files.readString(path, StandardCharsets.UTF_8);
            CompilationUnit compilationUnit = StaticJavaParser.parse((String)lines);
            ArrayList list = new ArrayList();
            compilationUnit.accept((VoidVisitor)new MethodVisitor(), list);
            String filename = arg.replace(".java", "CommentsOnly.adoc");
            String fileContent = AnnotationParser.formatLine(list.stream().collect(Collectors.joining(System.lineSeparator())));
            Files.writeString(Path.of(this.targetFolder, filename), (CharSequence)fileContent, StandardCharsets.UTF_8, new OpenOption[0]);
        }
    }

    public static String formatLine(String doc) {
        doc = doc.replaceAll("@(\\w+\\b)", "*$1*").replace("\n\\*", "\n\n*").replace("<p>", "").replaceAll("(<pre>|</pre>)", "----").replaceAll("(<b>|</b>)", "*").replace("<br>", "");
        AtomicBoolean isDescription = new AtomicBoolean(false);
        doc = Arrays.stream(doc.split("\n")).map(line -> {
            if (line.startsWith("TGR")) {
                isDescription.set(false);
                return "##### " + line;
            }
            if (line.trim().isEmpty()) {
                isDescription.set(false);
                return "";
            }
            if (!isDescription.get()) {
                isDescription.set(true);
                return "[.indent]\n" + line;
            }
            return line;
        }).collect(Collectors.joining("\n"));
        return doc;
    }
}

