/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.rbel;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelCborFacet;
import de.gematik.rbellogger.data.facet.RbelHttpHeaderFacet;
import de.gematik.rbellogger.data.facet.RbelHttpMessageFacet;
import de.gematik.rbellogger.data.facet.RbelHttpRequestFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelJsonFacet;
import de.gematik.rbellogger.data.facet.RbelRequestFacet;
import de.gematik.rbellogger.data.facet.RbelResponseFacet;
import de.gematik.rbellogger.data.facet.RbelValueFacet;
import de.gematik.rbellogger.data.facet.RbelXmlFacet;
import de.gematik.rbellogger.data.facet.TracingMessagePairFacet;
import de.gematik.rbellogger.util.RbelPathAble;
import de.gematik.rbellogger.util.RbelPathExecutor;
import de.gematik.test.tiger.LocalProxyRbelMessageListener;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import de.gematik.test.tiger.common.jexl.TigerJexlExecutor;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.lib.enums.ModeType;
import de.gematik.test.tiger.lib.json.JsonChecker;
import de.gematik.test.tiger.lib.json.JsonSchemaChecker;
import de.gematik.test.tiger.lib.rbel.RequestParameter;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.testenvmgr.TigerTestEnvMgr;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.xml.transform.Source;
import lombok.Generated;
import org.apache.commons.collections4.iterators.ReverseListIterator;
import org.apache.commons.collections4.list.UnmodifiableList;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xmlunit.builder.DiffBuilder;
import org.xmlunit.builder.Input;
import org.xmlunit.diff.ComparisonResult;
import org.xmlunit.diff.ComparisonType;
import org.xmlunit.diff.Diff;

public class RbelMessageValidator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMessageValidator.class);
    public static final String FOUND_IN_MESSAGES = "' found in messages";
    private static final TigerTypedConfigurationKey<Integer> RBEL_REQUEST_TIMEOUT = new TigerTypedConfigurationKey("tiger.rbel.request.timeout", Integer.class);
    private static final Map<String, UnaryOperator<DiffBuilder>> diffOptionMap = new HashMap<String, UnaryOperator<DiffBuilder>>();
    private static final List<String> emptyPath;
    private final TigerTestEnvMgr tigerTestEnvMgr;
    private final TigerProxy tigerProxy;
    protected static RbelElement currentRequest;
    protected static RbelElement currentResponse;

    public RbelMessageValidator() {
        this(TigerDirector.getTigerTestEnvMgr(), TigerDirector.getTigerTestEnvMgr().getLocalTigerProxyOrFail());
    }

    @VisibleForTesting
    public RbelMessageValidator(TigerTestEnvMgr tigerTestEnvMgr, TigerProxy tigerProxy) {
        TigerJexlExecutor.registerAdditionalNamespace((String)"rbel", (Object)new JexlToolbox());
        this.tigerTestEnvMgr = tigerTestEnvMgr;
        this.tigerProxy = tigerProxy;
    }

    public List<RbelElement> getRbelMessages() {
        this.tigerProxy.waitForAllCurrentMessagesToBeParsed();
        return new UnmodifiableList(new ArrayList<RbelElement>(LocalProxyRbelMessageListener.getInstance().getValidatableRbelMessages()));
    }

    public void clearRbelMessages() {
        LocalProxyRbelMessageListener.getInstance().clearValidatableRbelMessages();
    }

    public void filterRequestsAndStoreInContext(RequestParameter requestParameter) {
        int waitsec = RBEL_REQUEST_TIMEOUT.getValue().orElse(5);
        RbelMessageValidator.setCurrentRequest(this.findMessageByDescription(requestParameter));
        try {
            Awaitility.await((String)"Waiting for matching response").atMost((long)waitsec, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).until(() -> this.tigerTestEnvMgr.isShouldAbortTestExecution() || this.getRbelMessages().stream().filter(e -> e.hasFacet(RbelHttpResponseFacet.class)).filter(resp -> ((RbelHttpResponseFacet)resp.getFacetOrFail(RbelHttpResponseFacet.class)).getRequest() == currentRequest).map(rbelElement -> {
                RbelMessageValidator.setCurrentResponse(rbelElement);
                return rbelElement;
            }).findAny().isPresent());
            if (this.tigerTestEnvMgr.isShouldAbortTestExecution()) {
                throw new AssertionError((Object)"User aborted test run");
            }
        }
        catch (ConditionTimeoutException cte) {
            log.error("Missing response message to filtered request!\n\n{}", (Object)currentRequest.getRawStringContent());
            throw new TigerLibraryException("Missing response message to filtered request!", new Object[]{cte});
        }
    }

    public RbelElement waitForMessageToBePresent(RequestParameter requestParameter) {
        return this.findMessageByDescription(requestParameter);
    }

    protected RbelElement findMessageByDescription(RequestParameter requestParameter) {
        int waitsec = RBEL_REQUEST_TIMEOUT.getValue().orElse(5);
        Optional<RbelElement> initialElement = this.getInitialElement(requestParameter);
        AtomicReference candidate = new AtomicReference();
        try {
            Awaitility.await((String)"Waiting for matching request").atMost((long)waitsec, TimeUnit.SECONDS).pollDelay(0L, TimeUnit.SECONDS).pollInterval(400L, TimeUnit.MILLISECONDS).until(() -> {
                if (this.tigerTestEnvMgr.isShouldAbortTestExecution()) {
                    return true;
                }
                Optional<RbelElement> found = this.filterRequests(requestParameter, initialElement);
                found.ifPresent(candidate::set);
                return found.isPresent();
            });
            if (this.tigerTestEnvMgr.isShouldAbortTestExecution()) {
                throw new AssertionError((Object)"User aborted test run");
            }
        }
        catch (ConditionTimeoutException cte) {
            log.error("Didn't find any matching messages!");
            this.printAllPathsOfMessages(this.getRbelMessages());
            if (requestParameter.getPath() == null) {
                throw new AssertionError((Object)("No request with matching rbelPath '" + requestParameter.getRbelPath() + FOUND_IN_MESSAGES));
            }
            if (requestParameter.getRbelPath() == null) {
                throw new AssertionError((Object)("No request with path '" + requestParameter.getPath() + FOUND_IN_MESSAGES));
            }
            throw new AssertionError((Object)("No request with path '" + requestParameter.getPath() + "' and rbelPath '" + requestParameter.getRbelPath() + "' matching '" + StringUtils.abbreviate((String)requestParameter.getValue(), (int)300) + FOUND_IN_MESSAGES));
        }
        return (RbelElement)candidate.get();
    }

    private Optional<RbelElement> getInitialElement(RequestParameter requestParameter) {
        Deque<RbelElement> validatableRbelMessages = LocalProxyRbelMessageListener.getInstance().getValidatableRbelMessages();
        if (requestParameter.isStartFromLastRequest()) {
            return validatableRbelMessages.stream().dropWhile(msg -> msg != currentRequest).skip(1L).findFirst();
        }
        if (requestParameter.isRequireNewMessage() && !validatableRbelMessages.isEmpty()) {
            return Optional.ofNullable(validatableRbelMessages.getLast());
        }
        return Optional.empty();
    }

    protected Optional<RbelElement> filterRequests(RequestParameter requestParameter, Optional<RbelElement> startFromMessageInclusively) {
        String methodFilter;
        String hostFilter;
        List<RbelElement> msgs = this.getRbelElementsOptionallyFromGivenMessageInclusively(startFromMessageInclusively);
        List candidateMessages = this.getCandidateMessages(requestParameter, msgs, hostFilter = TigerGlobalConfiguration.readString((String)"tiger.rbel.request.filter.host", (String)""), methodFilter = TigerGlobalConfiguration.readString((String)"tiger.rbel.request.filter.method", (String)""));
        if (candidateMessages.isEmpty()) {
            return Optional.empty();
        }
        if (StringUtils.isEmpty((CharSequence)requestParameter.getRbelPath())) {
            if (candidateMessages.size() > 1) {
                String warnMsg = requestParameter.isFilterPreviousRequest() ? "last" : "first";
                log.warn("Found more then one candidate message. Returning " + warnMsg + " message. This may not be deterministic!");
                this.printAllPathsOfMessages(candidateMessages);
            }
            if (requestParameter.isFilterPreviousRequest()) {
                return Optional.of((RbelElement)candidateMessages.get(candidateMessages.size() - 1));
            }
            return Optional.of((RbelElement)candidateMessages.get(0));
        }
        if (requestParameter.isFilterPreviousRequest()) {
            candidateMessages = Lists.reverse(candidateMessages);
        }
        return this.filterMatchingCandidateMessages(requestParameter, candidateMessages);
    }

    private List<RbelElement> getRbelElementsOptionallyFromGivenMessageInclusively(Optional<RbelElement> startFromMessageExclusively) {
        List<RbelElement> msgs = this.getRbelMessages();
        if (startFromMessageExclusively.isPresent()) {
            int idx = -1;
            for (int i = 0; i < msgs.size(); ++i) {
                if (msgs.get(i) != startFromMessageExclusively.get()) continue;
                idx = i;
                break;
            }
            if (idx > 0) {
                msgs = new ArrayList<RbelElement>(msgs.subList(idx, msgs.size()));
            }
        }
        return msgs;
    }

    @NotNull
    private List<RbelElement> getCandidateMessages(RequestParameter requestParameter, List<RbelElement> msgs, String hostFilter, String methodFilter) {
        return msgs.stream().filter(el -> !requestParameter.isRequireHttpMessage() || el.hasFacet(RbelHttpRequestFacet.class)).filter(req -> this.doesPathOfMessageMatch((RbelElement)req, requestParameter.getPath())).filter(req -> hostFilter == null || hostFilter.isEmpty() || this.doesHostMatch((RbelElement)req, hostFilter)).filter(req -> methodFilter == null || methodFilter.isEmpty() || this.doesMethodMatch((RbelElement)req, methodFilter)).toList();
    }

    @NotNull
    private Optional<RbelElement> filterMatchingCandidateMessages(RequestParameter requestParameter, List<RbelElement> candidateMessages) {
        for (RbelElement candidateMessage : candidateMessages) {
            List pathExecutionResult = new RbelPathExecutor((RbelPathAble)candidateMessage, requestParameter.getRbelPath()).execute();
            if (pathExecutionResult.isEmpty()) continue;
            if (StringUtils.isEmpty((CharSequence)requestParameter.getValue())) {
                return Optional.of(candidateMessage);
            }
            String content = pathExecutionResult.stream().map(this::getValueOrContentString).map(String::trim).collect(Collectors.joining());
            try {
                if (content.equals(requestParameter.getValue()) || content.matches(requestParameter.getValue()) || Pattern.compile(requestParameter.getValue(), 32).matcher(content).matches()) {
                    return Optional.of(candidateMessage);
                }
                log.info("Found rbel node but \n'" + StringUtils.abbreviate((String)content, (int)300) + "' didnt match\n'" + StringUtils.abbreviate((String)requestParameter.getValue(), (int)300) + "'");
            }
            catch (Exception ex) {
                log.error("Failure while trying to apply regular expression '" + requestParameter.getValue() + "'!", (Throwable)ex);
            }
        }
        return Optional.empty();
    }

    public boolean doesPathOfMessageMatch(RbelElement req, String path) {
        if (path == null) {
            return true;
        }
        try {
            boolean match;
            URI uri = new URI(req.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getPath).map(this::getValueOrContentString).orElse(""));
            boolean bl = match = uri.getPath().equals(path) || uri.getPath().matches(path);
            if (!match && emptyPath.contains(path) && emptyPath.contains(uri.getPath())) {
                match = true;
            }
            return match;
        }
        catch (URISyntaxException e) {
            return false;
        }
        catch (PatternSyntaxException rte) {
            log.error("Error while parsing regex!", (Throwable)rte);
            return false;
        }
    }

    public boolean doesHostMatch(RbelElement req, String hostFilter) {
        try {
            String host = req.getFacet(RbelHttpMessageFacet.class).map(RbelHttpMessageFacet::getHeader).flatMap(el -> el.getFacet(RbelHttpHeaderFacet.class)).map(el -> el.get((Object)"Host")).map(RbelElement::getRawStringContent).orElse("");
            return StringUtils.equals((CharSequence)host, (CharSequence)hostFilter) || host.matches(hostFilter);
        }
        catch (RuntimeException rte) {
            log.error("Probable error while parsing regex!", (Throwable)rte);
            return false;
        }
    }

    public boolean doesMethodMatch(RbelElement req, String method) {
        try {
            String reqMethod = req.getFacet(RbelHttpRequestFacet.class).map(RbelHttpRequestFacet::getMethod).map(RbelElement::getRawStringContent).map(String::toUpperCase).orElse("");
            return method.equals(reqMethod) || method.matches(reqMethod);
        }
        catch (RuntimeException rte) {
            log.error("Probable error while parsing regex!", (Throwable)rte);
            return false;
        }
    }

    public void assertAttributeOfCurrentResponseMatches(String rbelPath, String value, boolean shouldMatch) {
        this.assertAttributesOfElements(rbelPath, value, shouldMatch, this.findElementsInCurrentResponse(rbelPath));
    }

    public void assertAttributeOfCurrentRequestMatches(String rbelPath, String value, boolean shouldMatch) {
        this.assertAttributesOfElements(rbelPath, value, shouldMatch, this.findElementsInCurrentRequest(rbelPath));
    }

    private void assertAttributesOfElements(String rbelPath, String value, boolean shouldMatch, List<RbelElement> elements) {
        String text = elements.stream().map(this::getValueOrContentString).filter(Objects::nonNull).map(String::trim).collect(Collectors.joining());
        Optional<Pattern> compiledPattern = Optional.ofNullable(value).filter(StringUtils::isNotBlank).map(v -> {
            try {
                return Pattern.compile(v, 40);
            }
            catch (PatternSyntaxException e) {
                return null;
            }
        });
        if (compiledPattern.isPresent()) {
            if (shouldMatch) {
                if (!text.equals(value)) {
                    ((AbstractStringAssert)Assertions.assertThat((String)text).as("Rbelpath '%s' matches", new Object[]{rbelPath})).matches(compiledPattern.get());
                }
            } else {
                if (text.equals(value)) {
                    Assertions.fail((String)("Did not expect that node '" + rbelPath + "' is equal to '" + value));
                }
                ((AbstractStringAssert)Assertions.assertThat((String)text).as("Rbelpath '%s' does not match", new Object[]{rbelPath})).doesNotMatch(compiledPattern.get());
            }
        }
    }

    private String getValueOrContentString(RbelElement elem) {
        return elem.printValue().orElseGet(() -> ((RbelElement)elem).getRawStringContent());
    }

    public void assertAttributeOfCurrentResponseMatchesAs(String rbelPath, ModeType mode, String oracle) {
        this.assertAttributeForMessage(mode, oracle, this.findElementInCurrentResponse(rbelPath));
    }

    public void assertAttributeOfCurrentRequestMatchesAs(String rbelPath, ModeType mode, String oracle) {
        this.assertAttributeForMessage(mode, oracle, this.findElementInCurrentRequest(rbelPath));
    }

    public void assertAttributeForMessage(ModeType mode, String oracle, RbelElement element) {
        switch (mode) {
            case JSON: {
                new JsonChecker().compareJsonStrings(this.getAsJsonString(element), oracle, false);
                break;
            }
            case XML: {
                this.compareXMLStructureOfRbelElement(element, oracle, "");
                break;
            }
            case JSON_SCHEMA: {
                new JsonSchemaChecker().compareJsonToSchema(this.getAsJsonString(element), oracle);
                break;
            }
            default: {
                Assertions.fail((String)("Type should either be JSON, JSON_SCHEMA, or XML, but you wrote '" + mode + "' instead."));
            }
        }
    }

    private String getAsJsonString(RbelElement target) {
        if (target.hasFacet(RbelJsonFacet.class)) {
            return target.getRawStringContent();
        }
        if (target.hasFacet(RbelCborFacet.class)) {
            return target.getFacet(RbelCborFacet.class).map(RbelCborFacet::getNode).map(JsonNode::toString).orElse("");
        }
        throw new AssertionError((Object)"Node is neither JSON nor CBOR, can not match with JSON");
    }

    private void printAllPathsOfMessages(List<RbelElement> msgs) {
        long requests = msgs.stream().filter(msg -> msg.getFacet(RbelHttpRequestFacet.class).isPresent()).count();
        log.info("Found the following {} messages:\n{} ", (Object)requests, (Object)msgs.stream().map(msg -> msg.getFacet(RbelHttpRequestFacet.class)).filter(Optional::isPresent).map(Optional::get).map(req -> "=>\t" + req.getPathAsString() + " : " + req.getChildElements()).collect(Collectors.joining("\n")));
    }

    public void compareXMLStructure(String test, String oracle, List<UnaryOperator<DiffBuilder>> diffOptions) {
        ArrayList diffs = new ArrayList();
        Source srcTest = Input.from((Object)test).build();
        Source srcOracle = Input.from((Object)oracle).build();
        DiffBuilder db = DiffBuilder.compare((Object)srcOracle).withTest((Object)srcTest);
        for (UnaryOperator<DiffBuilder> src : diffOptions) {
            db = (DiffBuilder)src.apply(db);
        }
        db = db.checkForSimilar();
        db.withDifferenceEvaluator((comparison, outcome) -> {
            if (outcome != ComparisonResult.EQUAL && (comparison.getType() == ComparisonType.NAMESPACE_URI || comparison.getType() == ComparisonType.NAMESPACE_PREFIX)) {
                return ComparisonResult.SIMILAR;
            }
            return outcome;
        });
        Diff diff = db.build();
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)diff.hasDifferences()).withFailMessage("XML tree mismatch!\n" + diff, new Object[0])).isFalse();
    }

    public void compareXMLStructure(String test, String oracle) {
        this.compareXMLStructure(test, oracle, Collections.emptyList());
    }

    public void compareXMLStructure(String test, String oracle, String diffOptionCSV) {
        ArrayList<UnaryOperator<DiffBuilder>> diffOptions = new ArrayList<UnaryOperator<DiffBuilder>>();
        Arrays.stream(diffOptionCSV.split(",")).map(String::trim).forEach(srcClassId -> {
            Assertions.assertThat(diffOptionMap).containsKey(srcClassId);
            diffOptions.add(diffOptionMap.get(srcClassId));
        });
        this.compareXMLStructure(test, oracle, diffOptions);
    }

    public void compareXMLStructureOfRbelElement(RbelElement el, String oracle, String diffOptionCSV) {
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)el.hasFacet(RbelXmlFacet.class)).withFailMessage("Node " + el.getKey() + " is not XML", new Object[0])).isTrue();
        this.compareXMLStructure(el.getRawStringContent(), oracle, diffOptionCSV);
    }

    public RbelElement findElementInCurrentResponse(String rbelPath) {
        try {
            List elems = currentResponse.findRbelPathMembers(rbelPath);
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("No node matching path '" + rbelPath + "'!", new Object[0])).isNotEmpty();
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("Expected exactly one match for path '" + rbelPath + "'!", new Object[0])).hasSize(1);
            return (RbelElement)elems.get(0);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to find element in last response for rbel path '" + rbelPath + "'"));
        }
    }

    public RbelElement findElementInCurrentRequest(String rbelPath) {
        try {
            List elems = currentRequest.findRbelPathMembers(rbelPath);
            if (elems.size() != 1) {
                log.warn("Could not find elements {} in message\n {}", (Object)rbelPath, (Object)currentRequest.printTreeStructureWithoutColors());
            }
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("No node matching path '" + rbelPath + "'!", new Object[0])).isNotEmpty();
            ((ListAssert)Assertions.assertThat((List)elems).withFailMessage("Expected exactly one match for path '" + rbelPath + "'!", new Object[0])).hasSize(1);
            return (RbelElement)elems.get(0);
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to find element in last request for rbel path '" + rbelPath + "'"));
        }
    }

    public List<RbelElement> findElementsInCurrentResponse(String rbelPath) {
        try {
            List elems = currentResponse.findRbelPathMembers(rbelPath);
            Assertions.assertThat((List)elems).isNotEmpty();
            return elems;
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to find element in last response for rbel path '" + rbelPath + "'"));
        }
    }

    public List<RbelElement> findElementsInCurrentRequest(String rbelPath) {
        try {
            List elems = currentRequest.findRbelPathMembers(rbelPath);
            Assertions.assertThat((List)elems).isNotEmpty();
            return elems;
        }
        catch (Exception e) {
            throw new AssertionError((Object)("Unable to find element in request for rbel path '" + rbelPath + "'"));
        }
    }

    public void findAnyMessageMatchingAtNode(String rbelPath, String value) {
        if (this.getRbelMessages().stream().map(msg -> {
            List findings = new RbelPathExecutor((RbelPathAble)msg, rbelPath).execute();
            if (findings.isEmpty()) {
                return null;
            }
            return this.getValueOrContentString((RbelElement)findings.get(0));
        }).filter(Objects::nonNull).filter(msg -> msg.equals(value)).findAny().isEmpty()) {
            throw new AssertionError((Object)("No message with matching value '" + value + "' at path '" + rbelPath + "'"));
        }
    }

    public void findLastRequest() {
        ReverseListIterator descendingIterator = new ReverseListIterator(this.getRbelMessages());
        RbelElement lastRequest = StreamSupport.stream(Spliterators.spliteratorUnknownSize(descendingIterator, 16), false).filter(msg -> msg.hasFacet(RbelRequestFacet.class)).findFirst().orElseThrow(() -> new TigerLibraryException("No Request found."));
        RbelMessageValidator.setCurrentRequest(lastRequest);
        RbelMessageValidator.setCurrentResponse(lastRequest.getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getResponse).orElse(null));
    }

    public void readTgrFile(String filePath) {
        List readElements = this.tigerProxy.readTrafficFromTgrFile(filePath);
        readElements.forEach(LocalProxyRbelMessageListener.getInstance()::triggerNewReceivedMessage);
    }

    @Generated
    protected static void setCurrentRequest(RbelElement currentRequest) {
        RbelMessageValidator.currentRequest = currentRequest;
    }

    @Generated
    public static RbelElement getCurrentRequest() {
        return currentRequest;
    }

    @Generated
    protected static void setCurrentResponse(RbelElement currentResponse) {
        RbelMessageValidator.currentResponse = currentResponse;
    }

    @Generated
    public static RbelElement getCurrentResponse() {
        return currentResponse;
    }

    static {
        diffOptionMap.put("nocomment", DiffBuilder::ignoreComments);
        diffOptionMap.put("txtignoreempty", DiffBuilder::ignoreElementContentWhitespace);
        diffOptionMap.put("txttrim", DiffBuilder::ignoreWhitespace);
        diffOptionMap.put("txtnormalize", DiffBuilder::normalizeWhitespace);
        emptyPath = List.of("", "/");
    }

    public class JexlToolbox {
        public String currentResponseAsString(String rbelPath) {
            return RbelMessageValidator.this.findElementInCurrentResponse(rbelPath).getRawStringContent();
        }

        public String currentResponseAsString() {
            return currentResponse.getRawStringContent();
        }

        public RbelElement currentResponse(String rbelPath) {
            return RbelMessageValidator.this.findElementInCurrentResponse(rbelPath);
        }

        public String currentRequestAsString(String rbelPath) {
            return RbelMessageValidator.this.getValueOrContentString(RbelMessageValidator.this.findElementInCurrentRequest(rbelPath));
        }

        public String currentRequestAsString() {
            return currentRequest.getRawStringContent();
        }

        public RbelElement currentRequest(String rbelPath) {
            return RbelMessageValidator.this.findElementInCurrentRequest(rbelPath);
        }

        public RbelElement lastResponse() {
            return this.lastMessageMatching(msg -> msg.hasFacet(RbelResponseFacet.class) || msg.hasFacet(RbelHttpResponseFacet.class));
        }

        public String lastResponseAsString() {
            return Optional.ofNullable(this.lastResponse()).map(RbelElement::getRawStringContent).orElseThrow(NoSuchElementException::new);
        }

        public RbelElement lastRequest() {
            return this.lastMessageMatching(msg -> msg.hasFacet(RbelRequestFacet.class) || msg.hasFacet(RbelHttpRequestFacet.class));
        }

        private RbelElement lastMessageMatching(Predicate<RbelElement> testMessage) {
            Iterator<RbelElement> backwardsIterator = LocalProxyRbelMessageListener.getInstance().getValidatableRbelMessages().descendingIterator();
            while (backwardsIterator.hasNext()) {
                RbelElement element = backwardsIterator.next();
                if (!testMessage.test(element)) continue;
                return element;
            }
            throw new NoSuchElementException();
        }

        public String lastRequestAsString() {
            return Optional.ofNullable(this.lastRequest()).map(RbelElement::getRawStringContent).orElseThrow(NoSuchElementException::new);
        }

        public String getValueAtLocationAsString(RbelElement element, String rbelPath) {
            return element.findElement(rbelPath).flatMap(el -> el.getFacet(RbelValueFacet.class)).map(RbelValueFacet::getValue).map(Object::toString).orElseThrow(() -> new NoSuchElementException("Unable to find a matching element for '" + rbelPath + "'"));
        }
    }
}

