/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger;

import com.google.common.annotations.VisibleForTesting;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.util.IRbelMessageListener;
import de.gematik.rbellogger.util.RbelMessagesSupplier;
import de.gematik.test.tiger.DoNothingSupplier;
import de.gematik.test.tiger.lib.TigerDirector;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProxyRbelMessageListener
implements IRbelMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalProxyRbelMessageListener.class);
    private final RbelMessagesSupplier messagesSupplier;
    private RbelElement lastDeletedElement = null;
    private final List<RbelElement> rbelMessages = new ArrayList<RbelElement>();
    private final List<RbelElement> stepRbelMessages = new ArrayList<RbelElement>();
    private static LocalProxyRbelMessageListener instance;

    public static LocalProxyRbelMessageListener getInstance() {
        LocalProxyRbelMessageListener.initialize();
        return instance;
    }

    public static void initialize() {
        if (instance == null) {
            instance = new LocalProxyRbelMessageListener();
        }
    }

    @VisibleForTesting
    public static void setTestingInstance(LocalProxyRbelMessageListener instanceForTesting) {
        instance = instanceForTesting;
    }

    @VisibleForTesting
    public static void clearTestingInstance() {
        instance = null;
    }

    public LocalProxyRbelMessageListener(RbelMessagesSupplier messagesSupplier) {
        this.messagesSupplier = messagesSupplier;
        messagesSupplier.addRbelMessageListener((IRbelMessageListener)this);
    }

    public LocalProxyRbelMessageListener() {
        this(TigerDirector.getTigerTestEnvMgr().getLocalTigerProxyOptional().map(RbelMessagesSupplier.class::cast).orElse(new DoNothingSupplier()));
    }

    public void triggerNewReceivedMessage(RbelElement e) {
        this.rbelMessages.add(e);
        this.stepRbelMessages.add(e);
    }

    public void clearMessages() {
        this.rbelMessages.clear();
    }

    public List<RbelElement> getMessages() {
        return Collections.unmodifiableList(this.rbelMessages);
    }

    public void clearValidatableRbelMessages() {
        Deque messageHistory = this.messagesSupplier.getRbelMessages();
        this.lastDeletedElement = messageHistory.isEmpty() ? null : (RbelElement)messageHistory.getLast();
    }

    public Deque<RbelElement> getValidatableRbelMessages() {
        return this.messagesSupplier.getRbelMessages().stream().dropWhile(e -> this.lastDeletedElement != null && e != this.lastDeletedElement).collect(Collectors.toCollection(ArrayDeque::new));
    }

    @Generated
    public List<RbelElement> getStepRbelMessages() {
        return this.stepRbelMessages;
    }
}

