/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.TigerLibConfig;
import de.gematik.test.tiger.lib.enums.ModeType;
import io.cucumber.java.ParameterType;
import io.restassured.http.Method;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class TigerParameterTypeDefinitions {
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    private static RbelLogger rbelLogger;
    private static RbelWriter rbelWriter;

    protected TigerParameterTypeDefinitions() {
    }

    @ParameterType(value="GET|POST|DELETE|PUT|OPTIONS|\".*\"|'.*'")
    public static Method requestType(String name) {
        return Method.valueOf((String)TigerParameterTypeDefinitions.resolveToString(name));
    }

    @ParameterType(value="XML|JSON|\".*\"|'.*'")
    public static ModeType modeType(String mode) {
        return ModeType.valueOf(TigerParameterTypeDefinitions.resolveToString(mode));
    }

    @ParameterType(value="\".*\"|'.*'")
    public static String tigerResolvedString(String string) {
        return TigerParameterTypeDefinitions.resolveToString(string);
    }

    @ParameterType(value="\".*\"|'.*'")
    @NotNull
    public static URI tigerResolvedUrl(String address) {
        return new URI(TigerParameterTypeDefinitions.resolveToString(address));
    }

    @ParameterType(value="XML|JSON|JWE|JWT|BEARER_TOKEN|URL|\".*\"|'.*'")
    public static RbelContentType rbelContentType(String value) {
        return RbelContentType.seekValueFor((String)TigerParameterTypeDefinitions.resolveToString(value));
    }

    private static String resolveToString(String value) {
        if (value.charAt(0) == '\"' || value.charAt(0) == '\'') {
            return TigerParameterTypeDefinitions.resolve(value.substring(1, value.length() - 1)).getContentAsString();
        }
        return TigerParameterTypeDefinitions.resolve(value).getContentAsString();
    }

    private static RbelSerializationResult resolve(String value) {
        String resolvedInput = TigerGlobalConfiguration.resolvePlaceholders((String)value);
        TigerLibConfig libConfig = TigerDirector.getLibConfig();
        if (libConfig != null && libConfig.getHttpClientConfig().isActivateRbelWriter()) {
            RbelElement input = TigerParameterTypeDefinitions.getRbelConverter().convertElement(resolvedInput, null);
            return TigerParameterTypeDefinitions.getRbelWriter().serialize(input, new TigerJexlContext().withRootElement((Object)input));
        }
        return RbelSerializationResult.withUnknownType((byte[])resolvedInput.getBytes(DEFAULT_CHARSET));
    }

    private static RbelWriter getRbelWriter() {
        TigerParameterTypeDefinitions.assureRbelIsInitialized();
        return rbelWriter;
    }

    private static RbelConverter getRbelConverter() {
        TigerParameterTypeDefinitions.assureRbelIsInitialized();
        return rbelLogger.getRbelConverter();
    }

    private static synchronized void assureRbelIsInitialized() {
        if (rbelWriter == null) {
            rbelLogger = RbelLogger.build((RbelConfiguration)RbelConfiguration.builder().activateAsn1Parsing(true).initializers(Optional.ofNullable(TigerDirector.getTigerTestEnvMgr().getConfiguration().getTigerProxy().getKeyFolders()).stream().flatMap(Collection::stream).map(RbelKeyFolderInitializer::new).map(init -> init).toList()).build());
            rbelWriter = new RbelWriter(rbelLogger.getRbelConverter());
        }
    }
}

