/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.common.config.SourceType;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.glue.TigerParameterTypeDefinitions;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.lib.enums.ModeType;
import de.gematik.test.tiger.lib.rbel.RbelMessageValidator;
import de.gematik.test.tiger.lib.rbel.RequestParameter;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Gegebensei;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.Given;
import io.cucumber.java.en.Then;
import io.cucumber.java.en.When;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.Assertions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RBelValidatorGlue {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RBelValidatorGlue.class);
    private final RbelMessageValidator rbelValidator;

    public RBelValidatorGlue(RbelMessageValidator rbelValidator) {
        this.rbelValidator = rbelValidator;
    }

    public RBelValidatorGlue() {
        this(new RbelMessageValidator());
    }

    @Gegebensei(value="TGR setze Anfrage Timeout auf {int} Sekunden")
    @Given(value="TGR set request wait timeout to {int} seconds")
    public void tgrSetRequestWaitTimeout(int waitsec) {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.timeout", (Object)waitsec, (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR l\u00f6sche aufgezeichnete Nachrichten")
    @When(value="TGR clear recorded messages")
    public void tgrClearRecordedMessages() {
        this.rbelValidator.clearRbelMessages();
    }

    @Wenn(value="TGR filtere Anfragen nach Server {tigerResolvedString}")
    @When(value="TGR filter requests based on host {tigerResolvedString}")
    public void tgrFilterBasedOnHost(String hostname) {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.filter.host", (String)hostname, (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR filtere Anfragen nach HTTP Methode {tigerResolvedString}")
    @When(value="TGR filter requests based on method {tigerResolvedString}")
    public void tgrFilterBasedOnMethod(String method) {
        TigerGlobalConfiguration.putValue((String)"tiger.rbel.request.filter.method", (String)method.toUpperCase(), (SourceType)SourceType.TEST_CONTEXT);
    }

    @Wenn(value="TGR l\u00f6sche den gesetzten HTTP Methodenfilter")
    @When(value="TGR reset request method filter")
    public void tgrResetRequestMethodFilter() {
        TigerGlobalConfiguration.deleteFromAllSources((TigerConfigurationKey)new TigerConfigurationKey(new String[]{"tiger.rbel.request.filter.method"}));
    }

    @Wenn(value="TGR warte auf eine Nachricht, in der Knoten {tigerResolvedString} mit {tigerResolvedString} \u00fcbereinstimmt")
    @When(value="TGR wait for message with node {tigerResolvedString} matching {tigerResolvedString}")
    public void waitForMessageWithValue(String rbelPath, String value) {
        this.rbelValidator.waitForMessageToBePresent(RequestParameter.builder().rbelPath(rbelPath).value(value).requireHttpMessage(false).build());
    }

    @Wenn(value="TGR warte auf eine neue Nachricht, in der Knoten {tigerResolvedString} mit {tigerResolvedString} \u00fcbereinstimmt")
    @When(value="TGR wait for new message with node {tigerResolvedString} matching {tigerResolvedString}")
    public void waitForNewMessageWithValue(String rbelPath, String value) {
        this.rbelValidator.waitForMessageToBePresent(RequestParameter.builder().rbelPath(rbelPath).value(value).requireNewMessage(true).requireHttpMessage(false).build());
    }

    @Wenn(value="TGR finde die erste Anfrage mit Pfad {string}")
    @When(value="TGR find request to path {string}")
    public void findRequestToPath(String path) {
        this.rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die erste Anfrage mit Pfad {string} und Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR find request to path {string} with {string} matching {string}")
    public void findRequestToPathWithCommand(String path, String rbelPath, String value) {
        this.rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).value(value).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die n\u00e4chste Anfrage mit dem Pfad {string}")
    @When(value="TGR find next request to path {string}")
    public void findNextRequestToPath(String path) {
        this.rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).startFromLastRequest(true).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die n\u00e4chste Anfrage mit Pfad {string} und Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR find next request to path {string} with {string} matching {string}")
    public void findNextRequestToPathWithCommand(String path, String rbelPath, String value) {
        this.rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).value(value).startFromLastRequest(true).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die erste Anfrage mit Pfad {string} die den Knoten {string} enth\u00e4lt")
    @When(value="TGR find request to path {string} containing node {string}")
    public void findFirstRequestToPathContainingNode(String path, String rbelPath) {
        this.rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die n\u00e4chste Anfrage mit Pfad {string} die den Knoten {string} enth\u00e4lt")
    @When(value="TGR find next request to path {string} containing node {string}")
    public void findNextRequestToPathContainingNode(String path, String rbelPath) {
        this.rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die letzte Anfrage mit dem Pfad {string}")
    @When(value="TGR find last request to path {string}")
    public void findLastRequestToPath(String path) {
        this.rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).filterPreviousRequest(true).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die letzte Anfrage mit Pfad {string} und Knoten {string} der mit {string} \u00fcbereinstimmt")
    @When(value="TGR find last request to path {string} with {string} matching {string}")
    public void findLastRequestToPathWithCommand(String path, String rbelPath, String value) {
        this.rbelValidator.filterRequestsAndStoreInContext(RequestParameter.builder().path(path).rbelPath(rbelPath).value(value).filterPreviousRequest(true).build().resolvePlaceholders());
    }

    @Wenn(value="TGR finde die letzte Anfrage")
    @When(value="TGR find the last request")
    public void findLastRequest() {
        this.rbelValidator.findLastRequest();
    }

    @Wenn(value="TGR finde eine Nachricht mit Knoten {tigerResolvedString} der mit {tigerResolvedString} \u00fcbereinstimmt")
    @When(value="TGR any message with attribute {tigerResolvedString} matches {tigerResolvedString}")
    @Deprecated(forRemoval=true)
    public void findAnyMessageAttributeMatches(String rbelPath, String value) {
        this.rbelValidator.findAnyMessageMatchingAtNode(rbelPath, value);
    }

    @Dann(value="TGR pr\u00fcfe aktueller Request stimmt im Body \u00fcberein mit:")
    @Then(value="TGR current request body matches:")
    public void currentRequestBodyMatches(String docString) {
        this.currentRequestMessageAttributeMatches("$.body", TigerParameterTypeDefinitions.tigerResolvedString(docString));
    }

    @Dann(value="TGR pr\u00fcfe aktueller Request stimmt im Knoten {tigerResolvedString} \u00fcberein mit {tigerResolvedString}")
    @Then(value="TGR current request with attribute {tigerResolvedString} matches {tigerResolvedString}")
    public void currentRequestMessageAttributeMatches(String rbelPath, String value) {
        this.rbelValidator.assertAttributeOfCurrentRequestMatches(rbelPath, value, true);
    }

    @Dann(value="TGR pr\u00fcfe aktueller Request enth\u00e4lt Knoten {tigerResolvedString}")
    @Then(value="TGR current request contains node {tigerResolvedString}")
    public void currentRequestMessageContainsNode(String rbelPath) {
        Assertions.assertThat(this.rbelValidator.findElementsInCurrentRequest(rbelPath)).isNotEmpty();
    }

    @Dann(value="TGR pr\u00fcfe aktueller Request im Knoten {tigerResolvedString} stimmt \u00fcberein mit:")
    @Then(value="TGR current request at {tigerResolvedString} matches:")
    public void currentRequestMessageAtMatchesDocString(String rbelPath, String docString) {
        this.currentRequestMessageAttributeMatches(rbelPath, docString);
    }

    @Dann(value="TGR pr\u00fcfe aktueller Request im Knoten {tigerResolvedString} stimmt als {modeType} \u00fcberein mit:")
    @Then(value="TGR current request at {tigerResolvedString} matches as {modeType}:")
    public void currentRequestAtMatchesAsJsonOrXml(String rbelPath, ModeType mode, String oracleDocStr) {
        this.rbelValidator.assertAttributeOfCurrentRequestMatchesAs(rbelPath, mode, TigerGlobalConfiguration.resolvePlaceholders((String)oracleDocStr));
    }

    @Dann(value="TGR pr\u00fcfe aktueller Request stimmt im Knoten {tigerResolvedString} nicht \u00fcberein mit {tigerResolvedString}")
    @Then(value="TGR current request with attribute {tigerResolvedString} does not match {tigerResolvedString}")
    public void currentRequestMessageAttributeDoesNotMatch(String rbelPath, String value) {
        this.rbelValidator.assertAttributeOfCurrentRequestMatches(rbelPath, value, false);
    }

    @Dann(value="TGR speichere Wert des Knotens {tigerResolvedString} der aktuellen Antwort in der Variable {tigerResolvedString}")
    @Then(value="TGR store current response node text value at {tigerResolvedString} in variable {tigerResolvedString}")
    public void storeCurrentResponseNodeTextValueInVariable(String rbelPath, String varName) {
        String text = this.rbelValidator.findElementsInCurrentResponse(rbelPath).stream().map(RbelElement::getRawStringContent).filter(Objects::nonNull).map(String::trim).collect(Collectors.joining());
        TigerGlobalConfiguration.putValue((String)varName, (String)text, (SourceType)SourceType.TEST_CONTEXT);
        log.info(String.format("Storing '%s' in variable '%s'", text, varName));
    }

    @Dann(value="TGR ersetze {tigerResolvedString} mit {tigerResolvedString} im Inhalt der Variable {tigerResolvedString}")
    @Then(value="TGR replace {tigerResolvedString} with {tigerResolvedString} in content of variable {tigerResolvedString}")
    public void replaceContentOfVariable(String regexPattern, String replace, String varName) {
        String newContent = ((String)TigerGlobalConfiguration.readStringOptional((String)varName).orElseThrow(() -> new TigerLibraryException("No configuration property '" + varName + "' found!"))).replaceAll(regexPattern, replace);
        TigerGlobalConfiguration.putValue((String)varName, (String)newContent, (SourceType)SourceType.TEST_CONTEXT);
        log.info(String.format("Modified content in variable '%s' to '%s'", varName, newContent));
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort stimmt im Body \u00fcberein mit:")
    @Then(value="TGR current response body matches:")
    public void currentResponseBodyMatches(String docString) {
        this.currentResponseMessageAttributeMatches("$.body", TigerParameterTypeDefinitions.tigerResolvedString(docString));
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort enth\u00e4lt Knoten {tigerResolvedString}")
    @Then(value="TGR current response contains node {tigerResolvedString}")
    public void currentResponseMessageContainsNode(String rbelPath) {
        Assertions.assertThat(this.rbelValidator.findElementsInCurrentResponse(rbelPath)).isNotEmpty();
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort stimmt im Knoten {tigerResolvedString} \u00fcberein mit {tigerResolvedString}")
    @Then(value="TGR current response with attribute {tigerResolvedString} matches {tigerResolvedString}")
    public void currentResponseMessageAttributeMatches(String rbelPath, String value) {
        this.rbelValidator.assertAttributeOfCurrentResponseMatches(rbelPath, value, true);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort stimmt im Knoten {tigerResolvedString} nicht \u00fcberein mit {tigerResolvedString}")
    @Then(value="TGR current response with attribute {tigerResolvedString} does not match {tigerResolvedString}")
    public void currentResponseMessageAttributeDoesNotMatch(String rbelPath, String value) {
        this.rbelValidator.assertAttributeOfCurrentResponseMatches(rbelPath, value, false);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {tigerResolvedString} stimmt \u00fcberein mit:")
    @Then(value="TGR current response at {tigerResolvedString} matches:")
    public void currentResponseMessageAtMatchesDocString(String rbelPath, String docString) {
        this.currentResponseMessageAttributeMatches(rbelPath, docString);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {tigerResolvedString} stimmt nicht \u00fcberein mit:")
    @Then(value="TGR current response at {tigerResolvedString} does not match:")
    public void currentResponseMessageAtDoesNotMatchDocString(String rbelPath, String docString) {
        this.rbelValidator.assertAttributeOfCurrentResponseMatches(rbelPath, TigerGlobalConfiguration.resolvePlaceholders((String)docString), false);
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {tigerResolvedString} stimmt als {modeType} \u00fcberein mit:")
    @Then(value="TGR current response at {tigerResolvedString} matches as {modeType}:")
    public void currentResponseAtMatchesAsJsonOrXml(String rbelPath, ModeType mode, String oracleDocStr) {
        this.rbelValidator.assertAttributeOfCurrentResponseMatchesAs(rbelPath, mode, TigerGlobalConfiguration.resolvePlaceholders((String)oracleDocStr));
    }

    @Dann(value="TGR pr\u00fcfe aktuelle Antwort im Knoten {tigerResolvedString} stimmt als XML mit folgenden diff Optionen {tigerResolvedString} \u00fcberein mit:")
    @Then(value="TGR current response at {tigerResolvedString} matches as XML and diff options {tigerResolvedString}:")
    public void currentResponseAtMatchesAsXMLAndDiffOptions(String rbelPath, String diffOptionsCSV, String xmlDocStr) {
        this.rbelValidator.compareXMLStructureOfRbelElement(this.rbelValidator.findElementInCurrentResponse(rbelPath), TigerGlobalConfiguration.resolvePlaceholders((String)xmlDocStr), diffOptionsCSV);
    }

    @Dann(value="TGR gebe alle Nachrichten als Rbel-Tree aus")
    @Then(value="TGR print all messages as rbel-tree")
    public void printAllMessages() {
        this.getRbelValidator().getRbelMessages().forEach(message -> System.out.println(StringUtils.repeat((char)'=', (int)80) + "\n" + message.printTreeStructure()));
    }

    @Dann(value="TGR gebe aktuelle Response als Rbel-Tree aus")
    @Then(value="TGR print current response as rbel-tree")
    public void printCurrentResponse() {
        System.out.println(this.getRbelValidator().getCurrentResponse().printTreeStructure());
    }

    @Dann(value="TGR gebe aktuelle Request als Rbel-Tree aus")
    @Then(value="TGR print current request as rbel-tree")
    public void printCurrentRequest() {
        System.out.println(this.getRbelValidator().getCurrentRequest().printTreeStructure());
    }

    @Dann(value="TGR liest folgende .tgr Datei {tigerResolvedString}")
    @Then(value="TGR reads the following .tgr file {tigerResolvedString}")
    public void readTgrFile(String filePath) {
        this.rbelValidator.readTgrFile(filePath);
    }

    @Generated
    public RbelMessageValidator getRbelValidator() {
        return this.rbelValidator;
    }
}

