/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.glue;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.writer.RbelContentType;
import de.gematik.rbellogger.writer.RbelSerializationResult;
import de.gematik.rbellogger.writer.RbelWriter;
import de.gematik.test.tiger.common.config.TigerConfigurationKey;
import de.gematik.test.tiger.common.config.TigerGlobalConfiguration;
import de.gematik.test.tiger.common.config.TigerTypedConfigurationKey;
import de.gematik.test.tiger.common.jexl.TigerJexlContext;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.exception.TigerHttpGlueCodeException;
import io.cucumber.datatable.DataTable;
import io.cucumber.java.de.Dann;
import io.cucumber.java.de.Wenn;
import io.cucumber.java.en.When;
import io.restassured.RestAssured;
import io.restassured.config.EncoderConfig;
import io.restassured.config.RedirectConfig;
import io.restassured.http.Method;
import io.restassured.internal.RequestSpecificationImpl;
import io.restassured.specification.QueryableRequestSpecification;
import io.restassured.specification.RequestSpecification;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.assertj.core.api.SoftAssertionsProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpGlueCode {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpGlueCode.class);
    public static final String KEY_HTTP_CLIENT = "httpClient";
    public static final String KEY_TIGER = "tiger";
    private static final TigerTypedConfigurationKey<Boolean> executeBlocking = new TigerTypedConfigurationKey(new TigerConfigurationKey(new String[]{"tiger", "httpClient", "executeBlocking"}), Boolean.class, (Object)true);
    private static final Charset DEFAULT_CHARSET = StandardCharsets.UTF_8;
    public static final String KEY_DEFAULT_HEADER = "defaultHeader";
    private static RbelLogger rbelLogger;
    private static RbelWriter rbelWriter;

    private static RequestSpecification givenDefaultSpec() {
        EncoderConfig encoderConfig = RestAssured.config().getEncoderConfig().appendDefaultContentCharsetToContentTypeIfUndefined(true);
        RequestSpecification requestSpecification = RestAssured.given().urlEncodingEnabled(false).config(RestAssured.config().encoderConfig(encoderConfig));
        requestSpecification.headers(TigerGlobalConfiguration.readMap((String[])new String[]{KEY_TIGER, KEY_HTTP_CLIENT, KEY_DEFAULT_HEADER}));
        HttpGlueCode.contentTypeFromRequestSpec(requestSpecification).ifPresent(ct -> HttpGlueCode.setExactContentTypeHeader(requestSpecification, ct));
        return requestSpecification;
    }

    private static void applyRedirectConfig(RedirectConfig newRedirectConfig) {
        RestAssured.config = RestAssured.config.redirect(newRedirectConfig);
    }

    private static void resetRedirectConfig() {
        HttpGlueCode.applyRedirectConfig(new RedirectConfig());
    }

    private static String resolveToString(String value) {
        return HttpGlueCode.resolve(value).getContentAsString();
    }

    private static RbelSerializationResult resolve(String value) {
        String resolvedInput = TigerGlobalConfiguration.resolvePlaceholders((String)value);
        if (TigerDirector.getLibConfig().getHttpClientConfig().isActivateRbelWriter()) {
            RbelElement input = HttpGlueCode.getRbelConverter().convertElement(resolvedInput, null);
            return HttpGlueCode.getRbelWriter().serialize(input, new TigerJexlContext().withRootElement((Object)input));
        }
        return RbelSerializationResult.withUnknownType((byte[])resolvedInput.getBytes(DEFAULT_CHARSET));
    }

    private static void executeCommandWithContingentWait(SoftAssertionsProvider.ThrowingRunnable command) {
        if (Boolean.TRUE.equals(executeBlocking.getValueOrDefault())) {
            try {
                command.run();
            }
            catch (Exception e) {
                throw new TigerHttpGlueCodeException("Error during request execution", e);
            }
        } else {
            HttpGlueCode.executeCommandInBackground(command);
        }
    }

    private static void executeCommandInBackground(SoftAssertionsProvider.ThrowingRunnable command) {
        TigerDirector.getTigerTestEnvMgr().getCachedExecutor().submit(() -> {
            try {
                command.run();
            }
            catch (Exception e) {
                throw new TigerHttpGlueCodeException("Error during request execution", e);
            }
        });
    }

    private static RbelWriter getRbelWriter() {
        HttpGlueCode.assureRbelIsInitialized();
        return rbelWriter;
    }

    private static RbelConverter getRbelConverter() {
        HttpGlueCode.assureRbelIsInitialized();
        return rbelLogger.getRbelConverter();
    }

    private static void assureRbelIsInitialized() {
        if (rbelWriter == null) {
            rbelLogger = RbelLogger.build((RbelConfiguration)RbelConfiguration.builder().activateAsn1Parsing(true).initializers(Optional.ofNullable(TigerDirector.getTigerTestEnvMgr().getConfiguration().getTigerProxy().getKeyFolders()).stream().flatMap(Collection::stream).map(RbelKeyFolderInitializer::new).map(init -> init).toList()).build());
            rbelWriter = new RbelWriter(rbelLogger.getRbelConverter());
        }
    }

    @When(value="TGR send empty {requestType} request to {tigerResolvedUrl}")
    @Wenn(value="TGR eine leere {requestType} Anfrage an {tigerResolvedUrl} sendet")
    @Dann(value="TGR sende eine leere {requestType} Anfrage an {tigerResolvedUrl}")
    public void sendEmptyRequest(Method method, URI address) {
        log.info("Sending empty {} request to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.givenDefaultSpec().request(method, address));
    }

    @When(value="TGR send empty {requestType} request to {tigerResolvedUrl} without waiting for the response")
    @Dann(value="TGR sende eine leere {requestType} Anfrage an {tigerResolvedUrl} ohne auf Antwort zu warten")
    public void sendEmptyRequestNonBlocking(Method method, URI address) {
        log.info("Sending empty {} request to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandInBackground(() -> HttpGlueCode.givenDefaultSpec().request(method, address));
    }

    @When(value="TGR send empty {requestType} request to {tigerResolvedUrl} with headers:")
    @Wenn(value="TGR eine leere {requestType} Anfrage an {tigerResolvedUrl} und den folgenden Headern sendet:")
    @Dann(value="TGR sende eine leere {requestType} Anfrage an {tigerResolvedUrl} mit folgenden Headern:")
    public void sendEmptyRequestWithHeaders(Method method, URI address, DataTable customHeaders) {
        log.info("Sending empty {} request with headers to {}", (Object)method, (Object)address);
        Map defaultHeaders = TigerGlobalConfiguration.readMap((String[])new String[]{KEY_TIGER, KEY_HTTP_CLIENT, KEY_DEFAULT_HEADER});
        defaultHeaders.putAll(this.resolveMap(customHeaders.asMap(), false));
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.givenDefaultSpec().headers(defaultHeaders).request(method, address));
    }

    @When(value="TGR send empty {requestType} request to {tigerResolvedUrl} without waiting for the response with headers:")
    @Dann(value="TGR sende eine leere {requestType} Anfrage an {tigerResolvedUrl} ohne auf Antwort zu warten mit folgenden Headern:")
    public void sendEmptyRequestWithHeadersNonBlocking(Method method, URI address, DataTable customHeaders) {
        log.info("Sending empty {} request with headers to {}", (Object)method, (Object)address);
        Map defaultHeaders = TigerGlobalConfiguration.readMap((String[])new String[]{KEY_TIGER, KEY_HTTP_CLIENT, KEY_DEFAULT_HEADER});
        defaultHeaders.putAll(this.resolveMap(customHeaders.asMap(), false));
        HttpGlueCode.executeCommandInBackground(() -> HttpGlueCode.givenDefaultSpec().headers(defaultHeaders).request(method, address));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with body {string}")
    @Wenn(value="TGR eine leere {requestType} Anfrage an {tigerResolvedUrl} und dem folgenden body {string} sendet")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit Body {string}")
    public void sendRequestWithBody(Method method, URI address, String body) {
        log.info("Sending {} request with body to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.sendResolvedBody(method, address, body));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with body {string} without waiting for the response")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit Body {string} ohne auf Antwort zu warten")
    public void sendRequestWithBodyNonBlocking(Method method, URI address, String body) {
        log.info("Sending {} request with body to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandInBackground(() -> HttpGlueCode.sendResolvedBody(method, address, body));
    }

    private static void sendResolvedBody(Method method, URI address, String body) {
        HttpGlueCode.sendResolvedBody(method, address, null, body);
    }

    private static void sendResolvedBody(Method method, URI address, String contentType, String body) {
        RbelSerializationResult resolved = HttpGlueCode.resolve(body);
        RequestSpecification requestSpecification = HttpGlueCode.givenDefaultSpec();
        if (contentType != null) {
            HttpGlueCode.setExactContentTypeHeader(requestSpecification, contentType);
        }
        resolved.getContentType().map(RbelContentType::getContentTypeString).filter(o -> StringUtils.isEmpty((CharSequence)((RequestSpecificationImpl)requestSpecification).getContentType())).ifPresent(arg_0 -> ((RequestSpecification)requestSpecification).contentType(arg_0));
        requestSpecification.body(resolved.getContent()).request(method, address);
    }

    private static Optional<String> contentTypeFromRequestSpec(RequestSpecification requestSpecification) {
        return Optional.ofNullable(((QueryableRequestSpecification)requestSpecification).getContentType());
    }

    private static void setExactContentTypeHeader(RequestSpecification requestSpecification, String contentType) {
        requestSpecification.config(RestAssured.config().encoderConfig(EncoderConfig.encoderConfig().appendDefaultContentCharsetToContentTypeIfUndefined(false)));
        requestSpecification.contentType(contentType);
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with:")
    @Wenn(value="TGR eine {requestType} Anfrage an {tigerResolvedUrl} mit den folgenden Daten sendet:")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit folgenden Daten:")
    public void sendRequestWithParams(Method method, URI address, DataTable parameters) {
        List dataAsMaps = parameters.asMaps();
        if (dataAsMaps.size() != 1) {
            throw new AssertionError((Object)("Expected exactly one entry for data table, got " + dataAsMaps.size()));
        }
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.givenDefaultSpec().formParams(this.resolveMap((Map)dataAsMaps.get(0), true)).request(method, address));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with multiline body:")
    @Wenn(value="TGR eine {requestType} Anfrage an {tigerResolvedUrl} mit den folgenden mehrzeiligen Daten sendet:")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit folgenden mehrzeiligen Daten:")
    public void sendRequestWithMultiLineBody(Method method, URI address, String body) {
        log.info("Sending complex {} request with body to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.sendResolvedBody(method, address, body));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} with contentType {string} and multiline body:")
    @Wenn(value="TGR eine {requestType} Anfrage an {tigerResolvedUrl} mit ContentType {string} und den folgenden mehrzeiligen Daten sendet:")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} mit ContentType {string} und folgenden mehrzeiligen Daten:")
    public void sendRequestWithMultiLineBody(Method method, URI address, String contentType, String body) {
        log.info("Sending complex {} request with body to {}", (Object)method, (Object)address);
        HttpGlueCode.executeCommandWithContingentWait(() -> HttpGlueCode.sendResolvedBody(method, address, contentType, body));
    }

    @When(value="TGR send {requestType} request to {tigerResolvedUrl} without waiting for the response with:")
    @Dann(value="TGR sende eine {requestType} Anfrage an {tigerResolvedUrl} ohne auf Antwort zu warten mit folgenden Daten:")
    public void sendRequestWithParamsNonBlocking(Method method, URI address, DataTable parameters) {
        List dataAsMaps = parameters.asMaps();
        if (dataAsMaps.size() != 1) {
            throw new AssertionError((Object)("Expected exactly one entry for data table, got " + dataAsMaps.size()));
        }
        HttpGlueCode.executeCommandInBackground(() -> HttpGlueCode.givenDefaultSpec().formParams(this.resolveMap((Map)dataAsMaps.get(0), true)).request(method, address));
    }

    @When(value="TGR set default header {tigerResolvedString} to {tigerResolvedString}")
    @Wenn(value="TGR den default header {tigerResolvedString} auf den Wert {tigerResolvedString} setzen")
    @Dann(value="TGR setze den default header {tigerResolvedString} auf den Wert {tigerResolvedString}")
    public void setDefaultHeader(String header, String value) {
        TigerGlobalConfiguration.putValue((String)("tiger.httpClient.defaultHeader." + header), (String)value);
    }

    @When(value="TGR set default headers:")
    @Dann(value="TGR setze folgende default headers:")
    @Wenn(value="TGR folgende default headers gesetzt werden:")
    public void setDefaultHeaders(String docstring) {
        Arrays.stream(docstring.split("\n")).filter(line -> !line.isEmpty()).filter(line -> line.contains("=")).map(line -> List.of(StringUtils.substringBefore((String)line, (String)"="), StringUtils.substringAfter((String)line, (String)"="))).forEach(kvp -> TigerGlobalConfiguration.putValue((String)("tiger.httpClient.defaultHeader." + HttpGlueCode.resolveToString((String)kvp.get(0)).trim()), (String)HttpGlueCode.resolveToString((String)kvp.get(1)).trim()));
    }

    @When(value="TGR clear all default headers")
    @Wenn(value="TGR l\u00f6sche alle default headers")
    public void clearDefaultHeaders() {
        TigerGlobalConfiguration.readMap((String[])new String[]{KEY_TIGER, KEY_HTTP_CLIENT, KEY_DEFAULT_HEADER}).forEach((key, value) -> TigerGlobalConfiguration.listSources().stream().sorted(Comparator.comparing(source -> source.getSourceType().getPrecedence())).forEach(source -> source.removeValue(new TigerConfigurationKey(new String[]{KEY_TIGER, KEY_HTTP_CLIENT, KEY_DEFAULT_HEADER, key}))));
    }

    private Map<String, String> resolveMap(Map<String, String> map, boolean encoded) {
        return map.entrySet().stream().collect(Collectors.toMap(entry -> HttpGlueCode.resolveToString((String)entry.getKey()), entry -> encoded ? URLEncoder.encode(HttpGlueCode.resolveToString((String)entry.getValue()), StandardCharsets.UTF_8) : HttpGlueCode.resolveToString((String)entry.getValue())));
    }

    @When(value="TGR disable HttpClient followRedirects configuration")
    @Wenn(value="TGR HttpClient followRedirects Konfiguration deaktiviert")
    public void disableHttpClientFollowRedirects() {
        RedirectConfig newRedirectConfig = RestAssured.config.getRedirectConfig().followRedirects(false);
        HttpGlueCode.applyRedirectConfig(newRedirectConfig);
    }

    @When(value="TGR reset HttpClient followRedirects configuration")
    @Wenn(value="TGR HttpClient followRedirects Konfiguration zur\u00fccksetzt")
    public void resetHttpClientRedirectConfiguration() {
        HttpGlueCode.resetRedirectConfig();
    }
}

