/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.lib.proxy;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.lib.TigerLibraryException;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.awaitility.Awaitility;
import org.awaitility.core.ConditionTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbelMessageProvider
implements IRbelMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RbelMessageProvider.class);
    private final List<RbelElement> messages = new ArrayList<RbelElement>();
    private long timeoutms = 5000L;
    private boolean wait = false;

    public void triggerNewReceivedMessage(RbelElement el) {
        this.messages.add(el);
        this.wait = false;
    }

    public synchronized void waitForMessage() {
        this.wait = true;
        try {
            Awaitility.await().atMost(this.timeoutms, TimeUnit.MILLISECONDS).pollDelay(100L, TimeUnit.MILLISECONDS).until(() -> !this.wait);
        }
        catch (ConditionTimeoutException cte) {
            throw new TigerLibraryException("Timeout waiting for rbel message", new Object[]{cte});
        }
    }

    public synchronized RbelElement pullMessage() {
        if (this.messages.isEmpty()) {
            this.waitForMessage();
        }
        RbelElement el = this.messages.get(0);
        this.messages.remove(0);
        return el;
    }

    public List<RbelElement> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public void clearMessageQueue() {
        this.messages.clear();
        this.wait = false;
    }

    @Generated
    public void setTimeoutms(long timeoutms) {
        this.timeoutms = timeoutms;
    }
}

