/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.test.tiger.lib.TigerDirector;
import de.gematik.test.tiger.lib.proxy.RbelMessageProvider;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalProxyRbelMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LocalProxyRbelMessageListener.class);
    private static RbelElement lastDeletedElement = null;
    private static final List<RbelElement> rbelMessages = new ArrayList<RbelElement>();
    private static final List<RbelElement> stepRbelMessages = new ArrayList<RbelElement>();
    public static final RbelMessageProvider rbelMessageListener = new RbelMessageProvider(){

        @Override
        public void triggerNewReceivedMessage(RbelElement e) {
            rbelMessages.add(e);
            stepRbelMessages.add(e);
        }
    };

    public static void clearMessages() {
        rbelMessages.clear();
    }

    public static List<RbelElement> getMessages() {
        return Collections.unmodifiableList(rbelMessages);
    }

    public static void clearValidatableRbelMessages() {
        Deque<RbelElement> messageHistory = LocalProxyRbelMessageListener.getMessageHistoryFromTigerProxy();
        lastDeletedElement = messageHistory.isEmpty() ? null : messageHistory.getLast();
    }

    public static Deque<RbelElement> getValidatableRbelMessages() {
        return LocalProxyRbelMessageListener.getMessageHistoryFromTigerProxy().stream().dropWhile(e -> lastDeletedElement != null && e != lastDeletedElement).collect(Collectors.toCollection(ArrayDeque::new));
    }

    private static Deque<RbelElement> getMessageHistoryFromTigerProxy() {
        return TigerDirector.getTigerTestEnvMgr().getLocalTigerProxyOrFail().getRbelMessages();
    }

    @Generated
    private LocalProxyRbelMessageListener() {
    }

    @Generated
    public static List<RbelElement> getStepRbelMessages() {
        return stepRbelMessages;
    }
}

